/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.http;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.http.Pagination;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Pagination", generator="Immutables")
@Immutable
public final class ImmutablePagination
implements Pagination {
    private final Integer current;
    private final Integer last;
    @Nullable
    private final Integer previous;
    @Nullable
    private final Integer next;

    private ImmutablePagination(Integer current, Integer last, @Nullable Integer previous, @Nullable Integer next) {
        this.current = current;
        this.last = last;
        this.previous = previous;
        this.next = next;
    }

    @Override
    @JsonProperty
    public Integer current() {
        return this.current;
    }

    @Override
    @JsonProperty
    public Integer last() {
        return this.last;
    }

    @Override
    @JsonProperty
    public Optional<Integer> previous() {
        return Optional.ofNullable(this.previous);
    }

    @Override
    @JsonProperty
    public Optional<Integer> next() {
        return Optional.ofNullable(this.next);
    }

    public final ImmutablePagination withCurrent(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "current");
        if (this.current.equals(newValue)) {
            return this;
        }
        return new ImmutablePagination(newValue, this.last, this.previous, this.next);
    }

    public final ImmutablePagination withLast(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "last");
        if (this.last.equals(newValue)) {
            return this;
        }
        return new ImmutablePagination(this.current, newValue, this.previous, this.next);
    }

    public final ImmutablePagination withPrevious(int value) {
        Integer newValue = value;
        if (Objects.equals(this.previous, newValue)) {
            return this;
        }
        return new ImmutablePagination(this.current, this.last, newValue, this.next);
    }

    public final ImmutablePagination withPrevious(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.previous, value)) {
            return this;
        }
        return new ImmutablePagination(this.current, this.last, value, this.next);
    }

    public final ImmutablePagination withNext(int value) {
        Integer newValue = value;
        if (Objects.equals(this.next, newValue)) {
            return this;
        }
        return new ImmutablePagination(this.current, this.last, this.previous, newValue);
    }

    public final ImmutablePagination withNext(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.next, value)) {
            return this;
        }
        return new ImmutablePagination(this.current, this.last, this.previous, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePagination && this.equalTo(0, (ImmutablePagination)another);
    }

    private boolean equalTo(int synthetic, ImmutablePagination another) {
        return this.current.equals(another.current) && this.last.equals(another.last) && Objects.equals(this.previous, another.previous) && Objects.equals(this.next, another.next);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.current.hashCode();
        h += (h << 5) + this.last.hashCode();
        h += (h << 5) + Objects.hashCode(this.previous);
        h += (h << 5) + Objects.hashCode(this.next);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Pagination{");
        builder.append("current=").append(this.current);
        builder.append(", ");
        builder.append("last=").append(this.last);
        if (this.previous != null) {
            builder.append(", ");
            builder.append("previous=").append(this.previous);
        }
        if (this.next != null) {
            builder.append(", ");
            builder.append("next=").append(this.next);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePagination fromJson(Json json) {
        Builder builder = ImmutablePagination.builder();
        if (json.current != null) {
            builder.current(json.current);
        }
        if (json.last != null) {
            builder.last(json.last);
        }
        if (json.previous != null) {
            builder.previous(json.previous);
        }
        if (json.next != null) {
            builder.next(json.next);
        }
        return builder.build();
    }

    public static ImmutablePagination copyOf(Pagination instance) {
        if (instance instanceof ImmutablePagination) {
            return (ImmutablePagination)instance;
        }
        return ImmutablePagination.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Pagination", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CURRENT = 1L;
        private static final long INIT_BIT_LAST = 2L;
        private long initBits = 3L;
        @Nullable
        private Integer current;
        @Nullable
        private Integer last;
        @Nullable
        private Integer previous;
        @Nullable
        private Integer next;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Pagination instance) {
            Optional<Integer> nextOptional;
            Objects.requireNonNull(instance, "instance");
            this.current(instance.current());
            this.last(instance.last());
            Optional<Integer> previousOptional = instance.previous();
            if (previousOptional.isPresent()) {
                this.previous(previousOptional);
            }
            if ((nextOptional = instance.next()).isPresent()) {
                this.next(nextOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder current(Integer current) {
            this.current = Objects.requireNonNull(current, "current");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder last(Integer last) {
            this.last = Objects.requireNonNull(last, "last");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previous(int previous) {
            this.previous = previous;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder previous(Optional<Integer> previous) {
            this.previous = previous.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder next(int next) {
            this.next = next;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder next(Optional<Integer> next) {
            this.next = next.orElse(null);
            return this;
        }

        public ImmutablePagination build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePagination(this.current, this.last, this.previous, this.next);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("current");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("last");
            }
            return "Cannot build Pagination, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Pagination", generator="Immutables")
    static final class Json
    implements Pagination {
        @Nullable
        Integer current;
        @Nullable
        Integer last;
        @Nullable
        Optional<Integer> previous = Optional.empty();
        @Nullable
        Optional<Integer> next = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setCurrent(Integer current) {
            this.current = current;
        }

        @JsonProperty
        public void setLast(Integer last) {
            this.last = last;
        }

        @JsonProperty
        public void setPrevious(Optional<Integer> previous) {
            this.previous = previous;
        }

        @JsonProperty
        public void setNext(Optional<Integer> next) {
            this.next = next;
        }

        @Override
        public Integer current() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer last() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> previous() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> next() {
            throw new UnsupportedOperationException();
        }
    }
}

