/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.http.okhttp;

import com.spotify.github.http.BaseHttpResponse;
import com.spotify.github.http.HttpRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpHttpResponse
extends BaseHttpResponse {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Response response;
    private InputStream body;
    private String bodyString;

    public OkHttpHttpResponse(HttpRequest request, Response response) {
        super(request, response.code(), response.message(), response.headers().toMultimap());
        this.response = response;
    }

    @Override
    public InputStream body() {
        if (this.body == null) {
            this.body = Optional.ofNullable(this.response.body()).map(ResponseBody::byteStream).orElse(null);
        }
        return this.body;
    }

    @Override
    public String bodyString() {
        if (this.bodyString == null && this.response != null) {
            this.bodyString = OkHttpHttpResponse.responseBodyUnchecked(this.response);
        }
        return this.bodyString;
    }

    @Override
    public void close() {
        try {
            if (this.response != null) {
                if (this.response.body() != null) {
                    this.response.body().close();
                }
                this.response.close();
            }
        }
        catch (IllegalStateException e) {
            log.debug("Failed closing response: {}", (Object)e.getMessage());
        }
    }

    private static String responseBodyUnchecked(Response response) {
        String string;
        block9: {
            if (response.body() == null) {
                return null;
            }
            ResponseBody body = response.body();
            try {
                string = body.string();
                if (body == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed getting response body for: " + String.valueOf(response), e);
                }
            }
            body.close();
        }
        return string;
    }
}

