/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.tracing;

import com.spotify.github.http.HttpRequest;
import com.spotify.github.tracing.Span;
import com.spotify.github.tracing.Tracer;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

public abstract class BaseTracer
implements Tracer {
    @Override
    public Span span(String name, String method, CompletionStage<?> future) {
        return this.internalSpan(name, method, future);
    }

    @Override
    public Span span(String path, String method) {
        return this.internalSpan(path, method, null);
    }

    @Override
    public Span span(HttpRequest request) {
        Objects.requireNonNull(request);
        return this.internalSpan(request, null);
    }

    @Override
    public Span span(HttpRequest request, CompletionStage<?> future) {
        return this.internalSpan(request, future);
    }

    protected abstract Span internalSpan(String var1, String var2, CompletionStage<?> var3);

    protected abstract Span internalSpan(HttpRequest var1, CompletionStage<?> var2);

    @Override
    public void attachSpanToFuture(Span span, CompletionStage<?> future) {
        future.whenComplete((result, t) -> {
            if (t == null) {
                span.success();
            } else {
                span.failure((Throwable)t);
            }
            span.close();
        }).exceptionally(t -> {
            span.failure((Throwable)t);
            span.close();
            return null;
        });
    }
}

