/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.tracing;

import com.spotify.github.tracing.Span;
import com.spotify.github.v3.exceptions.RequestNotOkException;

public class TraceHelper {
    public static final String HEADER_CLOUD_TRACE_CONTEXT = "X-Cloud-Trace-Context";
    public static final String HEADER_TRACE_PARENT = "traceparent";
    public static final String HEADER_TRACE_STATE = "tracestate";
    public static final int NOT_FOUND = 404;
    public static final int INTERNAL_SERVER_ERROR = 500;

    private TraceHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static Span failSpan(Span span, Throwable t) {
        if (t instanceof RequestNotOkException) {
            RequestNotOkException ex = (RequestNotOkException)t;
            span.addTag("http.status_code", ex.statusCode()).addTag("message", ex.getRawMessage());
            if (ex.statusCode() - 500 >= 0) {
                span.addTag("error", true);
            }
        } else {
            if (t != null) {
                span.addTag("message", t.getMessage());
            }
            span.addTag("error", true);
        }
        return span;
    }

    public static class TraceTags {
        public static final String COMPONENT = "component";
        public static final String PEER_SERVICE = "peer.service";
        public static final String HTTP_URL = "http.url";
        public static final String HTTP_METHOD = "method";
        public static final String HTTP_STATUS_CODE = "http.status_code";
        public static final String HTTP_STATUS_MESSAGE = "http.status_message";
        public static final String ERROR_MESSAGE = "message";
        public static final String ERROR = "error";
    }
}

