/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.activity.events.MergeGroup;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MergeGroup", generator="Immutables")
@Immutable
public final class ImmutableMergeGroup
implements MergeGroup {
    @Nullable
    private final String headSha;
    @Nullable
    private final String headRef;
    @Nullable
    private final String baseSha;
    @Nullable
    private final String baseRef;

    private ImmutableMergeGroup(@Nullable String headSha, @Nullable String headRef, @Nullable String baseSha, @Nullable String baseRef) {
        this.headSha = headSha;
        this.headRef = headRef;
        this.baseSha = baseSha;
        this.baseRef = baseRef;
    }

    @Override
    @JsonProperty
    @Nullable
    public String headSha() {
        return this.headSha;
    }

    @Override
    @JsonProperty
    @Nullable
    public String headRef() {
        return this.headRef;
    }

    @Override
    @JsonProperty
    @Nullable
    public String baseSha() {
        return this.baseSha;
    }

    @Override
    @JsonProperty
    @Nullable
    public String baseRef() {
        return this.baseRef;
    }

    public final ImmutableMergeGroup withHeadSha(@Nullable String value) {
        if (Objects.equals(this.headSha, value)) {
            return this;
        }
        return new ImmutableMergeGroup(value, this.headRef, this.baseSha, this.baseRef);
    }

    public final ImmutableMergeGroup withHeadRef(@Nullable String value) {
        if (Objects.equals(this.headRef, value)) {
            return this;
        }
        return new ImmutableMergeGroup(this.headSha, value, this.baseSha, this.baseRef);
    }

    public final ImmutableMergeGroup withBaseSha(@Nullable String value) {
        if (Objects.equals(this.baseSha, value)) {
            return this;
        }
        return new ImmutableMergeGroup(this.headSha, this.headRef, value, this.baseRef);
    }

    public final ImmutableMergeGroup withBaseRef(@Nullable String value) {
        if (Objects.equals(this.baseRef, value)) {
            return this;
        }
        return new ImmutableMergeGroup(this.headSha, this.headRef, this.baseSha, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMergeGroup && this.equalTo(0, (ImmutableMergeGroup)another);
    }

    private boolean equalTo(int synthetic, ImmutableMergeGroup another) {
        return Objects.equals(this.headSha, another.headSha) && Objects.equals(this.headRef, another.headRef) && Objects.equals(this.baseSha, another.baseSha) && Objects.equals(this.baseRef, another.baseRef);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.headSha);
        h += (h << 5) + Objects.hashCode(this.headRef);
        h += (h << 5) + Objects.hashCode(this.baseSha);
        h += (h << 5) + Objects.hashCode(this.baseRef);
        return h;
    }

    public String toString() {
        return "MergeGroup{headSha=" + this.headSha + ", headRef=" + this.headRef + ", baseSha=" + this.baseSha + ", baseRef=" + this.baseRef + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMergeGroup fromJson(Json json) {
        Builder builder = ImmutableMergeGroup.builder();
        if (json.headSha != null) {
            builder.headSha(json.headSha);
        }
        if (json.headRef != null) {
            builder.headRef(json.headRef);
        }
        if (json.baseSha != null) {
            builder.baseSha(json.baseSha);
        }
        if (json.baseRef != null) {
            builder.baseRef(json.baseRef);
        }
        return builder.build();
    }

    public static ImmutableMergeGroup copyOf(MergeGroup instance) {
        if (instance instanceof ImmutableMergeGroup) {
            return (ImmutableMergeGroup)instance;
        }
        return ImmutableMergeGroup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MergeGroup", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String headSha;
        @Nullable
        private String headRef;
        @Nullable
        private String baseSha;
        @Nullable
        private String baseRef;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MergeGroup instance) {
            String baseRefValue;
            String baseShaValue;
            String headRefValue;
            Objects.requireNonNull(instance, "instance");
            String headShaValue = instance.headSha();
            if (headShaValue != null) {
                this.headSha(headShaValue);
            }
            if ((headRefValue = instance.headRef()) != null) {
                this.headRef(headRefValue);
            }
            if ((baseShaValue = instance.baseSha()) != null) {
                this.baseSha(baseShaValue);
            }
            if ((baseRefValue = instance.baseRef()) != null) {
                this.baseRef(baseRefValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder headSha(@Nullable String headSha) {
            this.headSha = headSha;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder headRef(@Nullable String headRef) {
            this.headRef = headRef;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder baseSha(@Nullable String baseSha) {
            this.baseSha = baseSha;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder baseRef(@Nullable String baseRef) {
            this.baseRef = baseRef;
            return this;
        }

        public ImmutableMergeGroup build() {
            return new ImmutableMergeGroup(this.headSha, this.headRef, this.baseSha, this.baseRef);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MergeGroup", generator="Immutables")
    static final class Json
    implements MergeGroup {
        @Nullable
        String headSha;
        @Nullable
        String headRef;
        @Nullable
        String baseSha;
        @Nullable
        String baseRef;

        Json() {
        }

        @JsonProperty
        public void setHeadSha(@Nullable String headSha) {
            this.headSha = headSha;
        }

        @JsonProperty
        public void setHeadRef(@Nullable String headRef) {
            this.headRef = headRef;
        }

        @JsonProperty
        public void setBaseSha(@Nullable String baseSha) {
            this.baseSha = baseSha;
        }

        @JsonProperty
        public void setBaseRef(@Nullable String baseRef) {
            this.baseRef = baseRef;
        }

        @Override
        public String headSha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String headRef() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String baseSha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String baseRef() {
            throw new UnsupportedOperationException();
        }
    }
}

