/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.activity.events.BaseEvent;
import com.spotify.github.v3.activity.events.EventInstallation;
import com.spotify.github.v3.activity.events.MergeGroup;
import com.spotify.github.v3.activity.events.MergeGroupEvent;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MergeGroupEvent", generator="Immutables")
@Immutable
public final class ImmutableMergeGroupEvent
implements MergeGroupEvent {
    @Nullable
    private final Repository repository;
    @Nullable
    private final User sender;
    @Nullable
    private final EventInstallation eventInstallation;
    @Nullable
    private final String action;
    @Nullable
    private final MergeGroup mergeGroup;

    private ImmutableMergeGroupEvent(@Nullable Repository repository, @Nullable User sender, @Nullable EventInstallation eventInstallation, @Nullable String action, @Nullable MergeGroup mergeGroup) {
        this.repository = repository;
        this.sender = sender;
        this.eventInstallation = eventInstallation;
        this.action = action;
        this.mergeGroup = mergeGroup;
    }

    @Override
    @JsonProperty
    @Nullable
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User sender() {
        return this.sender;
    }

    @Override
    @JsonProperty(value="installation")
    @Nullable
    public EventInstallation eventInstallation() {
        return this.eventInstallation;
    }

    @Override
    @JsonProperty
    @Nullable
    public String action() {
        return this.action;
    }

    @Override
    @JsonProperty
    @Nullable
    public MergeGroup mergeGroup() {
        return this.mergeGroup;
    }

    public final ImmutableMergeGroupEvent withRepository(@Nullable Repository value) {
        if (this.repository == value) {
            return this;
        }
        return new ImmutableMergeGroupEvent(value, this.sender, this.eventInstallation, this.action, this.mergeGroup);
    }

    public final ImmutableMergeGroupEvent withSender(@Nullable User value) {
        if (this.sender == value) {
            return this;
        }
        return new ImmutableMergeGroupEvent(this.repository, value, this.eventInstallation, this.action, this.mergeGroup);
    }

    public final ImmutableMergeGroupEvent withEventInstallation(@Nullable EventInstallation value) {
        if (this.eventInstallation == value) {
            return this;
        }
        return new ImmutableMergeGroupEvent(this.repository, this.sender, value, this.action, this.mergeGroup);
    }

    public final ImmutableMergeGroupEvent withAction(@Nullable String value) {
        if (Objects.equals(this.action, value)) {
            return this;
        }
        return new ImmutableMergeGroupEvent(this.repository, this.sender, this.eventInstallation, value, this.mergeGroup);
    }

    public final ImmutableMergeGroupEvent withMergeGroup(@Nullable MergeGroup value) {
        if (this.mergeGroup == value) {
            return this;
        }
        return new ImmutableMergeGroupEvent(this.repository, this.sender, this.eventInstallation, this.action, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMergeGroupEvent && this.equalTo(0, (ImmutableMergeGroupEvent)another);
    }

    private boolean equalTo(int synthetic, ImmutableMergeGroupEvent another) {
        return Objects.equals(this.repository, another.repository) && Objects.equals(this.sender, another.sender) && Objects.equals(this.eventInstallation, another.eventInstallation) && Objects.equals(this.action, another.action) && Objects.equals(this.mergeGroup, another.mergeGroup);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repository);
        h += (h << 5) + Objects.hashCode(this.sender);
        h += (h << 5) + Objects.hashCode(this.eventInstallation);
        h += (h << 5) + Objects.hashCode(this.action);
        h += (h << 5) + Objects.hashCode(this.mergeGroup);
        return h;
    }

    public String toString() {
        return "MergeGroupEvent{repository=" + String.valueOf(this.repository) + ", sender=" + String.valueOf(this.sender) + ", eventInstallation=" + String.valueOf(this.eventInstallation) + ", action=" + this.action + ", mergeGroup=" + String.valueOf(this.mergeGroup) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMergeGroupEvent fromJson(Json json) {
        Builder builder = ImmutableMergeGroupEvent.builder();
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.sender != null) {
            builder.sender(json.sender);
        }
        if (json.eventInstallation != null) {
            builder.eventInstallation(json.eventInstallation);
        }
        if (json.action != null) {
            builder.action(json.action);
        }
        if (json.mergeGroup != null) {
            builder.mergeGroup(json.mergeGroup);
        }
        return builder.build();
    }

    public static ImmutableMergeGroupEvent copyOf(MergeGroupEvent instance) {
        if (instance instanceof ImmutableMergeGroupEvent) {
            return (ImmutableMergeGroupEvent)instance;
        }
        return ImmutableMergeGroupEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MergeGroupEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Repository repository;
        @Nullable
        private User sender;
        @Nullable
        private EventInstallation eventInstallation;
        @Nullable
        private String action;
        @Nullable
        private MergeGroup mergeGroup;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MergeGroupEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseEvent instance;
            long bits = 0L;
            if (object instanceof MergeGroupEvent) {
                MergeGroup mergeGroupValue;
                instance = (MergeGroupEvent)object;
                String actionValue = instance.action();
                if (actionValue != null) {
                    this.action(actionValue);
                }
                if ((bits & 1L) == 0L) {
                    EventInstallation eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
                if ((mergeGroupValue = instance.mergeGroup()) != null) {
                    this.mergeGroup(mergeGroupValue);
                }
                if ((bits & 4L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    User senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof BaseEvent) {
                instance = (BaseEvent)object;
                if ((bits & 4L) == 0L) {
                    Repository repositoryValue = instance.repository();
                    if (repositoryValue != null) {
                        this.repository(repositoryValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    User senderValue = instance.sender();
                    if (senderValue != null) {
                        this.sender(senderValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    EventInstallation eventInstallationValue = instance.eventInstallation();
                    if (eventInstallationValue != null) {
                        this.eventInstallation(eventInstallationValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(@Nullable Repository repository) {
            this.repository = repository;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sender(@Nullable User sender) {
            this.sender = sender;
            return this;
        }

        @JsonProperty(value="installation")
        @CanIgnoreReturnValue
        public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder action(@Nullable String action) {
            this.action = action;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder mergeGroup(@Nullable MergeGroup mergeGroup) {
            this.mergeGroup = mergeGroup;
            return this;
        }

        public ImmutableMergeGroupEvent build() {
            return new ImmutableMergeGroupEvent(this.repository, this.sender, this.eventInstallation, this.action, this.mergeGroup);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MergeGroupEvent", generator="Immutables")
    static final class Json
    implements MergeGroupEvent {
        @Nullable
        Repository repository;
        @Nullable
        User sender;
        @Nullable
        EventInstallation eventInstallation;
        @Nullable
        String action;
        @Nullable
        MergeGroup mergeGroup;

        Json() {
        }

        @JsonProperty
        public void setRepository(@Nullable Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setSender(@Nullable User sender) {
            this.sender = sender;
        }

        @JsonProperty(value="installation")
        public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
            this.eventInstallation = eventInstallation;
        }

        @JsonProperty
        public void setAction(@Nullable String action) {
            this.action = action;
        }

        @JsonProperty
        public void setMergeGroup(@Nullable MergeGroup mergeGroup) {
            this.mergeGroup = mergeGroup;
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User sender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EventInstallation eventInstallation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String action() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MergeGroup mergeGroup() {
            throw new UnsupportedOperationException();
        }
    }
}

