/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.apps.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.apps.requests.AccessTokenRequest;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccessTokenRequest", generator="Immutables")
@Immutable
public final class ImmutableAccessTokenRequest
implements AccessTokenRequest {
    @Nullable
    private final List<String> repositories;
    @Nullable
    private final List<Integer> repositoryIds;

    private ImmutableAccessTokenRequest(@Nullable List<String> repositories, @Nullable List<Integer> repositoryIds) {
        this.repositories = repositories;
        this.repositoryIds = repositoryIds;
    }

    @Override
    @JsonProperty
    public Optional<List<String>> repositories() {
        return Optional.ofNullable(this.repositories);
    }

    @Override
    @JsonProperty(value="repository_ids")
    public Optional<List<Integer>> repositoryIds() {
        return Optional.ofNullable(this.repositoryIds);
    }

    public final ImmutableAccessTokenRequest withRepositories(List<String> value) {
        List<String> newValue = Objects.requireNonNull(value, "repositories");
        if (this.repositories == newValue) {
            return this;
        }
        return new ImmutableAccessTokenRequest(newValue, this.repositoryIds);
    }

    public final ImmutableAccessTokenRequest withRepositories(Optional<? extends List<String>> optional) {
        List value = optional.orElse(null);
        if (this.repositories == value) {
            return this;
        }
        return new ImmutableAccessTokenRequest(value, this.repositoryIds);
    }

    public final ImmutableAccessTokenRequest withRepositoryIds(List<Integer> value) {
        List<Integer> newValue = Objects.requireNonNull(value, "repositoryIds");
        if (this.repositoryIds == newValue) {
            return this;
        }
        return new ImmutableAccessTokenRequest(this.repositories, newValue);
    }

    public final ImmutableAccessTokenRequest withRepositoryIds(Optional<? extends List<Integer>> optional) {
        List value = optional.orElse(null);
        if (this.repositoryIds == value) {
            return this;
        }
        return new ImmutableAccessTokenRequest(this.repositories, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccessTokenRequest && this.equalTo(0, (ImmutableAccessTokenRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableAccessTokenRequest another) {
        return Objects.equals(this.repositories, another.repositories) && Objects.equals(this.repositoryIds, another.repositoryIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.repositories);
        h += (h << 5) + Objects.hashCode(this.repositoryIds);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AccessTokenRequest{");
        if (this.repositories != null) {
            builder.append("repositories=").append(this.repositories);
        }
        if (this.repositoryIds != null) {
            if (builder.length() > 19) {
                builder.append(", ");
            }
            builder.append("repositoryIds=").append(this.repositoryIds);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccessTokenRequest fromJson(Json json) {
        Builder builder = ImmutableAccessTokenRequest.builder();
        if (json.repositories != null) {
            builder.repositories(json.repositories);
        }
        if (json.repositoryIds != null) {
            builder.repositoryIds(json.repositoryIds);
        }
        return builder.build();
    }

    public static ImmutableAccessTokenRequest copyOf(AccessTokenRequest instance) {
        if (instance instanceof ImmutableAccessTokenRequest) {
            return (ImmutableAccessTokenRequest)instance;
        }
        return ImmutableAccessTokenRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccessTokenRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private List<String> repositories;
        @Nullable
        private List<Integer> repositoryIds;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccessTokenRequest instance) {
            Optional<List<Integer>> repositoryIdsOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<List<String>> repositoriesOptional = instance.repositories();
            if (repositoriesOptional.isPresent()) {
                this.repositories(repositoriesOptional);
            }
            if ((repositoryIdsOptional = instance.repositoryIds()).isPresent()) {
                this.repositoryIds(repositoryIdsOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repositories(List<String> repositories) {
            this.repositories = Objects.requireNonNull(repositories, "repositories");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repositories(Optional<? extends List<String>> repositories) {
            this.repositories = repositories.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repositoryIds(List<Integer> repositoryIds) {
            this.repositoryIds = Objects.requireNonNull(repositoryIds, "repositoryIds");
            return this;
        }

        @JsonProperty(value="repository_ids")
        @CanIgnoreReturnValue
        public final Builder repositoryIds(Optional<? extends List<Integer>> repositoryIds) {
            this.repositoryIds = repositoryIds.orElse(null);
            return this;
        }

        public ImmutableAccessTokenRequest build() {
            return new ImmutableAccessTokenRequest(this.repositories, this.repositoryIds);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccessTokenRequest", generator="Immutables")
    static final class Json
    implements AccessTokenRequest {
        @Nullable
        Optional<List<String>> repositories = Optional.empty();
        @Nullable
        Optional<List<Integer>> repositoryIds = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setRepositories(Optional<List<String>> repositories) {
            this.repositories = repositories;
        }

        @JsonProperty(value="repository_ids")
        public void setRepositoryIds(Optional<List<Integer>> repositoryIds) {
            this.repositoryIds = repositoryIds;
        }

        @Override
        public Optional<List<String>> repositories() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<Integer>> repositoryIds() {
            throw new UnsupportedOperationException();
        }
    }
}

