/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.checks.App;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="App", generator="Immutables")
@Immutable
public final class ImmutableApp
implements App {
    private final Integer id;
    @Nullable
    private final String slug;
    private final String name;
    private final String description;
    private final String externalUrl;
    private final String htmlUrl;
    private final ZonedDateTime createdAt;
    private final ZonedDateTime updatedAt;
    private final Map<String, String> permissions;
    private final List<String> events;
    @Nullable
    private final Integer installationsCount;
    @Nullable
    private final String clientId;
    @Nullable
    private final String singleFileName;
    @Nullable
    private final Boolean hasMultipleSingleFiles;
    @Nullable
    private final List<String> singleFilePaths;
    @Nullable
    private final String appSlug;
    @Nullable
    private final ZonedDateTime suspendedAt;
    @Nullable
    private final User suspendedBy;

    private ImmutableApp(Integer id, @Nullable String slug, String name, String description, String externalUrl, String htmlUrl, ZonedDateTime createdAt, ZonedDateTime updatedAt, Map<String, String> permissions, List<String> events, @Nullable Integer installationsCount, @Nullable String clientId, @Nullable String singleFileName, @Nullable Boolean hasMultipleSingleFiles, @Nullable List<String> singleFilePaths, @Nullable String appSlug, @Nullable ZonedDateTime suspendedAt, @Nullable User suspendedBy) {
        this.id = id;
        this.slug = slug;
        this.name = name;
        this.description = description;
        this.externalUrl = externalUrl;
        this.htmlUrl = htmlUrl;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.permissions = permissions;
        this.events = events;
        this.installationsCount = installationsCount;
        this.clientId = clientId;
        this.singleFileName = singleFileName;
        this.hasMultipleSingleFiles = hasMultipleSingleFiles;
        this.singleFilePaths = singleFilePaths;
        this.appSlug = appSlug;
        this.suspendedAt = suspendedAt;
        this.suspendedBy = suspendedBy;
    }

    @Override
    @JsonProperty
    public Integer id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public Optional<String> slug() {
        return Optional.ofNullable(this.slug);
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty
    public String externalUrl() {
        return this.externalUrl;
    }

    @Override
    @JsonProperty
    public String htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    public ZonedDateTime createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    public ZonedDateTime updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    public Map<String, String> permissions() {
        return this.permissions;
    }

    @Override
    @JsonProperty
    public List<String> events() {
        return this.events;
    }

    @Override
    @JsonProperty
    public Optional<Integer> installationsCount() {
        return Optional.ofNullable(this.installationsCount);
    }

    @Override
    @JsonProperty
    public Optional<String> clientId() {
        return Optional.ofNullable(this.clientId);
    }

    @Override
    @JsonProperty
    public Optional<String> singleFileName() {
        return Optional.ofNullable(this.singleFileName);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> hasMultipleSingleFiles() {
        return Optional.ofNullable(this.hasMultipleSingleFiles);
    }

    @Override
    @JsonProperty
    public Optional<List<String>> singleFilePaths() {
        return Optional.ofNullable(this.singleFilePaths);
    }

    @Override
    @JsonProperty
    public Optional<String> appSlug() {
        return Optional.ofNullable(this.appSlug);
    }

    @Override
    @JsonProperty
    public Optional<ZonedDateTime> suspendedAt() {
        return Optional.ofNullable(this.suspendedAt);
    }

    @Override
    @JsonProperty
    public Optional<User> suspendedBy() {
        return Optional.ofNullable(this.suspendedBy);
    }

    public final ImmutableApp withId(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableApp(newValue, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withSlug(String value) {
        String newValue = Objects.requireNonNull(value, "slug");
        if (Objects.equals(this.slug, newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, newValue, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withSlug(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.slug, value)) {
            return this;
        }
        return new ImmutableApp(this.id, value, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, newValue, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, newValue, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withExternalUrl(String value) {
        String newValue = Objects.requireNonNull(value, "externalUrl");
        if (this.externalUrl.equals(newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, newValue, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withHtmlUrl(String value) {
        String newValue = Objects.requireNonNull(value, "htmlUrl");
        if (this.htmlUrl.equals(newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, newValue, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withCreatedAt(ZonedDateTime value) {
        if (this.createdAt == value) {
            return this;
        }
        ZonedDateTime newValue = Objects.requireNonNull(value, "createdAt");
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, newValue, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withUpdatedAt(ZonedDateTime value) {
        if (this.updatedAt == value) {
            return this;
        }
        ZonedDateTime newValue = Objects.requireNonNull(value, "updatedAt");
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, newValue, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withPermissions(Map<String, ? extends String> entries) {
        if (this.permissions == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableApp.createUnmodifiableMap(true, false, entries);
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, newValue, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withEvents(String ... elements) {
        List<String> newValue = ImmutableApp.createUnmodifiableList(false, ImmutableApp.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, newValue, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withEvents(Iterable<String> elements) {
        if (this.events == elements) {
            return this;
        }
        List<String> newValue = ImmutableApp.createUnmodifiableList(false, ImmutableApp.createSafeList(elements, true, false));
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, newValue, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withInstallationsCount(int value) {
        Integer newValue = value;
        if (Objects.equals(this.installationsCount, newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, newValue, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withInstallationsCount(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.installationsCount, value)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, value, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withClientId(String value) {
        String newValue = Objects.requireNonNull(value, "clientId");
        if (Objects.equals(this.clientId, newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, newValue, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withClientId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, value, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withSingleFileName(String value) {
        String newValue = Objects.requireNonNull(value, "singleFileName");
        if (Objects.equals(this.singleFileName, newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, newValue, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withSingleFileName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.singleFileName, value)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, value, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withHasMultipleSingleFiles(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.hasMultipleSingleFiles, newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, newValue, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withHasMultipleSingleFiles(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.hasMultipleSingleFiles, value)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, value, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withSingleFilePaths(List<String> value) {
        List<String> newValue = Objects.requireNonNull(value, "singleFilePaths");
        if (this.singleFilePaths == newValue) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, newValue, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withSingleFilePaths(Optional<? extends List<String>> optional) {
        List value = optional.orElse(null);
        if (this.singleFilePaths == value) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, value, this.appSlug, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withAppSlug(String value) {
        String newValue = Objects.requireNonNull(value, "appSlug");
        if (Objects.equals(this.appSlug, newValue)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, newValue, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withAppSlug(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.appSlug, value)) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, value, this.suspendedAt, this.suspendedBy);
    }

    public final ImmutableApp withSuspendedAt(ZonedDateTime value) {
        ZonedDateTime newValue = Objects.requireNonNull(value, "suspendedAt");
        if (this.suspendedAt == newValue) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, newValue, this.suspendedBy);
    }

    public final ImmutableApp withSuspendedAt(Optional<? extends ZonedDateTime> optional) {
        ZonedDateTime value = optional.orElse(null);
        if (this.suspendedAt == value) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, value, this.suspendedBy);
    }

    public final ImmutableApp withSuspendedBy(User value) {
        User newValue = Objects.requireNonNull(value, "suspendedBy");
        if (this.suspendedBy == newValue) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, newValue);
    }

    public final ImmutableApp withSuspendedBy(Optional<? extends User> optional) {
        User value = optional.orElse(null);
        if (this.suspendedBy == value) {
            return this;
        }
        return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, this.permissions, this.events, this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApp && this.equalTo(0, (ImmutableApp)another);
    }

    private boolean equalTo(int synthetic, ImmutableApp another) {
        return this.id.equals(another.id) && Objects.equals(this.slug, another.slug) && this.name.equals(another.name) && this.description.equals(another.description) && this.externalUrl.equals(another.externalUrl) && this.htmlUrl.equals(another.htmlUrl) && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && this.permissions.equals(another.permissions) && this.events.equals(another.events) && Objects.equals(this.installationsCount, another.installationsCount) && Objects.equals(this.clientId, another.clientId) && Objects.equals(this.singleFileName, another.singleFileName) && Objects.equals(this.hasMultipleSingleFiles, another.hasMultipleSingleFiles) && Objects.equals(this.singleFilePaths, another.singleFilePaths) && Objects.equals(this.appSlug, another.appSlug) && Objects.equals(this.suspendedAt, another.suspendedAt) && Objects.equals(this.suspendedBy, another.suspendedBy);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.slug);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.externalUrl.hashCode();
        h += (h << 5) + this.htmlUrl.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.updatedAt.hashCode();
        h += (h << 5) + this.permissions.hashCode();
        h += (h << 5) + this.events.hashCode();
        h += (h << 5) + Objects.hashCode(this.installationsCount);
        h += (h << 5) + Objects.hashCode(this.clientId);
        h += (h << 5) + Objects.hashCode(this.singleFileName);
        h += (h << 5) + Objects.hashCode(this.hasMultipleSingleFiles);
        h += (h << 5) + Objects.hashCode(this.singleFilePaths);
        h += (h << 5) + Objects.hashCode(this.appSlug);
        h += (h << 5) + Objects.hashCode(this.suspendedAt);
        h += (h << 5) + Objects.hashCode(this.suspendedBy);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("App{");
        builder.append("id=").append(this.id);
        if (this.slug != null) {
            builder.append(", ");
            builder.append("slug=").append(this.slug);
        }
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("description=").append(this.description);
        builder.append(", ");
        builder.append("externalUrl=").append(this.externalUrl);
        builder.append(", ");
        builder.append("htmlUrl=").append(this.htmlUrl);
        builder.append(", ");
        builder.append("createdAt=").append(this.createdAt);
        builder.append(", ");
        builder.append("updatedAt=").append(this.updatedAt);
        builder.append(", ");
        builder.append("permissions=").append(this.permissions);
        builder.append(", ");
        builder.append("events=").append(this.events);
        if (this.installationsCount != null) {
            builder.append(", ");
            builder.append("installationsCount=").append(this.installationsCount);
        }
        if (this.clientId != null) {
            builder.append(", ");
            builder.append("clientId=").append(this.clientId);
        }
        if (this.singleFileName != null) {
            builder.append(", ");
            builder.append("singleFileName=").append(this.singleFileName);
        }
        if (this.hasMultipleSingleFiles != null) {
            builder.append(", ");
            builder.append("hasMultipleSingleFiles=").append(this.hasMultipleSingleFiles);
        }
        if (this.singleFilePaths != null) {
            builder.append(", ");
            builder.append("singleFilePaths=").append(this.singleFilePaths);
        }
        if (this.appSlug != null) {
            builder.append(", ");
            builder.append("appSlug=").append(this.appSlug);
        }
        if (this.suspendedAt != null) {
            builder.append(", ");
            builder.append("suspendedAt=").append(this.suspendedAt);
        }
        if (this.suspendedBy != null) {
            builder.append(", ");
            builder.append("suspendedBy=").append(this.suspendedBy);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableApp fromJson(Json json) {
        Builder builder = ImmutableApp.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.slug != null) {
            builder.slug(json.slug);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.externalUrl != null) {
            builder.externalUrl(json.externalUrl);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.permissions != null) {
            builder.putAllPermissions(json.permissions);
        }
        if (json.events != null) {
            builder.addAllEvents(json.events);
        }
        if (json.installationsCount != null) {
            builder.installationsCount(json.installationsCount);
        }
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        if (json.singleFileName != null) {
            builder.singleFileName(json.singleFileName);
        }
        if (json.hasMultipleSingleFiles != null) {
            builder.hasMultipleSingleFiles(json.hasMultipleSingleFiles);
        }
        if (json.singleFilePaths != null) {
            builder.singleFilePaths(json.singleFilePaths);
        }
        if (json.appSlug != null) {
            builder.appSlug(json.appSlug);
        }
        if (json.suspendedAt != null) {
            builder.suspendedAt(json.suspendedAt);
        }
        if (json.suspendedBy != null) {
            builder.suspendedBy(json.suspendedBy);
        }
        return builder.build();
    }

    public static ImmutableApp copyOf(App instance) {
        if (instance instanceof ImmutableApp) {
            return (ImmutableApp)instance;
        }
        return ImmutableApp.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + String.valueOf(k));
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + String.valueOf(k));
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="App", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_DESCRIPTION = 4L;
        private static final long INIT_BIT_EXTERNAL_URL = 8L;
        private static final long INIT_BIT_HTML_URL = 16L;
        private static final long INIT_BIT_CREATED_AT = 32L;
        private static final long INIT_BIT_UPDATED_AT = 64L;
        private long initBits = 127L;
        @Nullable
        private Integer id;
        @Nullable
        private String slug;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String externalUrl;
        @Nullable
        private String htmlUrl;
        @Nullable
        private ZonedDateTime createdAt;
        @Nullable
        private ZonedDateTime updatedAt;
        private Map<String, String> permissions = new LinkedHashMap<String, String>();
        private List<String> events = new ArrayList<String>();
        @Nullable
        private Integer installationsCount;
        @Nullable
        private String clientId;
        @Nullable
        private String singleFileName;
        @Nullable
        private Boolean hasMultipleSingleFiles;
        @Nullable
        private List<String> singleFilePaths;
        @Nullable
        private String appSlug;
        @Nullable
        private ZonedDateTime suspendedAt;
        @Nullable
        private User suspendedBy;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(App instance) {
            Optional<User> suspendedByOptional;
            Optional<ZonedDateTime> suspendedAtOptional;
            Optional<String> appSlugOptional;
            Optional<List<String>> singleFilePathsOptional;
            Optional<Boolean> hasMultipleSingleFilesOptional;
            Optional<String> singleFileNameOptional;
            Optional<String> clientIdOptional;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            Optional<String> slugOptional = instance.slug();
            if (slugOptional.isPresent()) {
                this.slug(slugOptional);
            }
            this.name(instance.name());
            this.description(instance.description());
            this.externalUrl(instance.externalUrl());
            this.htmlUrl(instance.htmlUrl());
            this.createdAt(instance.createdAt());
            this.updatedAt(instance.updatedAt());
            this.putAllPermissions(instance.permissions());
            this.addAllEvents(instance.events());
            Optional<Integer> installationsCountOptional = instance.installationsCount();
            if (installationsCountOptional.isPresent()) {
                this.installationsCount(installationsCountOptional);
            }
            if ((clientIdOptional = instance.clientId()).isPresent()) {
                this.clientId(clientIdOptional);
            }
            if ((singleFileNameOptional = instance.singleFileName()).isPresent()) {
                this.singleFileName(singleFileNameOptional);
            }
            if ((hasMultipleSingleFilesOptional = instance.hasMultipleSingleFiles()).isPresent()) {
                this.hasMultipleSingleFiles(hasMultipleSingleFilesOptional);
            }
            if ((singleFilePathsOptional = instance.singleFilePaths()).isPresent()) {
                this.singleFilePaths(singleFilePathsOptional);
            }
            if ((appSlugOptional = instance.appSlug()).isPresent()) {
                this.appSlug(appSlugOptional);
            }
            if ((suspendedAtOptional = instance.suspendedAt()).isPresent()) {
                this.suspendedAt(suspendedAtOptional);
            }
            if ((suspendedByOptional = instance.suspendedBy()).isPresent()) {
                this.suspendedBy(suspendedByOptional);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(Integer id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder slug(String slug) {
            this.slug = Objects.requireNonNull(slug, "slug");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder slug(Optional<String> slug) {
            this.slug = slug.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder externalUrl(String externalUrl) {
            this.externalUrl = Objects.requireNonNull(externalUrl, "externalUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(String htmlUrl) {
            this.htmlUrl = Objects.requireNonNull(htmlUrl, "htmlUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(ZonedDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putPermissions(String key, String value) {
            this.permissions.put(Objects.requireNonNull(key, "permissions key"), value == null ? Objects.requireNonNull(value, "permissions value for key: " + key) : value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putPermissions(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.permissions.put(Objects.requireNonNull(k, "permissions key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "permissions value for key: " + k) : v);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder permissions(Map<String, ? extends String> entries) {
            this.permissions.clear();
            return this.putAllPermissions(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllPermissions(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.permissions.put(Objects.requireNonNull(k, "permissions key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "permissions value for key: " + k) : v);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEvents(String element) {
            this.events.add(Objects.requireNonNull(element, "events element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEvents(String ... elements) {
            for (String element : elements) {
                this.events.add(Objects.requireNonNull(element, "events element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder events(Iterable<String> elements) {
            this.events.clear();
            return this.addAllEvents(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEvents(Iterable<String> elements) {
            for (String element : elements) {
                this.events.add(Objects.requireNonNull(element, "events element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder installationsCount(int installationsCount) {
            this.installationsCount = installationsCount;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder installationsCount(Optional<Integer> installationsCount) {
            this.installationsCount = installationsCount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder clientId(Optional<String> clientId) {
            this.clientId = clientId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder singleFileName(String singleFileName) {
            this.singleFileName = Objects.requireNonNull(singleFileName, "singleFileName");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder singleFileName(Optional<String> singleFileName) {
            this.singleFileName = singleFileName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasMultipleSingleFiles(boolean hasMultipleSingleFiles) {
            this.hasMultipleSingleFiles = hasMultipleSingleFiles;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder hasMultipleSingleFiles(Optional<Boolean> hasMultipleSingleFiles) {
            this.hasMultipleSingleFiles = hasMultipleSingleFiles.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder singleFilePaths(List<String> singleFilePaths) {
            this.singleFilePaths = Objects.requireNonNull(singleFilePaths, "singleFilePaths");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder singleFilePaths(Optional<? extends List<String>> singleFilePaths) {
            this.singleFilePaths = singleFilePaths.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder appSlug(String appSlug) {
            this.appSlug = Objects.requireNonNull(appSlug, "appSlug");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder appSlug(Optional<String> appSlug) {
            this.appSlug = appSlug.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder suspendedAt(ZonedDateTime suspendedAt) {
            this.suspendedAt = Objects.requireNonNull(suspendedAt, "suspendedAt");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder suspendedAt(Optional<? extends ZonedDateTime> suspendedAt) {
            this.suspendedAt = suspendedAt.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder suspendedBy(User suspendedBy) {
            this.suspendedBy = Objects.requireNonNull(suspendedBy, "suspendedBy");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder suspendedBy(Optional<? extends User> suspendedBy) {
            this.suspendedBy = suspendedBy.orElse(null);
            return this;
        }

        public ImmutableApp build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableApp(this.id, this.slug, this.name, this.description, this.externalUrl, this.htmlUrl, this.createdAt, this.updatedAt, ImmutableApp.createUnmodifiableMap(false, false, this.permissions), ImmutableApp.createUnmodifiableList(true, this.events), this.installationsCount, this.clientId, this.singleFileName, this.hasMultipleSingleFiles, this.singleFilePaths, this.appSlug, this.suspendedAt, this.suspendedBy);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("externalUrl");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("htmlUrl");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("updatedAt");
            }
            return "Cannot build App, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="App", generator="Immutables")
    static final class Json
    implements App {
        @Nullable
        Integer id;
        @Nullable
        Optional<String> slug = Optional.empty();
        @Nullable
        String name;
        @Nullable
        String description;
        @Nullable
        String externalUrl;
        @Nullable
        String htmlUrl;
        @Nullable
        ZonedDateTime createdAt;
        @Nullable
        ZonedDateTime updatedAt;
        @Nullable
        Map<String, String> permissions = Collections.emptyMap();
        @Nullable
        List<String> events = Collections.emptyList();
        @Nullable
        Optional<Integer> installationsCount = Optional.empty();
        @Nullable
        Optional<String> clientId = Optional.empty();
        @Nullable
        Optional<String> singleFileName = Optional.empty();
        @Nullable
        Optional<Boolean> hasMultipleSingleFiles = Optional.empty();
        @Nullable
        Optional<List<String>> singleFilePaths = Optional.empty();
        @Nullable
        Optional<String> appSlug = Optional.empty();
        @Nullable
        Optional<ZonedDateTime> suspendedAt = Optional.empty();
        @Nullable
        Optional<User> suspendedBy = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(Integer id) {
            this.id = id;
        }

        @JsonProperty
        public void setSlug(Optional<String> slug) {
            this.slug = slug;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty
        public void setExternalUrl(String externalUrl) {
            this.externalUrl = externalUrl;
        }

        @JsonProperty
        public void setHtmlUrl(String htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setCreatedAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setPermissions(Map<String, String> permissions) {
            this.permissions = permissions;
        }

        @JsonProperty
        public void setEvents(List<String> events) {
            this.events = events;
        }

        @JsonProperty
        public void setInstallationsCount(Optional<Integer> installationsCount) {
            this.installationsCount = installationsCount;
        }

        @JsonProperty
        public void setClientId(Optional<String> clientId) {
            this.clientId = clientId;
        }

        @JsonProperty
        public void setSingleFileName(Optional<String> singleFileName) {
            this.singleFileName = singleFileName;
        }

        @JsonProperty
        public void setHasMultipleSingleFiles(Optional<Boolean> hasMultipleSingleFiles) {
            this.hasMultipleSingleFiles = hasMultipleSingleFiles;
        }

        @JsonProperty
        public void setSingleFilePaths(Optional<List<String>> singleFilePaths) {
            this.singleFilePaths = singleFilePaths;
        }

        @JsonProperty
        public void setAppSlug(Optional<String> appSlug) {
            this.appSlug = appSlug;
        }

        @JsonProperty
        public void setSuspendedAt(Optional<ZonedDateTime> suspendedAt) {
            this.suspendedAt = suspendedAt;
        }

        @JsonProperty
        public void setSuspendedBy(Optional<User> suspendedBy) {
            this.suspendedBy = suspendedBy;
        }

        @Override
        public Integer id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> slug() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String externalUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZonedDateTime createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZonedDateTime updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> permissions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> events() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> installationsCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> clientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> singleFileName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> hasMultipleSingleFiles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> singleFilePaths() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> appSlug() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ZonedDateTime> suspendedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<User> suspendedBy() {
            throw new UnsupportedOperationException();
        }
    }
}

