/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.checks.App;
import com.spotify.github.v3.checks.CheckSuite;
import com.spotify.github.v3.prs.PartialPullRequestItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CheckSuite", generator="Immutables")
@Immutable
public final class ImmutableCheckSuite
implements CheckSuite {
    private final Long id;
    @Nullable
    private final App app;
    @Nullable
    private final String headBranch;
    private final List<PartialPullRequestItem> pullRequests;

    private ImmutableCheckSuite(Long id, @Nullable App app, @Nullable String headBranch, List<PartialPullRequestItem> pullRequests) {
        this.id = id;
        this.app = app;
        this.headBranch = headBranch;
        this.pullRequests = pullRequests;
    }

    @Override
    @JsonProperty
    public Long id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public Optional<App> app() {
        return Optional.ofNullable(this.app);
    }

    @Override
    @JsonProperty
    public Optional<String> headBranch() {
        return Optional.ofNullable(this.headBranch);
    }

    @Override
    @JsonProperty
    public List<PartialPullRequestItem> pullRequests() {
        return this.pullRequests;
    }

    public final ImmutableCheckSuite withId(Long value) {
        Long newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckSuite(newValue, this.app, this.headBranch, this.pullRequests);
    }

    public final ImmutableCheckSuite withApp(App value) {
        App newValue = Objects.requireNonNull(value, "app");
        if (this.app == newValue) {
            return this;
        }
        return new ImmutableCheckSuite(this.id, newValue, this.headBranch, this.pullRequests);
    }

    public final ImmutableCheckSuite withApp(Optional<? extends App> optional) {
        App value = optional.orElse(null);
        if (this.app == value) {
            return this;
        }
        return new ImmutableCheckSuite(this.id, value, this.headBranch, this.pullRequests);
    }

    public final ImmutableCheckSuite withHeadBranch(String value) {
        String newValue = Objects.requireNonNull(value, "headBranch");
        if (Objects.equals(this.headBranch, newValue)) {
            return this;
        }
        return new ImmutableCheckSuite(this.id, this.app, newValue, this.pullRequests);
    }

    public final ImmutableCheckSuite withHeadBranch(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.headBranch, value)) {
            return this;
        }
        return new ImmutableCheckSuite(this.id, this.app, value, this.pullRequests);
    }

    public final ImmutableCheckSuite withPullRequests(PartialPullRequestItem ... elements) {
        List<PartialPullRequestItem> newValue = ImmutableCheckSuite.createUnmodifiableList(false, ImmutableCheckSuite.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCheckSuite(this.id, this.app, this.headBranch, newValue);
    }

    public final ImmutableCheckSuite withPullRequests(Iterable<? extends PartialPullRequestItem> elements) {
        if (this.pullRequests == elements) {
            return this;
        }
        List<PartialPullRequestItem> newValue = ImmutableCheckSuite.createUnmodifiableList(false, ImmutableCheckSuite.createSafeList(elements, true, false));
        return new ImmutableCheckSuite(this.id, this.app, this.headBranch, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckSuite && this.equalTo(0, (ImmutableCheckSuite)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckSuite another) {
        return this.id.equals(another.id) && Objects.equals(this.app, another.app) && Objects.equals(this.headBranch, another.headBranch) && this.pullRequests.equals(another.pullRequests);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.app);
        h += (h << 5) + Objects.hashCode(this.headBranch);
        h += (h << 5) + this.pullRequests.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CheckSuite{");
        builder.append("id=").append(this.id);
        if (this.app != null) {
            builder.append(", ");
            builder.append("app=").append(this.app);
        }
        if (this.headBranch != null) {
            builder.append(", ");
            builder.append("headBranch=").append(this.headBranch);
        }
        builder.append(", ");
        builder.append("pullRequests=").append(this.pullRequests);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCheckSuite fromJson(Json json) {
        Builder builder = ImmutableCheckSuite.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.app != null) {
            builder.app(json.app);
        }
        if (json.headBranch != null) {
            builder.headBranch(json.headBranch);
        }
        if (json.pullRequests != null) {
            builder.addAllPullRequests(json.pullRequests);
        }
        return builder.build();
    }

    public static ImmutableCheckSuite copyOf(CheckSuite instance) {
        if (instance instanceof ImmutableCheckSuite) {
            return (ImmutableCheckSuite)instance;
        }
        return ImmutableCheckSuite.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CheckSuite", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private Long id;
        @Nullable
        private App app;
        @Nullable
        private String headBranch;
        private List<PartialPullRequestItem> pullRequests = new ArrayList<PartialPullRequestItem>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CheckSuite instance) {
            Optional<String> headBranchOptional;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            Optional<App> appOptional = instance.app();
            if (appOptional.isPresent()) {
                this.app(appOptional);
            }
            if ((headBranchOptional = instance.headBranch()).isPresent()) {
                this.headBranch(headBranchOptional);
            }
            this.addAllPullRequests(instance.pullRequests());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(Long id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder app(App app) {
            this.app = Objects.requireNonNull(app, "app");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder app(Optional<? extends App> app) {
            this.app = app.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headBranch(String headBranch) {
            this.headBranch = Objects.requireNonNull(headBranch, "headBranch");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder headBranch(Optional<String> headBranch) {
            this.headBranch = headBranch.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPullRequests(PartialPullRequestItem element) {
            this.pullRequests.add(Objects.requireNonNull(element, "pullRequests element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPullRequests(PartialPullRequestItem ... elements) {
            for (PartialPullRequestItem element : elements) {
                this.pullRequests.add(Objects.requireNonNull(element, "pullRequests element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pullRequests(Iterable<? extends PartialPullRequestItem> elements) {
            this.pullRequests.clear();
            return this.addAllPullRequests(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPullRequests(Iterable<? extends PartialPullRequestItem> elements) {
            for (PartialPullRequestItem partialPullRequestItem : elements) {
                this.pullRequests.add(Objects.requireNonNull(partialPullRequestItem, "pullRequests element"));
            }
            return this;
        }

        public ImmutableCheckSuite build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckSuite(this.id, this.app, this.headBranch, ImmutableCheckSuite.createUnmodifiableList(true, this.pullRequests));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build CheckSuite, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CheckSuite", generator="Immutables")
    static final class Json
    implements CheckSuite {
        @Nullable
        Long id;
        @Nullable
        Optional<App> app = Optional.empty();
        @Nullable
        Optional<String> headBranch = Optional.empty();
        @Nullable
        List<PartialPullRequestItem> pullRequests = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setId(Long id) {
            this.id = id;
        }

        @JsonProperty
        public void setApp(Optional<App> app) {
            this.app = app;
        }

        @JsonProperty
        public void setHeadBranch(Optional<String> headBranch) {
            this.headBranch = headBranch;
        }

        @JsonProperty
        public void setPullRequests(List<PartialPullRequestItem> pullRequests) {
            this.pullRequests = pullRequests;
        }

        @Override
        public Long id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<App> app() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> headBranch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PartialPullRequestItem> pullRequests() {
            throw new UnsupportedOperationException();
        }
    }
}

