/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.checks.Installation;
import com.spotify.github.v3.checks.InstallationList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InstallationList", generator="Immutables")
@Immutable
public final class ImmutableInstallationList
implements InstallationList {
    private final int totalCount;
    private final List<Installation> installations;

    private ImmutableInstallationList(int totalCount, List<Installation> installations) {
        this.totalCount = totalCount;
        this.installations = installations;
    }

    @Override
    @JsonProperty
    public int totalCount() {
        return this.totalCount;
    }

    @Override
    @JsonProperty
    public List<Installation> installations() {
        return this.installations;
    }

    public final ImmutableInstallationList withTotalCount(int value) {
        if (this.totalCount == value) {
            return this;
        }
        return new ImmutableInstallationList(value, this.installations);
    }

    public final ImmutableInstallationList withInstallations(Installation ... elements) {
        List<Installation> newValue = ImmutableInstallationList.createUnmodifiableList(false, ImmutableInstallationList.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableInstallationList(this.totalCount, newValue);
    }

    public final ImmutableInstallationList withInstallations(Iterable<? extends Installation> elements) {
        if (this.installations == elements) {
            return this;
        }
        List<Installation> newValue = ImmutableInstallationList.createUnmodifiableList(false, ImmutableInstallationList.createSafeList(elements, true, false));
        return new ImmutableInstallationList(this.totalCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInstallationList && this.equalTo(0, (ImmutableInstallationList)another);
    }

    private boolean equalTo(int synthetic, ImmutableInstallationList another) {
        return this.totalCount == another.totalCount && this.installations.equals(another.installations);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.totalCount;
        h += (h << 5) + this.installations.hashCode();
        return h;
    }

    public String toString() {
        return "InstallationList{totalCount=" + this.totalCount + ", installations=" + String.valueOf(this.installations) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableInstallationList fromJson(Json json) {
        Builder builder = ImmutableInstallationList.builder();
        if (json.totalCountIsSet) {
            builder.totalCount(json.totalCount);
        }
        if (json.installations != null) {
            builder.addAllInstallations(json.installations);
        }
        return builder.build();
    }

    public static ImmutableInstallationList copyOf(InstallationList instance) {
        if (instance instanceof ImmutableInstallationList) {
            return (ImmutableInstallationList)instance;
        }
        return ImmutableInstallationList.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="InstallationList", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOTAL_COUNT = 1L;
        private long initBits = 1L;
        private int totalCount;
        private List<Installation> installations = new ArrayList<Installation>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(InstallationList instance) {
            Objects.requireNonNull(instance, "instance");
            this.totalCount(instance.totalCount());
            this.addAllInstallations(instance.installations());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder totalCount(int totalCount) {
            this.totalCount = totalCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInstallations(Installation element) {
            this.installations.add(Objects.requireNonNull(element, "installations element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInstallations(Installation ... elements) {
            for (Installation element : elements) {
                this.installations.add(Objects.requireNonNull(element, "installations element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder installations(Iterable<? extends Installation> elements) {
            this.installations.clear();
            return this.addAllInstallations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInstallations(Iterable<? extends Installation> elements) {
            for (Installation installation : elements) {
                this.installations.add(Objects.requireNonNull(installation, "installations element"));
            }
            return this;
        }

        public ImmutableInstallationList build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInstallationList(this.totalCount, ImmutableInstallationList.createUnmodifiableList(true, this.installations));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("totalCount");
            }
            return "Cannot build InstallationList, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="InstallationList", generator="Immutables")
    static final class Json
    implements InstallationList {
        int totalCount;
        boolean totalCountIsSet;
        @Nullable
        List<Installation> installations = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
            this.totalCountIsSet = true;
        }

        @JsonProperty
        public void setInstallations(List<Installation> installations) {
            this.installations = installations;
        }

        @Override
        public int totalCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Installation> installations() {
            throw new UnsupportedOperationException();
        }
    }
}

