/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.spotify.github.async.AsyncPage;
import com.spotify.github.http.ImmutablePagination;
import com.spotify.github.http.Link;
import com.spotify.github.http.Pagination;
import com.spotify.github.v3.clients.GitHubClient;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URIBuilder;

public class GithubPage<T>
implements AsyncPage<T> {
    static final int ITEM_PER_PAGE_DEFAULT = 30;
    private final GitHubClient github;
    private final String path;
    private final TypeReference<List<T>> typeReference;
    private final int itemsPerPage;

    protected static String formatPath(String path, int itemsPerPage) {
        try {
            URIBuilder uriBuilder = new URIBuilder(path);
            if (uriBuilder.getQueryParams().stream().anyMatch(p -> p.getName().equals("per_page"))) {
                return path;
            }
            uriBuilder.addParameter("per_page", Integer.toString(itemsPerPage));
            return uriBuilder.toString();
        }
        catch (Exception e) {
            return path;
        }
    }

    GithubPage(GitHubClient github, String path, TypeReference<List<T>> typeReference) {
        this.itemsPerPage = 30;
        this.github = github;
        this.path = GithubPage.formatPath(path, 30);
        this.typeReference = typeReference;
    }

    GithubPage(GitHubClient github, String path, TypeReference<List<T>> typeReference, int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
        this.github = github;
        this.path = GithubPage.formatPath(path, itemsPerPage);
        this.typeReference = typeReference;
    }

    @Override
    public CompletableFuture<Pagination> pagination() {
        return this.linkMapAsync().thenApply(linkMap -> {
            Optional<Integer> maybePreviousPageNumber = Optional.ofNullable((Link)linkMap.get("prev")).map(prevLink -> GithubPage.pageNumberFromUri(prevLink.url().toString() + "1").orElse(1));
            Optional<Integer> maybeNextPageNumber = Optional.ofNullable((Link)linkMap.get("next")).map(prevLink -> GithubPage.pageNumberFromUri(prevLink.url().toString()).orElseThrow(() -> new RuntimeException("Could not parse page number from Link header with rel=\"next\"")));
            Integer lastPageNumber = maybePreviousPageNumber.map(pageNumber -> pageNumber + 1).orElseGet(() -> Optional.ofNullable((Link)linkMap.get("last")).map(lastLink -> GithubPage.pageNumberFromUri(lastLink.url().toString()).orElseThrow(() -> new RuntimeException("Could not parse page number from Link header with rel=\"last\""))).orElse(1));
            Integer currentPageNumber = maybeNextPageNumber.map(pageNumber -> pageNumber - 1).orElse(lastPageNumber);
            ImmutablePagination.Builder builder = ImmutablePagination.builder().current(currentPageNumber).last(lastPageNumber);
            maybePreviousPageNumber.ifPresent(builder::previous);
            maybeNextPageNumber.ifPresent(builder::next);
            return builder.build();
        });
    }

    @Override
    public CompletableFuture<AsyncPage<T>> nextPage() {
        return this.linkMapAsync().thenApply(linkMap -> {
            String nextPath = Optional.ofNullable((Link)linkMap.get("next")).map(nextLink -> nextLink.url().toString().replaceAll(this.github.urlFor(""), "")).orElseThrow(() -> new NoSuchElementException("Page iteration exhausted"));
            return new GithubPage<T>(this.github, nextPath, this.typeReference, this.itemsPerPage);
        });
    }

    @Override
    public CompletableFuture<Boolean> hasNextPage() {
        return this.linkMapAsync().thenApply(linkMap -> Objects.nonNull(linkMap.get("next")));
    }

    @Override
    public AsyncPage<T> clone() {
        return new GithubPage<T>(this.github, this.path, this.typeReference, this.itemsPerPage);
    }

    @Override
    public Iterator<T> iterator() {
        return ((List)((CompletableFuture)this.github.request(this.path).thenApply(response -> this.github.json().fromJsonUncheckedNotNull(response.bodyString(), this.typeReference))).join()).iterator();
    }

    private CompletableFuture<Map<String, Link>> linkMapAsync() {
        return this.github.request(this.path).thenApply(response -> Optional.ofNullable(response.header("Link")).stream().flatMap(linkHeader -> Arrays.stream(linkHeader.split(","))).map(linkString -> Link.from(linkString.split(";"))).filter(link -> link.rel().isPresent()).collect(Collectors.toMap(link -> link.rel().get(), Function.identity())));
    }

    protected static Optional<Integer> pageNumberFromUri(String uri) {
        Pattern pageInQueryPattern = Pattern.compile("(^|\\?|&)page=(?<page>\\d+)", 2);
        try {
            String query = new URIBuilder(uri).build().getQuery();
            Matcher matcher = pageInQueryPattern.matcher(query);
            return matcher.find() ? Optional.of(Integer.parseInt(matcher.group("page"))) : Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

