/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.spotify.github.v3.clients.PKCS1PEMKey;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;

public class JwtTokenIssuer {
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.RS256;
    private static final long TOKEN_TTL = 600000L;
    private final PrivateKey signingKey;

    private JwtTokenIssuer(PrivateKey signingKey) {
        this.signingKey = signingKey;
    }

    public static JwtTokenIssuer fromPrivateKey(byte[] privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeySpec keySpec = PKCS1PEMKey.loadKeySpec(privateKey).orElseGet(() -> new PKCS8EncodedKeySpec(privateKey));
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey signingKey = kf.generatePrivate(keySpec);
        return new JwtTokenIssuer(signingKey);
    }

    public String getToken(Integer appId) {
        return ((JwtBuilder)((JwtBuilder)((JwtBuilder)((JwtBuilder)((JwtBuilder)Jwts.builder().setId("github-auth")).setSubject("authenticating via private key")).setIssuer(String.valueOf(appId))).signWith((Key)this.signingKey, SIGNATURE_ALGORITHM).setExpiration(new Date(System.currentTimeMillis() + 600000L))).setIssuedAt(new Date())).compact();
    }
}

