/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.clients;

import com.spotify.github.v3.clients.GitHubClient;
import com.spotify.github.v3.clients.GithubAppClient;
import com.spotify.github.v3.clients.TeamClient;
import com.spotify.github.v3.orgs.OrgMembership;
import com.spotify.github.v3.orgs.requests.OrgMembershipCreate;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganisationClient {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String MEMBERSHIP_TEMPLATE = "/orgs/%s/memberships/%s";
    private final GitHubClient github;
    private final String org;

    OrganisationClient(GitHubClient github, String org) {
        this.github = github;
        this.org = org;
    }

    static OrganisationClient create(GitHubClient github, String org) {
        return new OrganisationClient(github, org);
    }

    public TeamClient createTeamClient() {
        return TeamClient.create(this.github, this.org);
    }

    public GithubAppClient createGithubAppClient() {
        return new GithubAppClient(this.github, this.org);
    }

    public CompletableFuture<OrgMembership> getOrgMembership(String username) {
        String path = String.format(MEMBERSHIP_TEMPLATE, this.org, username);
        log.debug("Fetching org membership for: " + path);
        return this.github.request(path, OrgMembership.class);
    }

    public CompletableFuture<OrgMembership> updateOrgMembership(OrgMembershipCreate request, String username) {
        String path = String.format(MEMBERSHIP_TEMPLATE, this.org, username);
        log.debug("Updating membership in org: " + path);
        return this.github.put(path, this.github.json().toJsonUnchecked(request), OrgMembership.class);
    }
}

