/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.Blob;
import com.spotify.github.v3.git.ShaLink;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Blob", generator="Immutables")
@Immutable
public final class ImmutableBlob
implements Blob {
    @Nullable
    private final String sha;
    @Nullable
    private final URI url;
    @Nullable
    private final String content;
    @Nullable
    private final String encoding;
    @Nullable
    private final Integer size;

    private ImmutableBlob(@Nullable String sha, @Nullable URI url, @Nullable String content, @Nullable String encoding, @Nullable Integer size) {
        this.sha = sha;
        this.url = url;
        this.content = content;
        this.encoding = encoding;
        this.size = size;
    }

    @Override
    @JsonProperty
    @Nullable
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public String content() {
        return this.content;
    }

    @Override
    @JsonProperty
    @Nullable
    public String encoding() {
        return this.encoding;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer size() {
        return this.size;
    }

    public final ImmutableBlob withSha(@Nullable String value) {
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutableBlob(value, this.url, this.content, this.encoding, this.size);
    }

    public final ImmutableBlob withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableBlob(this.sha, value, this.content, this.encoding, this.size);
    }

    public final ImmutableBlob withContent(@Nullable String value) {
        if (Objects.equals(this.content, value)) {
            return this;
        }
        return new ImmutableBlob(this.sha, this.url, value, this.encoding, this.size);
    }

    public final ImmutableBlob withEncoding(@Nullable String value) {
        if (Objects.equals(this.encoding, value)) {
            return this;
        }
        return new ImmutableBlob(this.sha, this.url, this.content, value, this.size);
    }

    public final ImmutableBlob withSize(@Nullable Integer value) {
        if (Objects.equals(this.size, value)) {
            return this;
        }
        return new ImmutableBlob(this.sha, this.url, this.content, this.encoding, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBlob && this.equalTo(0, (ImmutableBlob)another);
    }

    private boolean equalTo(int synthetic, ImmutableBlob another) {
        return Objects.equals(this.sha, another.sha) && Objects.equals(this.url, another.url) && Objects.equals(this.content, another.content) && Objects.equals(this.encoding, another.encoding) && Objects.equals(this.size, another.size);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sha);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.content);
        h += (h << 5) + Objects.hashCode(this.encoding);
        h += (h << 5) + Objects.hashCode(this.size);
        return h;
    }

    public String toString() {
        return "Blob{sha=" + this.sha + ", url=" + String.valueOf(this.url) + ", content=" + this.content + ", encoding=" + this.encoding + ", size=" + this.size + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBlob fromJson(Json json) {
        Builder builder = ImmutableBlob.builder();
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.encoding != null) {
            builder.encoding(json.encoding);
        }
        if (json.size != null) {
            builder.size(json.size);
        }
        return builder.build();
    }

    public static ImmutableBlob copyOf(Blob instance) {
        if (instance instanceof ImmutableBlob) {
            return (ImmutableBlob)instance;
        }
        return ImmutableBlob.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Blob", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sha;
        @Nullable
        private URI url;
        @Nullable
        private String content;
        @Nullable
        private String encoding;
        @Nullable
        private Integer size;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ShaLink instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Blob instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ShaLink instance;
            long bits = 0L;
            if (object instanceof ShaLink) {
                instance = (ShaLink)object;
                if ((bits & 1L) == 0L) {
                    String shaValue = instance.sha();
                    if (shaValue != null) {
                        this.sha(shaValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    URI urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof Blob) {
                String contentValue;
                String encodingValue;
                instance = (Blob)object;
                Integer sizeValue = instance.size();
                if (sizeValue != null) {
                    this.size(sizeValue);
                }
                if ((encodingValue = instance.encoding()) != null) {
                    this.encoding(encodingValue);
                }
                if ((bits & 1L) == 0L) {
                    String shaValue = instance.sha();
                    if (shaValue != null) {
                        this.sha(shaValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    URI urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 2L;
                }
                if ((contentValue = instance.content()) != null) {
                    this.content(contentValue);
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(@Nullable String sha) {
            this.sha = sha;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder content(@Nullable String content) {
            this.content = content;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder encoding(@Nullable String encoding) {
            this.encoding = encoding;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder size(@Nullable Integer size) {
            this.size = size;
            return this;
        }

        public ImmutableBlob build() {
            return new ImmutableBlob(this.sha, this.url, this.content, this.encoding, this.size);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Blob", generator="Immutables")
    static final class Json
    implements Blob {
        @Nullable
        String sha;
        @Nullable
        URI url;
        @Nullable
        String content;
        @Nullable
        String encoding;
        @Nullable
        Integer size;

        Json() {
        }

        @JsonProperty
        public void setSha(@Nullable String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setContent(@Nullable String content) {
            this.content = content;
        }

        @JsonProperty
        public void setEncoding(@Nullable String encoding) {
            this.encoding = encoding;
        }

        @JsonProperty
        public void setSize(@Nullable Integer size) {
            this.size = size;
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String content() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String encoding() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer size() {
            throw new UnsupportedOperationException();
        }
    }
}

