/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.FileItem;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FileItem", generator="Immutables")
@Immutable
public final class ImmutableFileItem
implements FileItem {
    private final String sha;
    private final String filename;
    @Nullable
    private final String status;
    @Nullable
    private final Integer additions;
    @Nullable
    private final Integer deletions;
    @Nullable
    private final Integer changes;
    @Nullable
    private final URI blobUrl;
    @Nullable
    private final URI rawUrl;
    @Nullable
    private final URI contentsUrl;
    @Nullable
    private final String patch;

    private ImmutableFileItem(String sha, String filename, @Nullable String status, @Nullable Integer additions, @Nullable Integer deletions, @Nullable Integer changes, @Nullable URI blobUrl, @Nullable URI rawUrl, @Nullable URI contentsUrl, @Nullable String patch) {
        this.sha = sha;
        this.filename = filename;
        this.status = status;
        this.additions = additions;
        this.deletions = deletions;
        this.changes = changes;
        this.blobUrl = blobUrl;
        this.rawUrl = rawUrl;
        this.contentsUrl = contentsUrl;
        this.patch = patch;
    }

    @Override
    @JsonProperty
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    public String filename() {
        return this.filename;
    }

    @Override
    @JsonProperty
    @Nullable
    public String status() {
        return this.status;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer additions() {
        return this.additions;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer deletions() {
        return this.deletions;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer changes() {
        return this.changes;
    }

    @Override
    @JsonProperty(value="blob_url")
    @Nullable
    public URI blobUrl() {
        return this.blobUrl;
    }

    @Override
    @JsonProperty(value="raw_url")
    @Nullable
    public URI rawUrl() {
        return this.rawUrl;
    }

    @Override
    @JsonProperty(value="contents_url")
    @Nullable
    public URI contentsUrl() {
        return this.contentsUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String patch() {
        return this.patch;
    }

    public final ImmutableFileItem withSha(String value) {
        String newValue = Objects.requireNonNull(value, "sha");
        if (this.sha.equals(newValue)) {
            return this;
        }
        return new ImmutableFileItem(newValue, this.filename, this.status, this.additions, this.deletions, this.changes, this.blobUrl, this.rawUrl, this.contentsUrl, this.patch);
    }

    public final ImmutableFileItem withFilename(String value) {
        String newValue = Objects.requireNonNull(value, "filename");
        if (this.filename.equals(newValue)) {
            return this;
        }
        return new ImmutableFileItem(this.sha, newValue, this.status, this.additions, this.deletions, this.changes, this.blobUrl, this.rawUrl, this.contentsUrl, this.patch);
    }

    public final ImmutableFileItem withStatus(@Nullable String value) {
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableFileItem(this.sha, this.filename, value, this.additions, this.deletions, this.changes, this.blobUrl, this.rawUrl, this.contentsUrl, this.patch);
    }

    public final ImmutableFileItem withAdditions(@Nullable Integer value) {
        if (Objects.equals(this.additions, value)) {
            return this;
        }
        return new ImmutableFileItem(this.sha, this.filename, this.status, value, this.deletions, this.changes, this.blobUrl, this.rawUrl, this.contentsUrl, this.patch);
    }

    public final ImmutableFileItem withDeletions(@Nullable Integer value) {
        if (Objects.equals(this.deletions, value)) {
            return this;
        }
        return new ImmutableFileItem(this.sha, this.filename, this.status, this.additions, value, this.changes, this.blobUrl, this.rawUrl, this.contentsUrl, this.patch);
    }

    public final ImmutableFileItem withChanges(@Nullable Integer value) {
        if (Objects.equals(this.changes, value)) {
            return this;
        }
        return new ImmutableFileItem(this.sha, this.filename, this.status, this.additions, this.deletions, value, this.blobUrl, this.rawUrl, this.contentsUrl, this.patch);
    }

    public final ImmutableFileItem withBlobUrl(@Nullable URI value) {
        if (this.blobUrl == value) {
            return this;
        }
        return new ImmutableFileItem(this.sha, this.filename, this.status, this.additions, this.deletions, this.changes, value, this.rawUrl, this.contentsUrl, this.patch);
    }

    public final ImmutableFileItem withRawUrl(@Nullable URI value) {
        if (this.rawUrl == value) {
            return this;
        }
        return new ImmutableFileItem(this.sha, this.filename, this.status, this.additions, this.deletions, this.changes, this.blobUrl, value, this.contentsUrl, this.patch);
    }

    public final ImmutableFileItem withContentsUrl(@Nullable URI value) {
        if (this.contentsUrl == value) {
            return this;
        }
        return new ImmutableFileItem(this.sha, this.filename, this.status, this.additions, this.deletions, this.changes, this.blobUrl, this.rawUrl, value, this.patch);
    }

    public final ImmutableFileItem withPatch(@Nullable String value) {
        if (Objects.equals(this.patch, value)) {
            return this;
        }
        return new ImmutableFileItem(this.sha, this.filename, this.status, this.additions, this.deletions, this.changes, this.blobUrl, this.rawUrl, this.contentsUrl, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileItem && this.equalTo(0, (ImmutableFileItem)another);
    }

    private boolean equalTo(int synthetic, ImmutableFileItem another) {
        return this.sha.equals(another.sha) && this.filename.equals(another.filename) && Objects.equals(this.status, another.status) && Objects.equals(this.additions, another.additions) && Objects.equals(this.deletions, another.deletions) && Objects.equals(this.changes, another.changes) && Objects.equals(this.blobUrl, another.blobUrl) && Objects.equals(this.rawUrl, another.rawUrl) && Objects.equals(this.contentsUrl, another.contentsUrl) && Objects.equals(this.patch, another.patch);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sha.hashCode();
        h += (h << 5) + this.filename.hashCode();
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + Objects.hashCode(this.additions);
        h += (h << 5) + Objects.hashCode(this.deletions);
        h += (h << 5) + Objects.hashCode(this.changes);
        h += (h << 5) + Objects.hashCode(this.blobUrl);
        h += (h << 5) + Objects.hashCode(this.rawUrl);
        h += (h << 5) + Objects.hashCode(this.contentsUrl);
        h += (h << 5) + Objects.hashCode(this.patch);
        return h;
    }

    public String toString() {
        return "FileItem{sha=" + this.sha + ", filename=" + this.filename + ", status=" + this.status + ", additions=" + this.additions + ", deletions=" + this.deletions + ", changes=" + this.changes + ", blobUrl=" + String.valueOf(this.blobUrl) + ", rawUrl=" + String.valueOf(this.rawUrl) + ", contentsUrl=" + String.valueOf(this.contentsUrl) + ", patch=" + this.patch + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFileItem fromJson(Json json) {
        Builder builder = ImmutableFileItem.builder();
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.filename != null) {
            builder.filename(json.filename);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.additions != null) {
            builder.additions(json.additions);
        }
        if (json.deletions != null) {
            builder.deletions(json.deletions);
        }
        if (json.changes != null) {
            builder.changes(json.changes);
        }
        if (json.blobUrl != null) {
            builder.blobUrl(json.blobUrl);
        }
        if (json.rawUrl != null) {
            builder.rawUrl(json.rawUrl);
        }
        if (json.contentsUrl != null) {
            builder.contentsUrl(json.contentsUrl);
        }
        if (json.patch != null) {
            builder.patch(json.patch);
        }
        return builder.build();
    }

    public static ImmutableFileItem copyOf(FileItem instance) {
        if (instance instanceof ImmutableFileItem) {
            return (ImmutableFileItem)instance;
        }
        return ImmutableFileItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FileItem", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SHA = 1L;
        private static final long INIT_BIT_FILENAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String sha;
        @Nullable
        private String filename;
        @Nullable
        private String status;
        @Nullable
        private Integer additions;
        @Nullable
        private Integer deletions;
        @Nullable
        private Integer changes;
        @Nullable
        private URI blobUrl;
        @Nullable
        private URI rawUrl;
        @Nullable
        private URI contentsUrl;
        @Nullable
        private String patch;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FileItem instance) {
            String patchValue;
            URI contentsUrlValue;
            URI rawUrlValue;
            URI blobUrlValue;
            Integer changesValue;
            Integer deletionsValue;
            Integer additionsValue;
            Objects.requireNonNull(instance, "instance");
            this.sha(instance.sha());
            this.filename(instance.filename());
            String statusValue = instance.status();
            if (statusValue != null) {
                this.status(statusValue);
            }
            if ((additionsValue = instance.additions()) != null) {
                this.additions(additionsValue);
            }
            if ((deletionsValue = instance.deletions()) != null) {
                this.deletions(deletionsValue);
            }
            if ((changesValue = instance.changes()) != null) {
                this.changes(changesValue);
            }
            if ((blobUrlValue = instance.blobUrl()) != null) {
                this.blobUrl(blobUrlValue);
            }
            if ((rawUrlValue = instance.rawUrl()) != null) {
                this.rawUrl(rawUrlValue);
            }
            if ((contentsUrlValue = instance.contentsUrl()) != null) {
                this.contentsUrl(contentsUrlValue);
            }
            if ((patchValue = instance.patch()) != null) {
                this.patch(patchValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(String sha) {
            this.sha = Objects.requireNonNull(sha, "sha");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder filename(String filename) {
            this.filename = Objects.requireNonNull(filename, "filename");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder additions(@Nullable Integer additions) {
            this.additions = additions;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder deletions(@Nullable Integer deletions) {
            this.deletions = deletions;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder changes(@Nullable Integer changes) {
            this.changes = changes;
            return this;
        }

        @JsonProperty(value="blob_url")
        @CanIgnoreReturnValue
        public final Builder blobUrl(@Nullable URI blobUrl) {
            this.blobUrl = blobUrl;
            return this;
        }

        @JsonProperty(value="raw_url")
        @CanIgnoreReturnValue
        public final Builder rawUrl(@Nullable URI rawUrl) {
            this.rawUrl = rawUrl;
            return this;
        }

        @JsonProperty(value="contents_url")
        @CanIgnoreReturnValue
        public final Builder contentsUrl(@Nullable URI contentsUrl) {
            this.contentsUrl = contentsUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder patch(@Nullable String patch) {
            this.patch = patch;
            return this;
        }

        public ImmutableFileItem build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileItem(this.sha, this.filename, this.status, this.additions, this.deletions, this.changes, this.blobUrl, this.rawUrl, this.contentsUrl, this.patch);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sha");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("filename");
            }
            return "Cannot build FileItem, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FileItem", generator="Immutables")
    static final class Json
    implements FileItem {
        @Nullable
        String sha;
        @Nullable
        String filename;
        @Nullable
        String status;
        @Nullable
        Integer additions;
        @Nullable
        Integer deletions;
        @Nullable
        Integer changes;
        @Nullable
        URI blobUrl;
        @Nullable
        URI rawUrl;
        @Nullable
        URI contentsUrl;
        @Nullable
        String patch;

        Json() {
        }

        @JsonProperty
        public void setSha(String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setFilename(String filename) {
            this.filename = filename;
        }

        @JsonProperty
        public void setStatus(@Nullable String status) {
            this.status = status;
        }

        @JsonProperty
        public void setAdditions(@Nullable Integer additions) {
            this.additions = additions;
        }

        @JsonProperty
        public void setDeletions(@Nullable Integer deletions) {
            this.deletions = deletions;
        }

        @JsonProperty
        public void setChanges(@Nullable Integer changes) {
            this.changes = changes;
        }

        @JsonProperty(value="blob_url")
        public void setBlobUrl(@Nullable URI blobUrl) {
            this.blobUrl = blobUrl;
        }

        @JsonProperty(value="raw_url")
        public void setRawUrl(@Nullable URI rawUrl) {
            this.rawUrl = rawUrl;
        }

        @JsonProperty(value="contents_url")
        public void setContentsUrl(@Nullable URI contentsUrl) {
            this.contentsUrl = contentsUrl;
        }

        @JsonProperty
        public void setPatch(@Nullable String patch) {
            this.patch = patch;
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String filename() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer additions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer deletions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer changes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI blobUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI rawUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI contentsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String patch() {
            throw new UnsupportedOperationException();
        }
    }
}

