/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.ParentItem;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ParentItem", generator="Immutables")
@Immutable
public final class ImmutableParentItem
implements ParentItem {
    @Nullable
    private final String sha;
    @Nullable
    private final URI url;
    @Nullable
    private final URI htmlUrl;

    private ImmutableParentItem(@Nullable String sha, @Nullable URI url, @Nullable URI htmlUrl) {
        this.sha = sha;
        this.url = url;
        this.htmlUrl = htmlUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty(value="html_url")
    @Nullable
    public URI htmlUrl() {
        return this.htmlUrl;
    }

    public final ImmutableParentItem withSha(@Nullable String value) {
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutableParentItem(value, this.url, this.htmlUrl);
    }

    public final ImmutableParentItem withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableParentItem(this.sha, value, this.htmlUrl);
    }

    public final ImmutableParentItem withHtmlUrl(@Nullable URI value) {
        if (this.htmlUrl == value) {
            return this;
        }
        return new ImmutableParentItem(this.sha, this.url, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableParentItem && this.equalTo(0, (ImmutableParentItem)another);
    }

    private boolean equalTo(int synthetic, ImmutableParentItem another) {
        return Objects.equals(this.sha, another.sha) && Objects.equals(this.url, another.url) && Objects.equals(this.htmlUrl, another.htmlUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sha);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.htmlUrl);
        return h;
    }

    public String toString() {
        return "ParentItem{sha=" + this.sha + ", url=" + String.valueOf(this.url) + ", htmlUrl=" + String.valueOf(this.htmlUrl) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableParentItem fromJson(Json json) {
        Builder builder = ImmutableParentItem.builder();
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        return builder.build();
    }

    public static ImmutableParentItem copyOf(ParentItem instance) {
        if (instance instanceof ImmutableParentItem) {
            return (ImmutableParentItem)instance;
        }
        return ImmutableParentItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ParentItem", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sha;
        @Nullable
        private URI url;
        @Nullable
        private URI htmlUrl;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ParentItem instance) {
            URI htmlUrlValue;
            URI urlValue;
            Objects.requireNonNull(instance, "instance");
            String shaValue = instance.sha();
            if (shaValue != null) {
                this.sha(shaValue);
            }
            if ((urlValue = instance.url()) != null) {
                this.url(urlValue);
            }
            if ((htmlUrlValue = instance.htmlUrl()) != null) {
                this.htmlUrl(htmlUrlValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(@Nullable String sha) {
            this.sha = sha;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @JsonProperty(value="html_url")
        @CanIgnoreReturnValue
        public final Builder htmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
            return this;
        }

        public ImmutableParentItem build() {
            return new ImmutableParentItem(this.sha, this.url, this.htmlUrl);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ParentItem", generator="Immutables")
    static final class Json
    implements ParentItem {
        @Nullable
        String sha;
        @Nullable
        URI url;
        @Nullable
        URI htmlUrl;

        Json() {
        }

        @JsonProperty
        public void setSha(@Nullable String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty(value="html_url")
        public void setHtmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI htmlUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

