/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.ShaLink;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ShaLink", generator="Immutables")
@Immutable
public final class ImmutableShaLink
implements ShaLink {
    @Nullable
    private final String sha;
    @Nullable
    private final URI url;

    private ImmutableShaLink(@Nullable String sha, @Nullable URI url) {
        this.sha = sha;
        this.url = url;
    }

    @Override
    @JsonProperty
    @Nullable
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    public final ImmutableShaLink withSha(@Nullable String value) {
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutableShaLink(value, this.url);
    }

    public final ImmutableShaLink withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableShaLink(this.sha, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableShaLink && this.equalTo(0, (ImmutableShaLink)another);
    }

    private boolean equalTo(int synthetic, ImmutableShaLink another) {
        return Objects.equals(this.sha, another.sha) && Objects.equals(this.url, another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sha);
        h += (h << 5) + Objects.hashCode(this.url);
        return h;
    }

    public String toString() {
        return "ShaLink{sha=" + this.sha + ", url=" + String.valueOf(this.url) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableShaLink fromJson(Json json) {
        Builder builder = ImmutableShaLink.builder();
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        return builder.build();
    }

    public static ImmutableShaLink copyOf(ShaLink instance) {
        if (instance instanceof ImmutableShaLink) {
            return (ImmutableShaLink)instance;
        }
        return ImmutableShaLink.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ShaLink", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sha;
        @Nullable
        private URI url;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ShaLink instance) {
            URI urlValue;
            Objects.requireNonNull(instance, "instance");
            String shaValue = instance.sha();
            if (shaValue != null) {
                this.sha(shaValue);
            }
            if ((urlValue = instance.url()) != null) {
                this.url(urlValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(@Nullable String sha) {
            this.sha = sha;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        public ImmutableShaLink build() {
            return new ImmutableShaLink(this.sha, this.url);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ShaLink", generator="Immutables")
    static final class Json
    implements ShaLink {
        @Nullable
        String sha;
        @Nullable
        URI url;

        Json() {
        }

        @JsonProperty
        public void setSha(@Nullable String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }
    }
}

