/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.git.ShaLink;
import com.spotify.github.v3.git.Tree;
import com.spotify.github.v3.git.TreeItem;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Tree", generator="Immutables")
@Immutable
public final class ImmutableTree
implements Tree {
    @Nullable
    private final String sha;
    @Nullable
    private final URI url;
    @Nullable
    private final List<TreeItem> tree;
    @Nullable
    private final Boolean truncated;

    private ImmutableTree(@Nullable String sha, @Nullable URI url, @Nullable List<TreeItem> tree, @Nullable Boolean truncated) {
        this.sha = sha;
        this.url = url;
        this.tree = tree;
        this.truncated = truncated;
    }

    @Override
    @JsonProperty
    @Nullable
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<TreeItem> tree() {
        return this.tree;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean truncated() {
        return this.truncated;
    }

    public final ImmutableTree withSha(@Nullable String value) {
        if (Objects.equals(this.sha, value)) {
            return this;
        }
        return new ImmutableTree(value, this.url, this.tree, this.truncated);
    }

    public final ImmutableTree withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableTree(this.sha, value, this.tree, this.truncated);
    }

    public final ImmutableTree withTree(TreeItem ... elements) {
        if (elements == null) {
            return new ImmutableTree(this.sha, this.url, null, this.truncated);
        }
        List<TreeItem> newValue = Arrays.asList(elements) == null ? null : ImmutableTree.createUnmodifiableList(false, ImmutableTree.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTree(this.sha, this.url, newValue, this.truncated);
    }

    public final ImmutableTree withTree(@Nullable Iterable<? extends TreeItem> elements) {
        if (this.tree == elements) {
            return this;
        }
        List<TreeItem> newValue = elements == null ? null : ImmutableTree.createUnmodifiableList(false, ImmutableTree.createSafeList(elements, true, false));
        return new ImmutableTree(this.sha, this.url, newValue, this.truncated);
    }

    public final ImmutableTree withTruncated(@Nullable Boolean value) {
        if (Objects.equals(this.truncated, value)) {
            return this;
        }
        return new ImmutableTree(this.sha, this.url, this.tree, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTree && this.equalTo(0, (ImmutableTree)another);
    }

    private boolean equalTo(int synthetic, ImmutableTree another) {
        return Objects.equals(this.sha, another.sha) && Objects.equals(this.url, another.url) && Objects.equals(this.tree, another.tree) && Objects.equals(this.truncated, another.truncated);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sha);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.tree);
        h += (h << 5) + Objects.hashCode(this.truncated);
        return h;
    }

    public String toString() {
        return "Tree{sha=" + this.sha + ", url=" + String.valueOf(this.url) + ", tree=" + String.valueOf(this.tree) + ", truncated=" + this.truncated + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTree fromJson(Json json) {
        Builder builder = ImmutableTree.builder();
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.tree != null) {
            builder.addAllTree(json.tree);
        }
        if (json.truncated != null) {
            builder.truncated(json.truncated);
        }
        return builder.build();
    }

    public static ImmutableTree copyOf(Tree instance) {
        if (instance instanceof ImmutableTree) {
            return (ImmutableTree)instance;
        }
        return ImmutableTree.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Tree", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sha;
        @Nullable
        private URI url;
        private List<TreeItem> tree = null;
        @Nullable
        private Boolean truncated;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Tree instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ShaLink instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ShaLink instance;
            long bits = 0L;
            if (object instanceof Tree) {
                Boolean truncatedValue;
                instance = (Tree)object;
                List<TreeItem> treeValue = instance.tree();
                if (treeValue != null) {
                    this.addAllTree(treeValue);
                }
                if ((truncatedValue = instance.truncated()) != null) {
                    this.truncated(truncatedValue);
                }
                if ((bits & 1L) == 0L) {
                    String shaValue = instance.sha();
                    if (shaValue != null) {
                        this.sha(shaValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    URI urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof ShaLink) {
                instance = (ShaLink)object;
                if ((bits & 1L) == 0L) {
                    String shaValue = instance.sha();
                    if (shaValue != null) {
                        this.sha(shaValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    URI urlValue = instance.url();
                    if (urlValue != null) {
                        this.url(urlValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(@Nullable String sha) {
            this.sha = sha;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTree(TreeItem element) {
            if (this.tree == null) {
                this.tree = new ArrayList<TreeItem>();
            }
            this.tree.add(Objects.requireNonNull(element, "tree element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTree(TreeItem ... elements) {
            if (this.tree == null) {
                this.tree = new ArrayList<TreeItem>();
            }
            for (TreeItem element : elements) {
                this.tree.add(Objects.requireNonNull(element, "tree element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder tree(@Nullable Iterable<? extends TreeItem> elements) {
            if (elements == null) {
                this.tree = null;
                return this;
            }
            this.tree = new ArrayList<TreeItem>();
            return this.addAllTree(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTree(Iterable<? extends TreeItem> elements) {
            Objects.requireNonNull(elements, "tree element");
            if (this.tree == null) {
                this.tree = new ArrayList<TreeItem>();
            }
            for (TreeItem treeItem : elements) {
                this.tree.add(Objects.requireNonNull(treeItem, "tree element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder truncated(@Nullable Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public ImmutableTree build() {
            return new ImmutableTree(this.sha, this.url, this.tree == null ? null : ImmutableTree.createUnmodifiableList(true, this.tree), this.truncated);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Tree", generator="Immutables")
    static final class Json
    implements Tree {
        @Nullable
        String sha;
        @Nullable
        URI url;
        @Nullable
        List<TreeItem> tree = null;
        @Nullable
        Boolean truncated;

        Json() {
        }

        @JsonProperty
        public void setSha(@Nullable String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setTree(@Nullable List<TreeItem> tree) {
            this.tree = tree;
        }

        @JsonProperty
        public void setTruncated(@Nullable Boolean truncated) {
            this.truncated = truncated;
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<TreeItem> tree() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean truncated() {
            throw new UnsupportedOperationException();
        }
    }
}

