/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.issues;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.CloseTracking;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.Milestone;
import com.spotify.github.v3.User;
import com.spotify.github.v3.issues.Issue;
import com.spotify.github.v3.issues.Label;
import com.spotify.github.v3.issues.PullRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Issue", generator="Immutables")
@Immutable
public final class ImmutableIssue
implements Issue {
    @Nullable
    private final GitHubInstant createdAt;
    @Nullable
    private final GitHubInstant updatedAt;
    @Nullable
    private final GitHubInstant closedAt;
    @Nullable
    private final Long id;
    @Nullable
    private final URI url;
    @Nullable
    private final URI eventsUrl;
    @Nullable
    private final URI repositoryUrl;
    @Nullable
    private final String labelsUrl;
    @Nullable
    private final URI commentsUrl;
    @Nullable
    private final URI htmlUrl;
    @Nullable
    private final Long number;
    @Nullable
    private final String state;
    @Nullable
    private final String title;
    @Nullable
    private final String body;
    @Nullable
    private final User user;
    @Nullable
    private final List<Label> labels;
    @Nullable
    private final User assignee;
    @Nullable
    private final Milestone milestone;
    @Nullable
    private final Boolean locked;
    @Nullable
    private final Integer comments;
    @Nullable
    private final PullRequest pullRequest;

    private ImmutableIssue(@Nullable GitHubInstant createdAt, @Nullable GitHubInstant updatedAt, @Nullable GitHubInstant closedAt, @Nullable Long id, @Nullable URI url, @Nullable URI eventsUrl, @Nullable URI repositoryUrl, @Nullable String labelsUrl, @Nullable URI commentsUrl, @Nullable URI htmlUrl, @Nullable Long number, @Nullable String state, @Nullable String title, @Nullable String body, @Nullable User user, @Nullable List<Label> labels, @Nullable User assignee, @Nullable Milestone milestone, @Nullable Boolean locked, @Nullable Integer comments, @Nullable PullRequest pullRequest) {
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.closedAt = closedAt;
        this.id = id;
        this.url = url;
        this.eventsUrl = eventsUrl;
        this.repositoryUrl = repositoryUrl;
        this.labelsUrl = labelsUrl;
        this.commentsUrl = commentsUrl;
        this.htmlUrl = htmlUrl;
        this.number = number;
        this.state = state;
        this.title = title;
        this.body = body;
        this.user = user;
        this.labels = labels;
        this.assignee = assignee;
        this.milestone = milestone;
        this.locked = locked;
        this.comments = comments;
        this.pullRequest = pullRequest;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public GitHubInstant updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    public Optional<GitHubInstant> closedAt() {
        return Optional.ofNullable(this.closedAt);
    }

    @Override
    @JsonProperty
    @Nullable
    public Long id() {
        return this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    public Optional<URI> eventsUrl() {
        return Optional.ofNullable(this.eventsUrl);
    }

    @Override
    @JsonProperty
    public Optional<URI> repositoryUrl() {
        return Optional.ofNullable(this.repositoryUrl);
    }

    @Override
    @JsonProperty
    @Nullable
    public String labelsUrl() {
        return this.labelsUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI commentsUrl() {
        return this.commentsUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    @Nullable
    public Long number() {
        return this.number;
    }

    @Override
    @JsonProperty
    @Nullable
    public String state() {
        return this.state;
    }

    @Override
    @JsonProperty
    @Nullable
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty
    public Optional<String> body() {
        return Optional.ofNullable(this.body);
    }

    @Override
    @JsonProperty
    @Nullable
    public User user() {
        return this.user;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<Label> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty
    public Optional<User> assignee() {
        return Optional.ofNullable(this.assignee);
    }

    @Override
    @JsonProperty
    public Optional<Milestone> milestone() {
        return Optional.ofNullable(this.milestone);
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean locked() {
        return this.locked;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer comments() {
        return this.comments;
    }

    @Override
    @JsonProperty
    public Optional<PullRequest> pullRequest() {
        return Optional.ofNullable(this.pullRequest);
    }

    public final ImmutableIssue withCreatedAt(@Nullable GitHubInstant value) {
        if (this.createdAt == value) {
            return this;
        }
        return new ImmutableIssue(value, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withUpdatedAt(@Nullable GitHubInstant value) {
        if (this.updatedAt == value) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, value, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withClosedAt(GitHubInstant value) {
        GitHubInstant newValue = Objects.requireNonNull(value, "closedAt");
        if (this.closedAt == newValue) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, newValue, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withClosedAt(Optional<? extends GitHubInstant> optional) {
        GitHubInstant value = optional.orElse(null);
        if (this.closedAt == value) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, value, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withId(@Nullable Long value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, value, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, value, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withEventsUrl(URI value) {
        URI newValue = Objects.requireNonNull(value, "eventsUrl");
        if (this.eventsUrl == newValue) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, newValue, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withEventsUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.eventsUrl == value) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, value, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withRepositoryUrl(URI value) {
        URI newValue = Objects.requireNonNull(value, "repositoryUrl");
        if (this.repositoryUrl == newValue) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, newValue, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withRepositoryUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.repositoryUrl == value) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, value, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withLabelsUrl(@Nullable String value) {
        if (Objects.equals(this.labelsUrl, value)) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, value, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withCommentsUrl(@Nullable URI value) {
        if (this.commentsUrl == value) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, value, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withHtmlUrl(@Nullable URI value) {
        if (this.htmlUrl == value) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, value, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withNumber(@Nullable Long value) {
        if (Objects.equals(this.number, value)) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, value, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withState(@Nullable String value) {
        if (Objects.equals(this.state, value)) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, value, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, value, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withBody(String value) {
        String newValue = Objects.requireNonNull(value, "body");
        if (Objects.equals(this.body, newValue)) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, newValue, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withBody(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.body, value)) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, value, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withUser(@Nullable User value) {
        if (this.user == value) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, value, this.labels, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withLabels(Label ... elements) {
        if (elements == null) {
            return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, null, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
        }
        List<Label> newValue = Arrays.asList(elements) == null ? null : ImmutableIssue.createUnmodifiableList(false, ImmutableIssue.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, newValue, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withLabels(@Nullable Iterable<? extends Label> elements) {
        if (this.labels == elements) {
            return this;
        }
        List<Label> newValue = elements == null ? null : ImmutableIssue.createUnmodifiableList(false, ImmutableIssue.createSafeList(elements, true, false));
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, newValue, this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withAssignee(User value) {
        User newValue = Objects.requireNonNull(value, "assignee");
        if (this.assignee == newValue) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, newValue, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withAssignee(Optional<? extends User> optional) {
        User value = optional.orElse(null);
        if (this.assignee == value) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, value, this.milestone, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withMilestone(Milestone value) {
        Milestone newValue = Objects.requireNonNull(value, "milestone");
        if (this.milestone == newValue) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, newValue, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withMilestone(Optional<? extends Milestone> optional) {
        Milestone value = optional.orElse(null);
        if (this.milestone == value) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, value, this.locked, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withLocked(@Nullable Boolean value) {
        if (Objects.equals(this.locked, value)) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, value, this.comments, this.pullRequest);
    }

    public final ImmutableIssue withComments(@Nullable Integer value) {
        if (Objects.equals(this.comments, value)) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, value, this.pullRequest);
    }

    public final ImmutableIssue withPullRequest(PullRequest value) {
        PullRequest newValue = Objects.requireNonNull(value, "pullRequest");
        if (this.pullRequest == newValue) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, newValue);
    }

    public final ImmutableIssue withPullRequest(Optional<? extends PullRequest> optional) {
        PullRequest value = optional.orElse(null);
        if (this.pullRequest == value) {
            return this;
        }
        return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels, this.assignee, this.milestone, this.locked, this.comments, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIssue && this.equalTo(0, (ImmutableIssue)another);
    }

    private boolean equalTo(int synthetic, ImmutableIssue another) {
        return Objects.equals(this.createdAt, another.createdAt) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.closedAt, another.closedAt) && Objects.equals(this.id, another.id) && Objects.equals(this.url, another.url) && Objects.equals(this.eventsUrl, another.eventsUrl) && Objects.equals(this.repositoryUrl, another.repositoryUrl) && Objects.equals(this.labelsUrl, another.labelsUrl) && Objects.equals(this.commentsUrl, another.commentsUrl) && Objects.equals(this.htmlUrl, another.htmlUrl) && Objects.equals(this.number, another.number) && Objects.equals(this.state, another.state) && Objects.equals(this.title, another.title) && Objects.equals(this.body, another.body) && Objects.equals(this.user, another.user) && Objects.equals(this.labels, another.labels) && Objects.equals(this.assignee, another.assignee) && Objects.equals(this.milestone, another.milestone) && Objects.equals(this.locked, another.locked) && Objects.equals(this.comments, another.comments) && Objects.equals(this.pullRequest, another.pullRequest);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.createdAt);
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.closedAt);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.eventsUrl);
        h += (h << 5) + Objects.hashCode(this.repositoryUrl);
        h += (h << 5) + Objects.hashCode(this.labelsUrl);
        h += (h << 5) + Objects.hashCode(this.commentsUrl);
        h += (h << 5) + Objects.hashCode(this.htmlUrl);
        h += (h << 5) + Objects.hashCode(this.number);
        h += (h << 5) + Objects.hashCode(this.state);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.body);
        h += (h << 5) + Objects.hashCode(this.user);
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + Objects.hashCode(this.assignee);
        h += (h << 5) + Objects.hashCode(this.milestone);
        h += (h << 5) + Objects.hashCode(this.locked);
        h += (h << 5) + Objects.hashCode(this.comments);
        h += (h << 5) + Objects.hashCode(this.pullRequest);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Issue{");
        if (this.createdAt != null) {
            builder.append("createdAt=").append(this.createdAt);
        }
        if (this.updatedAt != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("updatedAt=").append(this.updatedAt);
        }
        if (this.closedAt != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("closedAt=").append(this.closedAt);
        }
        if (this.id != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("id=").append(this.id);
        }
        if (this.url != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("url=").append(this.url);
        }
        if (this.eventsUrl != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("eventsUrl=").append(this.eventsUrl);
        }
        if (this.repositoryUrl != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("repositoryUrl=").append(this.repositoryUrl);
        }
        if (this.labelsUrl != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("labelsUrl=").append(this.labelsUrl);
        }
        if (this.commentsUrl != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("commentsUrl=").append(this.commentsUrl);
        }
        if (this.htmlUrl != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("htmlUrl=").append(this.htmlUrl);
        }
        if (this.number != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("number=").append(this.number);
        }
        if (this.state != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("state=").append(this.state);
        }
        if (this.title != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("title=").append(this.title);
        }
        if (this.body != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("body=").append(this.body);
        }
        if (this.user != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("user=").append(this.user);
        }
        if (this.labels != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("labels=").append(this.labels);
        }
        if (this.assignee != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("assignee=").append(this.assignee);
        }
        if (this.milestone != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("milestone=").append(this.milestone);
        }
        if (this.locked != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("locked=").append(this.locked);
        }
        if (this.comments != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("comments=").append(this.comments);
        }
        if (this.pullRequest != null) {
            if (builder.length() > 6) {
                builder.append(", ");
            }
            builder.append("pullRequest=").append(this.pullRequest);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIssue fromJson(Json json) {
        Builder builder = ImmutableIssue.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.closedAt != null) {
            builder.closedAt(json.closedAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.eventsUrl != null) {
            builder.eventsUrl(json.eventsUrl);
        }
        if (json.repositoryUrl != null) {
            builder.repositoryUrl(json.repositoryUrl);
        }
        if (json.labelsUrl != null) {
            builder.labelsUrl(json.labelsUrl);
        }
        if (json.commentsUrl != null) {
            builder.commentsUrl(json.commentsUrl);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.number != null) {
            builder.number(json.number);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.body != null) {
            builder.body(json.body);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.labels != null) {
            builder.addAllLabels(json.labels);
        }
        if (json.assignee != null) {
            builder.assignee(json.assignee);
        }
        if (json.milestone != null) {
            builder.milestone(json.milestone);
        }
        if (json.locked != null) {
            builder.locked(json.locked);
        }
        if (json.comments != null) {
            builder.comments(json.comments);
        }
        if (json.pullRequest != null) {
            builder.pullRequest(json.pullRequest);
        }
        return builder.build();
    }

    public static ImmutableIssue copyOf(Issue instance) {
        if (instance instanceof ImmutableIssue) {
            return (ImmutableIssue)instance;
        }
        return ImmutableIssue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Issue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private GitHubInstant createdAt;
        @Nullable
        private GitHubInstant updatedAt;
        @Nullable
        private GitHubInstant closedAt;
        @Nullable
        private Long id;
        @Nullable
        private URI url;
        @Nullable
        private URI eventsUrl;
        @Nullable
        private URI repositoryUrl;
        @Nullable
        private String labelsUrl;
        @Nullable
        private URI commentsUrl;
        @Nullable
        private URI htmlUrl;
        @Nullable
        private Long number;
        @Nullable
        private String state;
        @Nullable
        private String title;
        @Nullable
        private String body;
        @Nullable
        private User user;
        private List<Label> labels = null;
        @Nullable
        private User assignee;
        @Nullable
        private Milestone milestone;
        @Nullable
        private Boolean locked;
        @Nullable
        private Integer comments;
        @Nullable
        private PullRequest pullRequest;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CloseTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Issue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateTracking instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GitHubInstant updatedAtValue;
            GitHubInstant createdAtValue;
            UpdateTracking instance;
            long bits = 0L;
            if (object instanceof CloseTracking) {
                instance = (CloseTracking)object;
                if ((bits & 2L) == 0L) {
                    Optional<GitHubInstant> closedAtOptional = instance.closedAt();
                    if (closedAtOptional.isPresent()) {
                        this.closedAt(closedAtOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof Issue) {
                User userValue;
                Boolean lockedValue;
                Optional<User> assigneeOptional;
                String stateValue;
                Optional<URI> eventsUrlOptional;
                Long idValue;
                Optional<Milestone> milestoneOptional;
                URI commentsUrlValue;
                Long numberValue;
                List<Label> labelsValue;
                Optional<URI> repositoryUrlOptional;
                Optional<PullRequest> pullRequestOptional;
                URI urlValue;
                Optional<String> bodyOptional;
                String titleValue;
                URI htmlUrlValue;
                String labelsUrlValue;
                instance = (Issue)object;
                Integer commentsValue = instance.comments();
                if (commentsValue != null) {
                    this.comments(commentsValue);
                }
                if ((labelsUrlValue = instance.labelsUrl()) != null) {
                    this.labelsUrl(labelsUrlValue);
                }
                if ((htmlUrlValue = instance.htmlUrl()) != null) {
                    this.htmlUrl(htmlUrlValue);
                }
                if ((titleValue = instance.title()) != null) {
                    this.title(titleValue);
                }
                if ((bodyOptional = instance.body()).isPresent()) {
                    this.body(bodyOptional);
                }
                if ((urlValue = instance.url()) != null) {
                    this.url(urlValue);
                }
                if ((pullRequestOptional = instance.pullRequest()).isPresent()) {
                    this.pullRequest(pullRequestOptional);
                }
                if ((repositoryUrlOptional = instance.repositoryUrl()).isPresent()) {
                    this.repositoryUrl(repositoryUrlOptional);
                }
                if ((labelsValue = instance.labels()) != null) {
                    this.addAllLabels(labelsValue);
                }
                if ((bits & 1L) == 0L) {
                    GitHubInstant createdAtValue2 = instance.createdAt();
                    if (createdAtValue2 != null) {
                        this.createdAt(createdAtValue2);
                    }
                    bits |= 1L;
                }
                if ((numberValue = instance.number()) != null) {
                    this.number(numberValue);
                }
                if ((commentsUrlValue = instance.commentsUrl()) != null) {
                    this.commentsUrl(commentsUrlValue);
                }
                if ((milestoneOptional = instance.milestone()).isPresent()) {
                    this.milestone(milestoneOptional);
                }
                if ((idValue = instance.id()) != null) {
                    this.id(idValue);
                }
                if ((eventsUrlOptional = instance.eventsUrl()).isPresent()) {
                    this.eventsUrl(eventsUrlOptional);
                }
                if ((stateValue = instance.state()) != null) {
                    this.state(stateValue);
                }
                if ((assigneeOptional = instance.assignee()).isPresent()) {
                    this.assignee(assigneeOptional);
                }
                if ((bits & 2L) == 0L) {
                    Optional<GitHubInstant> closedAtOptional = instance.closedAt();
                    if (closedAtOptional.isPresent()) {
                        this.closedAt(closedAtOptional);
                    }
                    bits |= 2L;
                }
                if ((lockedValue = instance.locked()) != null) {
                    this.locked(lockedValue);
                }
                if ((userValue = instance.user()) != null) {
                    this.user(userValue);
                }
                if ((bits & 4L) == 0L) {
                    GitHubInstant updatedAtValue2 = instance.updatedAt();
                    if (updatedAtValue2 != null) {
                        this.updatedAt(updatedAtValue2);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof UpdateTracking) {
                instance = (UpdateTracking)object;
                if ((bits & 1L) == 0L) {
                    createdAtValue = instance.createdAt();
                    if (createdAtValue != null) {
                        this.createdAt(createdAtValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    updatedAtValue = instance.updatedAt();
                    if (updatedAtValue != null) {
                        this.updatedAt(updatedAtValue);
                    }
                    bits |= 4L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder closedAt(GitHubInstant closedAt) {
            this.closedAt = Objects.requireNonNull(closedAt, "closedAt");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder closedAt(Optional<? extends GitHubInstant> closedAt) {
            this.closedAt = closedAt.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(@Nullable Long id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            this.url = url;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder eventsUrl(URI eventsUrl) {
            this.eventsUrl = Objects.requireNonNull(eventsUrl, "eventsUrl");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder eventsUrl(Optional<? extends URI> eventsUrl) {
            this.eventsUrl = eventsUrl.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repositoryUrl(URI repositoryUrl) {
            this.repositoryUrl = Objects.requireNonNull(repositoryUrl, "repositoryUrl");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repositoryUrl(Optional<? extends URI> repositoryUrl) {
            this.repositoryUrl = repositoryUrl.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder labelsUrl(@Nullable String labelsUrl) {
            this.labelsUrl = labelsUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commentsUrl(@Nullable URI commentsUrl) {
            this.commentsUrl = commentsUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder number(@Nullable Long number) {
            this.number = number;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder body(String body) {
            this.body = Objects.requireNonNull(body, "body");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder body(Optional<String> body) {
            this.body = body.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder user(@Nullable User user) {
            this.user = user;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(Label element) {
            if (this.labels == null) {
                this.labels = new ArrayList<Label>();
            }
            this.labels.add(Objects.requireNonNull(element, "labels element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(Label ... elements) {
            if (this.labels == null) {
                this.labels = new ArrayList<Label>();
            }
            for (Label element : elements) {
                this.labels.add(Objects.requireNonNull(element, "labels element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder labels(@Nullable Iterable<? extends Label> elements) {
            if (elements == null) {
                this.labels = null;
                return this;
            }
            this.labels = new ArrayList<Label>();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<? extends Label> elements) {
            Objects.requireNonNull(elements, "labels element");
            if (this.labels == null) {
                this.labels = new ArrayList<Label>();
            }
            for (Label label : elements) {
                this.labels.add(Objects.requireNonNull(label, "labels element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder assignee(User assignee) {
            this.assignee = Objects.requireNonNull(assignee, "assignee");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder assignee(Optional<? extends User> assignee) {
            this.assignee = assignee.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder milestone(Milestone milestone) {
            this.milestone = Objects.requireNonNull(milestone, "milestone");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder milestone(Optional<? extends Milestone> milestone) {
            this.milestone = milestone.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder locked(@Nullable Boolean locked) {
            this.locked = locked;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder comments(@Nullable Integer comments) {
            this.comments = comments;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pullRequest(PullRequest pullRequest) {
            this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder pullRequest(Optional<? extends PullRequest> pullRequest) {
            this.pullRequest = pullRequest.orElse(null);
            return this;
        }

        public ImmutableIssue build() {
            return new ImmutableIssue(this.createdAt, this.updatedAt, this.closedAt, this.id, this.url, this.eventsUrl, this.repositoryUrl, this.labelsUrl, this.commentsUrl, this.htmlUrl, this.number, this.state, this.title, this.body, this.user, this.labels == null ? null : ImmutableIssue.createUnmodifiableList(true, this.labels), this.assignee, this.milestone, this.locked, this.comments, this.pullRequest);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Issue", generator="Immutables")
    static final class Json
    implements Issue {
        @Nullable
        GitHubInstant createdAt;
        @Nullable
        GitHubInstant updatedAt;
        @Nullable
        Optional<GitHubInstant> closedAt = Optional.empty();
        @Nullable
        Long id;
        @Nullable
        URI url;
        @Nullable
        Optional<URI> eventsUrl = Optional.empty();
        @Nullable
        Optional<URI> repositoryUrl = Optional.empty();
        @Nullable
        String labelsUrl;
        @Nullable
        URI commentsUrl;
        @Nullable
        URI htmlUrl;
        @Nullable
        Long number;
        @Nullable
        String state;
        @Nullable
        String title;
        @Nullable
        Optional<String> body = Optional.empty();
        @Nullable
        User user;
        @Nullable
        List<Label> labels = null;
        @Nullable
        Optional<User> assignee = Optional.empty();
        @Nullable
        Optional<Milestone> milestone = Optional.empty();
        @Nullable
        Boolean locked;
        @Nullable
        Integer comments;
        @Nullable
        Optional<PullRequest> pullRequest = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setCreatedAt(@Nullable GitHubInstant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setClosedAt(Optional<GitHubInstant> closedAt) {
            this.closedAt = closedAt;
        }

        @JsonProperty
        public void setId(@Nullable Long id) {
            this.id = id;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setEventsUrl(Optional<URI> eventsUrl) {
            this.eventsUrl = eventsUrl;
        }

        @JsonProperty
        public void setRepositoryUrl(Optional<URI> repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
        }

        @JsonProperty
        public void setLabelsUrl(@Nullable String labelsUrl) {
            this.labelsUrl = labelsUrl;
        }

        @JsonProperty
        public void setCommentsUrl(@Nullable URI commentsUrl) {
            this.commentsUrl = commentsUrl;
        }

        @JsonProperty
        public void setHtmlUrl(@Nullable URI htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setNumber(@Nullable Long number) {
            this.number = number;
        }

        @JsonProperty
        public void setState(@Nullable String state) {
            this.state = state;
        }

        @JsonProperty
        public void setTitle(@Nullable String title) {
            this.title = title;
        }

        @JsonProperty
        public void setBody(Optional<String> body) {
            this.body = body;
        }

        @JsonProperty
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty
        public void setLabels(@Nullable List<Label> labels) {
            this.labels = labels;
        }

        @JsonProperty
        public void setAssignee(Optional<User> assignee) {
            this.assignee = assignee;
        }

        @JsonProperty
        public void setMilestone(Optional<Milestone> milestone) {
            this.milestone = milestone;
        }

        @JsonProperty
        public void setLocked(@Nullable Boolean locked) {
            this.locked = locked;
        }

        @JsonProperty
        public void setComments(@Nullable Integer comments) {
            this.comments = comments;
        }

        @JsonProperty
        public void setPullRequest(Optional<PullRequest> pullRequest) {
            this.pullRequest = pullRequest;
        }

        @Override
        public GitHubInstant createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GitHubInstant updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<GitHubInstant> closedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<URI> eventsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<URI> repositoryUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String labelsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI commentsUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long number() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String state() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> body() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Label> labels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<User> assignee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Milestone> milestone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean locked() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer comments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<PullRequest> pullRequest() {
            throw new UnsupportedOperationException();
        }
    }
}

