/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.Team;
import com.spotify.github.v3.User;
import com.spotify.github.v3.prs.ReviewRequests;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReviewRequests", generator="Immutables")
@Immutable
public final class ImmutableReviewRequests
implements ReviewRequests {
    @Nullable
    private final List<User> users;
    @Nullable
    private final List<Team> teams;

    private ImmutableReviewRequests(@Nullable List<User> users, @Nullable List<Team> teams) {
        this.users = users;
        this.teams = teams;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<User> users() {
        return this.users;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<Team> teams() {
        return this.teams;
    }

    public final ImmutableReviewRequests withUsers(User ... elements) {
        if (elements == null) {
            return new ImmutableReviewRequests(null, this.teams);
        }
        List<User> newValue = Arrays.asList(elements) == null ? null : ImmutableReviewRequests.createUnmodifiableList(false, ImmutableReviewRequests.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableReviewRequests(newValue, this.teams);
    }

    public final ImmutableReviewRequests withUsers(@Nullable Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = elements == null ? null : ImmutableReviewRequests.createUnmodifiableList(false, ImmutableReviewRequests.createSafeList(elements, true, false));
        return new ImmutableReviewRequests(newValue, this.teams);
    }

    public final ImmutableReviewRequests withTeams(Team ... elements) {
        if (elements == null) {
            return new ImmutableReviewRequests(this.users, null);
        }
        List<Team> newValue = Arrays.asList(elements) == null ? null : ImmutableReviewRequests.createUnmodifiableList(false, ImmutableReviewRequests.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableReviewRequests(this.users, newValue);
    }

    public final ImmutableReviewRequests withTeams(@Nullable Iterable<? extends Team> elements) {
        if (this.teams == elements) {
            return this;
        }
        List<Team> newValue = elements == null ? null : ImmutableReviewRequests.createUnmodifiableList(false, ImmutableReviewRequests.createSafeList(elements, true, false));
        return new ImmutableReviewRequests(this.users, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReviewRequests && this.equalTo(0, (ImmutableReviewRequests)another);
    }

    private boolean equalTo(int synthetic, ImmutableReviewRequests another) {
        return Objects.equals(this.users, another.users) && Objects.equals(this.teams, another.teams);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.users);
        h += (h << 5) + Objects.hashCode(this.teams);
        return h;
    }

    public String toString() {
        return "ReviewRequests{users=" + String.valueOf(this.users) + ", teams=" + String.valueOf(this.teams) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReviewRequests fromJson(Json json) {
        Builder builder = ImmutableReviewRequests.builder();
        if (json.users != null) {
            builder.addAllUsers(json.users);
        }
        if (json.teams != null) {
            builder.addAllTeams(json.teams);
        }
        return builder.build();
    }

    public static ImmutableReviewRequests copyOf(ReviewRequests instance) {
        if (instance instanceof ImmutableReviewRequests) {
            return (ImmutableReviewRequests)instance;
        }
        return ImmutableReviewRequests.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ReviewRequests", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<User> users = null;
        private List<Team> teams = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReviewRequests instance) {
            List<Team> teamsValue;
            Objects.requireNonNull(instance, "instance");
            List<User> usersValue = instance.users();
            if (usersValue != null) {
                this.addAllUsers(usersValue);
            }
            if ((teamsValue = instance.teams()) != null) {
                this.addAllTeams(teamsValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUsers(User element) {
            if (this.users == null) {
                this.users = new ArrayList<User>();
            }
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUsers(User ... elements) {
            if (this.users == null) {
                this.users = new ArrayList<User>();
            }
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder users(@Nullable Iterable<? extends User> elements) {
            if (elements == null) {
                this.users = null;
                return this;
            }
            this.users = new ArrayList<User>();
            return this.addAllUsers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllUsers(Iterable<? extends User> elements) {
            Objects.requireNonNull(elements, "users element");
            if (this.users == null) {
                this.users = new ArrayList<User>();
            }
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTeams(Team element) {
            if (this.teams == null) {
                this.teams = new ArrayList<Team>();
            }
            this.teams.add(Objects.requireNonNull(element, "teams element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTeams(Team ... elements) {
            if (this.teams == null) {
                this.teams = new ArrayList<Team>();
            }
            for (Team element : elements) {
                this.teams.add(Objects.requireNonNull(element, "teams element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder teams(@Nullable Iterable<? extends Team> elements) {
            if (elements == null) {
                this.teams = null;
                return this;
            }
            this.teams = new ArrayList<Team>();
            return this.addAllTeams(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTeams(Iterable<? extends Team> elements) {
            Objects.requireNonNull(elements, "teams element");
            if (this.teams == null) {
                this.teams = new ArrayList<Team>();
            }
            for (Team team : elements) {
                this.teams.add(Objects.requireNonNull(team, "teams element"));
            }
            return this;
        }

        public ImmutableReviewRequests build() {
            return new ImmutableReviewRequests(this.users == null ? null : ImmutableReviewRequests.createUnmodifiableList(true, this.users), this.teams == null ? null : ImmutableReviewRequests.createUnmodifiableList(true, this.teams));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReviewRequests", generator="Immutables")
    static final class Json
    implements ReviewRequests {
        @Nullable
        List<User> users = null;
        @Nullable
        List<Team> teams = null;

        Json() {
        }

        @JsonProperty
        public void setUsers(@Nullable List<User> users) {
            this.users = users;
        }

        @JsonProperty
        public void setTeams(@Nullable List<Team> teams) {
            this.teams = teams;
        }

        @Override
        public List<User> users() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Team> teams() {
            throw new UnsupportedOperationException();
        }
    }
}

