/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.User;
import com.spotify.github.v3.repos.Repository;
import com.spotify.github.v3.repos.RepositoryInvitation;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RepositoryInvitation", generator="Immutables")
@Immutable
public final class ImmutableRepositoryInvitation
implements RepositoryInvitation {
    private final Integer id;
    private final String nodeId;
    private final Repository repository;
    @Nullable
    private final User invitee;
    @Nullable
    private final User inviter;
    private final String permissions;
    private final ZonedDateTime createdAt;
    @Nullable
    private final Boolean expired;
    private final URI url;
    private final URI htmlUrl;

    private ImmutableRepositoryInvitation(Integer id, String nodeId, Repository repository, @Nullable User invitee, @Nullable User inviter, String permissions, ZonedDateTime createdAt, @Nullable Boolean expired, URI url, URI htmlUrl) {
        this.id = id;
        this.nodeId = nodeId;
        this.repository = repository;
        this.invitee = invitee;
        this.inviter = inviter;
        this.permissions = permissions;
        this.createdAt = createdAt;
        this.expired = expired;
        this.url = url;
        this.htmlUrl = htmlUrl;
    }

    @Override
    @JsonProperty
    public Integer id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String nodeId() {
        return this.nodeId;
    }

    @Override
    @JsonProperty
    public Repository repository() {
        return this.repository;
    }

    @Override
    @JsonProperty
    @Nullable
    public User invitee() {
        return this.invitee;
    }

    @Override
    @JsonProperty
    @Nullable
    public User inviter() {
        return this.inviter;
    }

    @Override
    @JsonProperty
    public String permissions() {
        return this.permissions;
    }

    @Override
    @JsonProperty
    public ZonedDateTime createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> expired() {
        return Optional.ofNullable(this.expired);
    }

    @Override
    @JsonProperty
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    public URI htmlUrl() {
        return this.htmlUrl;
    }

    public final ImmutableRepositoryInvitation withId(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableRepositoryInvitation(newValue, this.nodeId, this.repository, this.invitee, this.inviter, this.permissions, this.createdAt, this.expired, this.url, this.htmlUrl);
    }

    public final ImmutableRepositoryInvitation withNodeId(String value) {
        String newValue = Objects.requireNonNull(value, "nodeId");
        if (this.nodeId.equals(newValue)) {
            return this;
        }
        return new ImmutableRepositoryInvitation(this.id, newValue, this.repository, this.invitee, this.inviter, this.permissions, this.createdAt, this.expired, this.url, this.htmlUrl);
    }

    public final ImmutableRepositoryInvitation withRepository(Repository value) {
        if (this.repository == value) {
            return this;
        }
        Repository newValue = Objects.requireNonNull(value, "repository");
        return new ImmutableRepositoryInvitation(this.id, this.nodeId, newValue, this.invitee, this.inviter, this.permissions, this.createdAt, this.expired, this.url, this.htmlUrl);
    }

    public final ImmutableRepositoryInvitation withInvitee(@Nullable User value) {
        if (this.invitee == value) {
            return this;
        }
        return new ImmutableRepositoryInvitation(this.id, this.nodeId, this.repository, value, this.inviter, this.permissions, this.createdAt, this.expired, this.url, this.htmlUrl);
    }

    public final ImmutableRepositoryInvitation withInviter(@Nullable User value) {
        if (this.inviter == value) {
            return this;
        }
        return new ImmutableRepositoryInvitation(this.id, this.nodeId, this.repository, this.invitee, value, this.permissions, this.createdAt, this.expired, this.url, this.htmlUrl);
    }

    public final ImmutableRepositoryInvitation withPermissions(String value) {
        String newValue = Objects.requireNonNull(value, "permissions");
        if (this.permissions.equals(newValue)) {
            return this;
        }
        return new ImmutableRepositoryInvitation(this.id, this.nodeId, this.repository, this.invitee, this.inviter, newValue, this.createdAt, this.expired, this.url, this.htmlUrl);
    }

    public final ImmutableRepositoryInvitation withCreatedAt(ZonedDateTime value) {
        if (this.createdAt == value) {
            return this;
        }
        ZonedDateTime newValue = Objects.requireNonNull(value, "createdAt");
        return new ImmutableRepositoryInvitation(this.id, this.nodeId, this.repository, this.invitee, this.inviter, this.permissions, newValue, this.expired, this.url, this.htmlUrl);
    }

    public final ImmutableRepositoryInvitation withExpired(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.expired, newValue)) {
            return this;
        }
        return new ImmutableRepositoryInvitation(this.id, this.nodeId, this.repository, this.invitee, this.inviter, this.permissions, this.createdAt, newValue, this.url, this.htmlUrl);
    }

    public final ImmutableRepositoryInvitation withExpired(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.expired, value)) {
            return this;
        }
        return new ImmutableRepositoryInvitation(this.id, this.nodeId, this.repository, this.invitee, this.inviter, this.permissions, this.createdAt, value, this.url, this.htmlUrl);
    }

    public final ImmutableRepositoryInvitation withUrl(URI value) {
        if (this.url == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "url");
        return new ImmutableRepositoryInvitation(this.id, this.nodeId, this.repository, this.invitee, this.inviter, this.permissions, this.createdAt, this.expired, newValue, this.htmlUrl);
    }

    public final ImmutableRepositoryInvitation withHtmlUrl(URI value) {
        if (this.htmlUrl == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "htmlUrl");
        return new ImmutableRepositoryInvitation(this.id, this.nodeId, this.repository, this.invitee, this.inviter, this.permissions, this.createdAt, this.expired, this.url, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepositoryInvitation && this.equalTo(0, (ImmutableRepositoryInvitation)another);
    }

    private boolean equalTo(int synthetic, ImmutableRepositoryInvitation another) {
        return this.id.equals(another.id) && this.nodeId.equals(another.nodeId) && this.repository.equals(another.repository) && Objects.equals(this.invitee, another.invitee) && Objects.equals(this.inviter, another.inviter) && this.permissions.equals(another.permissions) && this.createdAt.equals(another.createdAt) && Objects.equals(this.expired, another.expired) && this.url.equals(another.url) && this.htmlUrl.equals(another.htmlUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.nodeId.hashCode();
        h += (h << 5) + this.repository.hashCode();
        h += (h << 5) + Objects.hashCode(this.invitee);
        h += (h << 5) + Objects.hashCode(this.inviter);
        h += (h << 5) + this.permissions.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + Objects.hashCode(this.expired);
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.htmlUrl.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RepositoryInvitation{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("nodeId=").append(this.nodeId);
        builder.append(", ");
        builder.append("repository=").append(this.repository);
        if (this.invitee != null) {
            builder.append(", ");
            builder.append("invitee=").append(this.invitee);
        }
        if (this.inviter != null) {
            builder.append(", ");
            builder.append("inviter=").append(this.inviter);
        }
        builder.append(", ");
        builder.append("permissions=").append(this.permissions);
        builder.append(", ");
        builder.append("createdAt=").append(this.createdAt);
        if (this.expired != null) {
            builder.append(", ");
            builder.append("expired=").append(this.expired);
        }
        builder.append(", ");
        builder.append("url=").append(this.url);
        builder.append(", ");
        builder.append("htmlUrl=").append(this.htmlUrl);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRepositoryInvitation fromJson(Json json) {
        Builder builder = ImmutableRepositoryInvitation.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.nodeId != null) {
            builder.nodeId(json.nodeId);
        }
        if (json.repository != null) {
            builder.repository(json.repository);
        }
        if (json.invitee != null) {
            builder.invitee(json.invitee);
        }
        if (json.inviter != null) {
            builder.inviter(json.inviter);
        }
        if (json.permissions != null) {
            builder.permissions(json.permissions);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.expired != null) {
            builder.expired(json.expired);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        return builder.build();
    }

    public static ImmutableRepositoryInvitation copyOf(RepositoryInvitation instance) {
        if (instance instanceof ImmutableRepositoryInvitation) {
            return (ImmutableRepositoryInvitation)instance;
        }
        return ImmutableRepositoryInvitation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RepositoryInvitation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NODE_ID = 2L;
        private static final long INIT_BIT_REPOSITORY = 4L;
        private static final long INIT_BIT_PERMISSIONS = 8L;
        private static final long INIT_BIT_CREATED_AT = 16L;
        private static final long INIT_BIT_URL = 32L;
        private static final long INIT_BIT_HTML_URL = 64L;
        private long initBits = 127L;
        @Nullable
        private Integer id;
        @Nullable
        private String nodeId;
        @Nullable
        private Repository repository;
        @Nullable
        private User invitee;
        @Nullable
        private User inviter;
        @Nullable
        private String permissions;
        @Nullable
        private ZonedDateTime createdAt;
        @Nullable
        private Boolean expired;
        @Nullable
        private URI url;
        @Nullable
        private URI htmlUrl;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RepositoryInvitation instance) {
            User inviterValue;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.nodeId(instance.nodeId());
            this.repository(instance.repository());
            User inviteeValue = instance.invitee();
            if (inviteeValue != null) {
                this.invitee(inviteeValue);
            }
            if ((inviterValue = instance.inviter()) != null) {
                this.inviter(inviterValue);
            }
            this.permissions(instance.permissions());
            this.createdAt(instance.createdAt());
            Optional<Boolean> expiredOptional = instance.expired();
            if (expiredOptional.isPresent()) {
                this.expired(expiredOptional);
            }
            this.url(instance.url());
            this.htmlUrl(instance.htmlUrl());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(Integer id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder nodeId(String nodeId) {
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder repository(Repository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder invitee(@Nullable User invitee) {
            this.invitee = invitee;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder inviter(@Nullable User inviter) {
            this.inviter = inviter;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder permissions(String permissions) {
            this.permissions = Objects.requireNonNull(permissions, "permissions");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(ZonedDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expired(boolean expired) {
            this.expired = expired;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder expired(Optional<Boolean> expired) {
            this.expired = expired.orElse(null);
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(URI url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(URI htmlUrl) {
            this.htmlUrl = Objects.requireNonNull(htmlUrl, "htmlUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableRepositoryInvitation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRepositoryInvitation(this.id, this.nodeId, this.repository, this.invitee, this.inviter, this.permissions, this.createdAt, this.expired, this.url, this.htmlUrl);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("nodeId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("repository");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("permissions");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("htmlUrl");
            }
            return "Cannot build RepositoryInvitation, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RepositoryInvitation", generator="Immutables")
    static final class Json
    implements RepositoryInvitation {
        @Nullable
        Integer id;
        @Nullable
        String nodeId;
        @Nullable
        Repository repository;
        @Nullable
        User invitee;
        @Nullable
        User inviter;
        @Nullable
        String permissions;
        @Nullable
        ZonedDateTime createdAt;
        @Nullable
        Optional<Boolean> expired = Optional.empty();
        @Nullable
        URI url;
        @Nullable
        URI htmlUrl;

        Json() {
        }

        @JsonProperty
        public void setId(Integer id) {
            this.id = id;
        }

        @JsonProperty
        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @JsonProperty
        public void setRepository(Repository repository) {
            this.repository = repository;
        }

        @JsonProperty
        public void setInvitee(@Nullable User invitee) {
            this.invitee = invitee;
        }

        @JsonProperty
        public void setInviter(@Nullable User inviter) {
            this.inviter = inviter;
        }

        @JsonProperty
        public void setPermissions(String permissions) {
            this.permissions = permissions;
        }

        @JsonProperty
        public void setCreatedAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setExpired(Optional<Boolean> expired) {
            this.expired = expired;
        }

        @JsonProperty
        public void setUrl(URI url) {
            this.url = url;
        }

        @JsonProperty
        public void setHtmlUrl(URI htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @Override
        public Integer id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nodeId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Repository repository() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User invitee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public User inviter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String permissions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZonedDateTime createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> expired() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI htmlUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

