/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.repos.requests;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.repos.requests.FileUpdate;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FileUpdate", generator="Immutables")
@Immutable
public final class ImmutableFileUpdate
implements FileUpdate {
    private final String message;
    private final String content;
    private final String sha;
    @Nullable
    private final String branch;

    private ImmutableFileUpdate(String message, String content, String sha, @Nullable String branch) {
        this.message = message;
        this.content = content;
        this.sha = sha;
        this.branch = branch;
    }

    @Override
    @JsonProperty
    public String message() {
        return this.message;
    }

    @Override
    @JsonProperty
    public String content() {
        return this.content;
    }

    @Override
    @JsonProperty
    public String sha() {
        return this.sha;
    }

    @Override
    @JsonProperty
    @Nullable
    public String branch() {
        return this.branch;
    }

    public final ImmutableFileUpdate withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableFileUpdate(newValue, this.content, this.sha, this.branch);
    }

    public final ImmutableFileUpdate withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutableFileUpdate(this.message, newValue, this.sha, this.branch);
    }

    public final ImmutableFileUpdate withSha(String value) {
        String newValue = Objects.requireNonNull(value, "sha");
        if (this.sha.equals(newValue)) {
            return this;
        }
        return new ImmutableFileUpdate(this.message, this.content, newValue, this.branch);
    }

    public final ImmutableFileUpdate withBranch(@Nullable String value) {
        if (Objects.equals(this.branch, value)) {
            return this;
        }
        return new ImmutableFileUpdate(this.message, this.content, this.sha, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileUpdate && this.equalTo(0, (ImmutableFileUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableFileUpdate another) {
        return this.message.equals(another.message) && this.content.equals(another.content) && this.sha.equals(another.sha) && Objects.equals(this.branch, another.branch);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.content.hashCode();
        h += (h << 5) + this.sha.hashCode();
        h += (h << 5) + Objects.hashCode(this.branch);
        return h;
    }

    public String toString() {
        return "FileUpdate{message=" + this.message + ", content=" + this.content + ", sha=" + this.sha + ", branch=" + this.branch + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFileUpdate fromJson(Json json) {
        Builder builder = ImmutableFileUpdate.builder();
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.sha != null) {
            builder.sha(json.sha);
        }
        if (json.branch != null) {
            builder.branch(json.branch);
        }
        return builder.build();
    }

    public static ImmutableFileUpdate copyOf(FileUpdate instance) {
        if (instance instanceof ImmutableFileUpdate) {
            return (ImmutableFileUpdate)instance;
        }
        return ImmutableFileUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FileUpdate", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private static final long INIT_BIT_CONTENT = 2L;
        private static final long INIT_BIT_SHA = 4L;
        private long initBits = 7L;
        @Nullable
        private String message;
        @Nullable
        private String content;
        @Nullable
        private String sha;
        @Nullable
        private String branch;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FileUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.message(instance.message());
            this.content(instance.content());
            this.sha(instance.sha());
            String branchValue = instance.branch();
            if (branchValue != null) {
                this.branch(branchValue);
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sha(String sha) {
            this.sha = Objects.requireNonNull(sha, "sha");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder branch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        public ImmutableFileUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileUpdate(this.message, this.content, this.sha, this.branch);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("content");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sha");
            }
            return "Cannot build FileUpdate, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FileUpdate", generator="Immutables")
    static final class Json
    implements FileUpdate {
        @Nullable
        String message;
        @Nullable
        String content;
        @Nullable
        String sha;
        @Nullable
        String branch;

        Json() {
        }

        @JsonProperty
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty
        public void setContent(String content) {
            this.content = content;
        }

        @JsonProperty
        public void setSha(String sha) {
            this.sha = sha;
        }

        @JsonProperty
        public void setBranch(@Nullable String branch) {
            this.branch = branch;
        }

        @Override
        public String message() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String content() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sha() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String branch() {
            throw new UnsupportedOperationException();
        }
    }
}

