/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.repos.Repository;
import com.spotify.github.v3.search.Search;
import com.spotify.github.v3.search.SearchRepositories;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SearchRepositories", generator="Immutables")
@Immutable
public final class ImmutableSearchRepositories
implements SearchRepositories {
    @Nullable
    private final Integer totalCount;
    @Nullable
    private final Boolean incompleteResults;
    @Nullable
    private final List<Repository> items;

    private ImmutableSearchRepositories(@Nullable Integer totalCount, @Nullable Boolean incompleteResults, @Nullable List<Repository> items) {
        this.totalCount = totalCount;
        this.incompleteResults = incompleteResults;
        this.items = items;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer totalCount() {
        return this.totalCount;
    }

    @Override
    @JsonProperty
    @Nullable
    public Boolean incompleteResults() {
        return this.incompleteResults;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<Repository> items() {
        return this.items;
    }

    public final ImmutableSearchRepositories withTotalCount(@Nullable Integer value) {
        if (Objects.equals(this.totalCount, value)) {
            return this;
        }
        return new ImmutableSearchRepositories(value, this.incompleteResults, this.items);
    }

    public final ImmutableSearchRepositories withIncompleteResults(@Nullable Boolean value) {
        if (Objects.equals(this.incompleteResults, value)) {
            return this;
        }
        return new ImmutableSearchRepositories(this.totalCount, value, this.items);
    }

    public final ImmutableSearchRepositories withItems(Repository ... elements) {
        if (elements == null) {
            return new ImmutableSearchRepositories(this.totalCount, this.incompleteResults, null);
        }
        List<Repository> newValue = Arrays.asList(elements) == null ? null : ImmutableSearchRepositories.createUnmodifiableList(false, ImmutableSearchRepositories.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSearchRepositories(this.totalCount, this.incompleteResults, newValue);
    }

    public final ImmutableSearchRepositories withItems(@Nullable Iterable<? extends Repository> elements) {
        if (this.items == elements) {
            return this;
        }
        List<Repository> newValue = elements == null ? null : ImmutableSearchRepositories.createUnmodifiableList(false, ImmutableSearchRepositories.createSafeList(elements, true, false));
        return new ImmutableSearchRepositories(this.totalCount, this.incompleteResults, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSearchRepositories && this.equalTo(0, (ImmutableSearchRepositories)another);
    }

    private boolean equalTo(int synthetic, ImmutableSearchRepositories another) {
        return Objects.equals(this.totalCount, another.totalCount) && Objects.equals(this.incompleteResults, another.incompleteResults) && Objects.equals(this.items, another.items);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.totalCount);
        h += (h << 5) + Objects.hashCode(this.incompleteResults);
        h += (h << 5) + Objects.hashCode(this.items);
        return h;
    }

    public String toString() {
        return "SearchRepositories{totalCount=" + this.totalCount + ", incompleteResults=" + this.incompleteResults + ", items=" + String.valueOf(this.items) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSearchRepositories fromJson(Json json) {
        Builder builder = ImmutableSearchRepositories.builder();
        if (json.totalCount != null) {
            builder.totalCount(json.totalCount);
        }
        if (json.incompleteResults != null) {
            builder.incompleteResults(json.incompleteResults);
        }
        if (json.items != null) {
            builder.addAllItems(json.items);
        }
        return builder.build();
    }

    public static ImmutableSearchRepositories copyOf(SearchRepositories instance) {
        if (instance instanceof ImmutableSearchRepositories) {
            return (ImmutableSearchRepositories)instance;
        }
        return ImmutableSearchRepositories.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SearchRepositories", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Integer totalCount;
        @Nullable
        private Boolean incompleteResults;
        private List<Repository> items = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SearchRepositories instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Search instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Boolean incompleteResultsValue;
            Integer totalCountValue;
            Search instance;
            long bits = 0L;
            if (object instanceof SearchRepositories) {
                List<Repository> itemsValue;
                instance = (SearchRepositories)object;
                if ((bits & 2L) == 0L) {
                    totalCountValue = instance.totalCount();
                    if (totalCountValue != null) {
                        this.totalCount(totalCountValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    incompleteResultsValue = instance.incompleteResults();
                    if (incompleteResultsValue != null) {
                        this.incompleteResults(incompleteResultsValue);
                    }
                    bits |= 1L;
                }
                if ((itemsValue = instance.items()) != null) {
                    this.addAllItems(itemsValue);
                }
            }
            if (object instanceof Search) {
                instance = (Search)object;
                if ((bits & 2L) == 0L) {
                    totalCountValue = instance.totalCount();
                    if (totalCountValue != null) {
                        this.totalCount(totalCountValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    incompleteResultsValue = instance.incompleteResults();
                    if (incompleteResultsValue != null) {
                        this.incompleteResults(incompleteResultsValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder totalCount(@Nullable Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder incompleteResults(@Nullable Boolean incompleteResults) {
            this.incompleteResults = incompleteResults;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItems(Repository element) {
            if (this.items == null) {
                this.items = new ArrayList<Repository>();
            }
            this.items.add(Objects.requireNonNull(element, "items element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addItems(Repository ... elements) {
            if (this.items == null) {
                this.items = new ArrayList<Repository>();
            }
            for (Repository element : elements) {
                this.items.add(Objects.requireNonNull(element, "items element"));
            }
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder items(@Nullable Iterable<? extends Repository> elements) {
            if (elements == null) {
                this.items = null;
                return this;
            }
            this.items = new ArrayList<Repository>();
            return this.addAllItems(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllItems(Iterable<? extends Repository> elements) {
            Objects.requireNonNull(elements, "items element");
            if (this.items == null) {
                this.items = new ArrayList<Repository>();
            }
            for (Repository repository : elements) {
                this.items.add(Objects.requireNonNull(repository, "items element"));
            }
            return this;
        }

        public ImmutableSearchRepositories build() {
            return new ImmutableSearchRepositories(this.totalCount, this.incompleteResults, this.items == null ? null : ImmutableSearchRepositories.createUnmodifiableList(true, this.items));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SearchRepositories", generator="Immutables")
    static final class Json
    implements SearchRepositories {
        @Nullable
        Integer totalCount;
        @Nullable
        Boolean incompleteResults;
        @Nullable
        List<Repository> items = null;

        Json() {
        }

        @JsonProperty
        public void setTotalCount(@Nullable Integer totalCount) {
            this.totalCount = totalCount;
        }

        @JsonProperty
        public void setIncompleteResults(@Nullable Boolean incompleteResults) {
            this.incompleteResults = incompleteResults;
        }

        @JsonProperty
        public void setItems(@Nullable List<Repository> items) {
            this.items = items;
        }

        @Override
        public Integer totalCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean incompleteResults() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Repository> items() {
            throw new UnsupportedOperationException();
        }
    }
}

