/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.github.v3.workflows;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.spotify.github.v3.workflows.WorkflowsResponse;
import com.spotify.github.v3.workflows.WorkflowsState;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WorkflowsResponse", generator="Immutables")
@Immutable
public final class ImmutableWorkflowsResponse
implements WorkflowsResponse {
    private final int id;
    private final String nodeId;
    private final String name;
    private final String path;
    private final WorkflowsState state;
    private final ZonedDateTime createdAt;
    private final ZonedDateTime updatedAt;
    @Nullable
    private final ZonedDateTime deletedAt;
    private final String url;
    private final String htmlUrl;
    private final String badgeUrl;

    private ImmutableWorkflowsResponse(int id, String nodeId, String name, String path, WorkflowsState state, ZonedDateTime createdAt, ZonedDateTime updatedAt, @Nullable ZonedDateTime deletedAt, String url, String htmlUrl, String badgeUrl) {
        this.id = id;
        this.nodeId = nodeId;
        this.name = name;
        this.path = path;
        this.state = state;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.deletedAt = deletedAt;
        this.url = url;
        this.htmlUrl = htmlUrl;
        this.badgeUrl = badgeUrl;
    }

    @Override
    @JsonProperty
    public int id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String nodeId() {
        return this.nodeId;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public String path() {
        return this.path;
    }

    @Override
    @JsonProperty
    public WorkflowsState state() {
        return this.state;
    }

    @Override
    @JsonProperty
    public ZonedDateTime createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty
    public ZonedDateTime updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty
    @Nullable
    public ZonedDateTime deletedAt() {
        return this.deletedAt;
    }

    @Override
    @JsonProperty
    public String url() {
        return this.url;
    }

    @Override
    @JsonProperty
    public String htmlUrl() {
        return this.htmlUrl;
    }

    @Override
    @JsonProperty
    public String badgeUrl() {
        return this.badgeUrl;
    }

    public final ImmutableWorkflowsResponse withId(int value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableWorkflowsResponse(value, this.nodeId, this.name, this.path, this.state, this.createdAt, this.updatedAt, this.deletedAt, this.url, this.htmlUrl, this.badgeUrl);
    }

    public final ImmutableWorkflowsResponse withNodeId(String value) {
        String newValue = Objects.requireNonNull(value, "nodeId");
        if (this.nodeId.equals(newValue)) {
            return this;
        }
        return new ImmutableWorkflowsResponse(this.id, newValue, this.name, this.path, this.state, this.createdAt, this.updatedAt, this.deletedAt, this.url, this.htmlUrl, this.badgeUrl);
    }

    public final ImmutableWorkflowsResponse withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableWorkflowsResponse(this.id, this.nodeId, newValue, this.path, this.state, this.createdAt, this.updatedAt, this.deletedAt, this.url, this.htmlUrl, this.badgeUrl);
    }

    public final ImmutableWorkflowsResponse withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableWorkflowsResponse(this.id, this.nodeId, this.name, newValue, this.state, this.createdAt, this.updatedAt, this.deletedAt, this.url, this.htmlUrl, this.badgeUrl);
    }

    public final ImmutableWorkflowsResponse withState(WorkflowsState value) {
        WorkflowsState newValue = Objects.requireNonNull(value, "state");
        if (this.state == newValue) {
            return this;
        }
        return new ImmutableWorkflowsResponse(this.id, this.nodeId, this.name, this.path, newValue, this.createdAt, this.updatedAt, this.deletedAt, this.url, this.htmlUrl, this.badgeUrl);
    }

    public final ImmutableWorkflowsResponse withCreatedAt(ZonedDateTime value) {
        if (this.createdAt == value) {
            return this;
        }
        ZonedDateTime newValue = Objects.requireNonNull(value, "createdAt");
        return new ImmutableWorkflowsResponse(this.id, this.nodeId, this.name, this.path, this.state, newValue, this.updatedAt, this.deletedAt, this.url, this.htmlUrl, this.badgeUrl);
    }

    public final ImmutableWorkflowsResponse withUpdatedAt(ZonedDateTime value) {
        if (this.updatedAt == value) {
            return this;
        }
        ZonedDateTime newValue = Objects.requireNonNull(value, "updatedAt");
        return new ImmutableWorkflowsResponse(this.id, this.nodeId, this.name, this.path, this.state, this.createdAt, newValue, this.deletedAt, this.url, this.htmlUrl, this.badgeUrl);
    }

    public final ImmutableWorkflowsResponse withDeletedAt(@Nullable ZonedDateTime value) {
        if (this.deletedAt == value) {
            return this;
        }
        return new ImmutableWorkflowsResponse(this.id, this.nodeId, this.name, this.path, this.state, this.createdAt, this.updatedAt, value, this.url, this.htmlUrl, this.badgeUrl);
    }

    public final ImmutableWorkflowsResponse withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableWorkflowsResponse(this.id, this.nodeId, this.name, this.path, this.state, this.createdAt, this.updatedAt, this.deletedAt, newValue, this.htmlUrl, this.badgeUrl);
    }

    public final ImmutableWorkflowsResponse withHtmlUrl(String value) {
        String newValue = Objects.requireNonNull(value, "htmlUrl");
        if (this.htmlUrl.equals(newValue)) {
            return this;
        }
        return new ImmutableWorkflowsResponse(this.id, this.nodeId, this.name, this.path, this.state, this.createdAt, this.updatedAt, this.deletedAt, this.url, newValue, this.badgeUrl);
    }

    public final ImmutableWorkflowsResponse withBadgeUrl(String value) {
        String newValue = Objects.requireNonNull(value, "badgeUrl");
        if (this.badgeUrl.equals(newValue)) {
            return this;
        }
        return new ImmutableWorkflowsResponse(this.id, this.nodeId, this.name, this.path, this.state, this.createdAt, this.updatedAt, this.deletedAt, this.url, this.htmlUrl, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWorkflowsResponse && this.equalTo(0, (ImmutableWorkflowsResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableWorkflowsResponse another) {
        return this.id == another.id && this.nodeId.equals(another.nodeId) && this.name.equals(another.name) && this.path.equals(another.path) && this.state.equals((Object)another.state) && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && Objects.equals(this.deletedAt, another.deletedAt) && this.url.equals(another.url) && this.htmlUrl.equals(another.htmlUrl) && this.badgeUrl.equals(another.badgeUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id;
        h += (h << 5) + this.nodeId.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.updatedAt.hashCode();
        h += (h << 5) + Objects.hashCode(this.deletedAt);
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.htmlUrl.hashCode();
        h += (h << 5) + this.badgeUrl.hashCode();
        return h;
    }

    public String toString() {
        return "WorkflowsResponse{id=" + this.id + ", nodeId=" + this.nodeId + ", name=" + this.name + ", path=" + this.path + ", state=" + String.valueOf((Object)this.state) + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", deletedAt=" + String.valueOf(this.deletedAt) + ", url=" + this.url + ", htmlUrl=" + this.htmlUrl + ", badgeUrl=" + this.badgeUrl + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWorkflowsResponse fromJson(Json json) {
        Builder builder = ImmutableWorkflowsResponse.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.nodeId != null) {
            builder.nodeId(json.nodeId);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.path != null) {
            builder.path(json.path);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.deletedAt != null) {
            builder.deletedAt(json.deletedAt);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.htmlUrl != null) {
            builder.htmlUrl(json.htmlUrl);
        }
        if (json.badgeUrl != null) {
            builder.badgeUrl(json.badgeUrl);
        }
        return builder.build();
    }

    public static ImmutableWorkflowsResponse copyOf(WorkflowsResponse instance) {
        if (instance instanceof ImmutableWorkflowsResponse) {
            return (ImmutableWorkflowsResponse)instance;
        }
        return ImmutableWorkflowsResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WorkflowsResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NODE_ID = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long INIT_BIT_PATH = 8L;
        private static final long INIT_BIT_STATE = 16L;
        private static final long INIT_BIT_CREATED_AT = 32L;
        private static final long INIT_BIT_UPDATED_AT = 64L;
        private static final long INIT_BIT_URL = 128L;
        private static final long INIT_BIT_HTML_URL = 256L;
        private static final long INIT_BIT_BADGE_URL = 512L;
        private long initBits = 1023L;
        private int id;
        @Nullable
        private String nodeId;
        @Nullable
        private String name;
        @Nullable
        private String path;
        @Nullable
        private WorkflowsState state;
        @Nullable
        private ZonedDateTime createdAt;
        @Nullable
        private ZonedDateTime updatedAt;
        @Nullable
        private ZonedDateTime deletedAt;
        @Nullable
        private String url;
        @Nullable
        private String htmlUrl;
        @Nullable
        private String badgeUrl;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WorkflowsResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.nodeId(instance.nodeId());
            this.name(instance.name());
            this.path(instance.path());
            this.state(instance.state());
            this.createdAt(instance.createdAt());
            this.updatedAt(instance.updatedAt());
            ZonedDateTime deletedAtValue = instance.deletedAt();
            if (deletedAtValue != null) {
                this.deletedAt(deletedAtValue);
            }
            this.url(instance.url());
            this.htmlUrl(instance.htmlUrl());
            this.badgeUrl(instance.badgeUrl());
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(int id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder nodeId(String nodeId) {
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(WorkflowsState state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder createdAt(ZonedDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder deletedAt(@Nullable ZonedDateTime deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder htmlUrl(String htmlUrl) {
            this.htmlUrl = Objects.requireNonNull(htmlUrl, "htmlUrl");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder badgeUrl(String badgeUrl) {
            this.badgeUrl = Objects.requireNonNull(badgeUrl, "badgeUrl");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public ImmutableWorkflowsResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWorkflowsResponse(this.id, this.nodeId, this.name, this.path, this.state, this.createdAt, this.updatedAt, this.deletedAt, this.url, this.htmlUrl, this.badgeUrl);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("nodeId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("htmlUrl");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("badgeUrl");
            }
            return "Cannot build WorkflowsResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WorkflowsResponse", generator="Immutables")
    static final class Json
    implements WorkflowsResponse {
        int id;
        boolean idIsSet;
        @Nullable
        String nodeId;
        @Nullable
        String name;
        @Nullable
        String path;
        @Nullable
        WorkflowsState state;
        @Nullable
        ZonedDateTime createdAt;
        @Nullable
        ZonedDateTime updatedAt;
        @Nullable
        ZonedDateTime deletedAt;
        @Nullable
        String url;
        @Nullable
        String htmlUrl;
        @Nullable
        String badgeUrl;

        Json() {
        }

        @JsonProperty
        public void setId(int id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty
        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setPath(String path) {
            this.path = path;
        }

        @JsonProperty
        public void setState(WorkflowsState state) {
            this.state = state;
        }

        @JsonProperty
        public void setCreatedAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty
        public void setUpdatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty
        public void setDeletedAt(@Nullable ZonedDateTime deletedAt) {
            this.deletedAt = deletedAt;
        }

        @JsonProperty
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty
        public void setHtmlUrl(String htmlUrl) {
            this.htmlUrl = htmlUrl;
        }

        @JsonProperty
        public void setBadgeUrl(String badgeUrl) {
            this.badgeUrl = badgeUrl;
        }

        @Override
        public int id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nodeId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String path() {
            throw new UnsupportedOperationException();
        }

        @Override
        public WorkflowsState state() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZonedDateTime createdAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZonedDateTime updatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZonedDateTime deletedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String htmlUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String badgeUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

