/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.export;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.AbstractCommand;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.rowiterator.CsvRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.ExcelRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.ExcelUtils;
import com.sqlapp.data.schemas.rowiterator.JsonRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.exceptions.CommandException;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.JsonConverter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.supercsv.io.ICsvListWriter;

public class ConvertDataFileCommand
extends AbstractCommand {
    private Predicate<File> fileFilter = f -> true;
    private File directory = new File(".");
    private String csvEncoding = Charset.defaultCharset().toString();
    private JsonConverter jsonConverter = this.createJsonConverter();
    private boolean recursive = false;
    private String sheetName = "TABLE";
    private WorkbookFileType outputFileType = WorkbookFileType.EXCEL2007;
    private Converters converters = new Converters();
    private boolean removeOriginalFile = false;
    private File outputDirectory = null;

    @Override
    protected void doRun() {
        List<File> list = this.getFiles();
        for (File file : list) {
            ExcelRowIteratorHandler rowIteratorHandler;
            WorkbookFileType workbookFileType = WorkbookFileType.parse((File)file);
            Table table = new Table();
            if (workbookFileType.isWorkbook()) {
                rowIteratorHandler = new ExcelRowIteratorHandler(file);
                table.setRowIteratorHandler((RowIteratorHandler)rowIteratorHandler);
            } else if (workbookFileType.isCsv()) {
                rowIteratorHandler = new CsvRowIteratorHandler(file, this.getCsvEncoding());
                table.setRowIteratorHandler((RowIteratorHandler)rowIteratorHandler);
            } else if (workbookFileType.isJson()) {
                rowIteratorHandler = new JsonRowIteratorHandler(file, this.getJsonConverter());
                table.setRowIteratorHandler((RowIteratorHandler)rowIteratorHandler);
            } else {
                try {
                    table = (Table)SchemaUtils.readXml((File)file);
                }
                catch (Exception e) {
                    this.getExceptionHandler().handle((Throwable)new CommandException("file=" + file.getAbsolutePath(), (Throwable)e));
                }
            }
            File tempFile = null;
            try {
                File outputFile;
                if (this.getOutputDirectory() != null && !CommonUtils.eq((Object)this.getOutputDirectory(), (Object)this.getDirectory()) && !CommonUtils.eq((Object)this.getOutputDirectory(), (Object)file.getParentFile())) {
                    String path = file.getParentFile().getAbsolutePath();
                    path = FileUtils.combinePath((String[])new String[]{this.getOutputDirectory().getAbsolutePath(), path.substring(this.getDirectory().getAbsolutePath().length())});
                    File parent = new File(path);
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    tempFile = File.createTempFile(FileUtils.getFileNameWithoutExtension((String)file.getAbsolutePath()), "." + this.getOutputFileType().getFileExtension(), parent);
                    outputFile = new File(parent, FileUtils.getFileNameWithoutExtension((String)file.getAbsolutePath()) + "." + this.getOutputFileType().getFileExtension());
                } else {
                    tempFile = File.createTempFile(FileUtils.getFileNameWithoutExtension((String)file.getAbsolutePath()), "." + this.getOutputFileType().getFileExtension(), file.getParentFile());
                    outputFile = new File(file.getParentFile(), FileUtils.getFileNameWithoutExtension((String)file.getAbsolutePath()) + "." + this.getOutputFileType().getFileExtension());
                }
                if (this.getOutputFileType().isWorkbook()) {
                    this.readAll(table);
                    this.writeTableAsExcel(tempFile, table, this.getOutputFileType());
                } else if (this.getOutputFileType().isCsv()) {
                    this.readAll(table);
                    this.writeTableAsCsv(tempFile, table, this.getOutputFileType());
                } else if (this.getOutputFileType().isJson()) {
                    this.writeTableAsJson(tempFile, table, this.getOutputFileType());
                } else {
                    table.writeXml(tempFile);
                }
                tempFile.renameTo(outputFile);
                if (!this.isRemoveOriginalFile()) continue;
                file.delete();
            }
            catch (Exception e) {
                if (tempFile != null && tempFile.exists()) {
                    tempFile.delete();
                }
                this.getExceptionHandler().handle((Throwable)new CommandException("file=" + file.getAbsolutePath(), (Throwable)e));
            }
        }
    }

    private void readAll(Table table) {
        for (Row row : table.getRows()) {
        }
    }

    private void writeTableAsCsv(File file, Table table, WorkbookFileType workbookFileType) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, this.getCsvEncoding());
             BufferedWriter bw = new BufferedWriter(writer);
             ICsvListWriter csvWriter = workbookFileType.createCsvListWriter((Writer)bw);){
            List<String> headers = table.getColumns().stream().map(c -> c.getName()).collect(Collectors.toList());
            csvWriter.writeHeader(headers.toArray(new String[0]));
            String[] values = new String[table.getColumns().size()];
            for (Row row : table.getRows()) {
                int i = 0;
                boolean set = false;
                for (Column column : table.getColumns()) {
                    Object value = row.get(column);
                    String text = column.getConverter().convertString(value);
                    if (CommonUtils.isEmpty((CharSequence)text)) continue;
                    values[i++] = text;
                    set = true;
                }
                if (!set) continue;
                csvWriter.write(values);
            }
        }
    }

    private void writeTableAsJson(File file, Table table, WorkbookFileType workbookFileType) throws IOException, XMLStreamException {
        try (FileOutputStream fos = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF8");
             BufferedWriter bw = new BufferedWriter(writer);){
            bw.write("[");
            boolean first = true;
            for (Row row : table.getRows()) {
                Map map = row.getValuesAsMapWithoutNullValue();
                if (map.isEmpty()) continue;
                String text = this.getJsonConverter().toJsonString((Object)map);
                if (!first) {
                    bw.write(",\n");
                } else {
                    bw.write("\n");
                    first = false;
                }
                bw.write(text);
            }
            bw.write("]");
        }
    }

    private void writeTableAsExcel(File file, Table table, WorkbookFileType workbookFileType) throws FileNotFoundException, IOException, EncryptedDocumentException, InvalidFormatException {
        Cell cell;
        Workbook workbook = workbookFileType.createWorkbook();
        Sheet sheet = ExcelUtils.getFirstOrCreateSeet((Workbook)workbook, (String)this.getSheetName());
        int rownum = 0;
        org.apache.poi.ss.usermodel.Row headerRow = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)rownum++);
        int cellnum = 0;
        CreationHelper helper = workbook.getCreationHelper();
        for (Column column : table.getColumns()) {
            cell = ExcelUtils.getOrCreateCell((org.apache.poi.ss.usermodel.Row)headerRow, (int)cellnum++);
            ExcelUtils.setCell((Converters)this.getConverters(), (Workbook)workbook, (Cell)cell, (Object)column.getName());
        }
        for (Row row : table.getRows()) {
            org.apache.poi.ss.usermodel.Row dataRow = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)rownum++);
            cellnum = 0;
            for (Column column : table.getColumns()) {
                Object obj = row.get(column);
                if (obj != null) {
                    Cell cell2 = ExcelUtils.getOrCreateCell((org.apache.poi.ss.usermodel.Row)dataRow, (int)cellnum);
                    ExcelUtils.setCell((Converters)this.getConverters(), (Workbook)workbook, (Cell)cell2, (Object)obj);
                }
                ++cellnum;
            }
        }
        cellnum = 0;
        for (Column column : table.getColumns()) {
            sheet.autoSizeColumn(cellnum);
            if (column.getRemarks() != null) {
                cell = ExcelUtils.getOrCreateCell((org.apache.poi.ss.usermodel.Row)headerRow, (int)cellnum);
                ExcelUtils.setComment((CreationHelper)helper, (Cell)cell, (String)column.getRemarks());
            }
            ++cellnum;
        }
        ExcelUtils.writeWorkbook((Workbook)workbook, (File)file);
    }

    private List<File> getFiles() {
        List list = CommonUtils.list();
        this.findFiles(this.getDirectory(), list);
        return list;
    }

    private void findFiles(File file, List<File> list) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles(f -> true);
            if (children != null) {
                for (File child : children) {
                    if (child.isFile()) {
                        this.addFile(child, list);
                        continue;
                    }
                    if (!this.isRecursive()) continue;
                    this.findFiles(child, list);
                }
            }
        } else {
            this.addFile(file, list);
        }
    }

    private void addFile(File file, List<File> list) {
        if (!file.exists()) {
            return;
        }
        WorkbookFileType workbookFileType = WorkbookFileType.parse((File)file);
        if (workbookFileType != null && workbookFileType != this.getOutputFileType() && this.fileFilter.test(file)) {
            list.add(file);
        }
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public Predicate<File> getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(Predicate<File> fileFilter) {
        this.fileFilter = fileFilter;
    }

    public WorkbookFileType getOutputFileType() {
        return this.outputFileType;
    }

    public void setOutputFileType(WorkbookFileType outputFileType) {
        this.outputFileType = outputFileType;
    }

    protected Converters getConverters() {
        return this.converters;
    }

    protected void setConverters(Converters converters) {
        this.converters = converters;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public boolean isRemoveOriginalFile() {
        return this.removeOriginalFile;
    }

    public void setRemoveOriginalFile(boolean removeOriginalFile) {
        this.removeOriginalFile = removeOriginalFile;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public String getCsvEncoding() {
        return this.csvEncoding;
    }

    public void setCsvEncoding(String csvEncoding) {
        this.csvEncoding = csvEncoding;
    }

    public JsonConverter getJsonConverter() {
        return this.jsonConverter;
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }
}

