/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.util;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.resolver.PostgresDialectResolver;
import com.sqlapp.data.schemas.AbstractColumn;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.util.AbstractSqlBuilder;

public class PostgresSqlBuilder
extends AbstractSqlBuilder<PostgresSqlBuilder> {
    private static final long serialVersionUID = 1L;
    private PostgresDialectResolver.PostgresVersionResolver postgresVersionResolver = new PostgresDialectResolver.PostgresVersionResolver();
    private Dialect postgres92 = this.postgresVersionResolver.getDialect(9, 2, 0);

    public PostgresSqlBuilder(Dialect dialect) {
        super(dialect);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PostgresSqlBuilder typeDefinition(Column column) {
        if (!column.isIdentity() || !this.getDialect().supportsIdentity()) return (PostgresSqlBuilder)super.typeDefinition(column);
        if (column.getDataType() == DataType.SMALLINT && this.getDialect().compareTo(this.postgres92) >= 0) {
            this._add("smallserial");
            return this;
        } else if (column.getDataType() == DataType.INT) {
            this._add("serial");
            return this;
        } else if (column.getDataType() == DataType.BIGINT) {
            this._add("bigserial");
            return this;
        } else {
            if (column.getDataType() == null) {
                return (PostgresSqlBuilder)super.typeDefinition(column);
            }
            if (!column.getDataType().isNumeric()) return (PostgresSqlBuilder)super.typeDefinition(column);
            this._add("serial");
        }
        return this;
    }

    protected PostgresSqlBuilder notNullDefinitionForAlter(Column column) {
        if (column.isNotNull()) {
            ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)this.space()).set()).not())._null();
        }
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder search() {
        this.appendElement("SEARCH");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder path() {
        this.appendElement("PATH");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder operator() {
        this.appendElement("OPERATOR");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder _class() {
        this.operator().appendElement("CLASS");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder using() {
        this.appendElement("USING");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder gist() {
        this.appendElement("GIST");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder exclude() {
        this.appendElement("EXCLUDE");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder conflict() {
        this.appendElement("CONFLICT");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder immutable() {
        this.appendElement("IMMUTABLE");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder stable() {
        this.appendElement("STABLE");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder _volatile() {
        this.appendElement("VOLATILE");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder _do() {
        this.appendElement("DO");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder comment() {
        this.appendElement("COMMENT");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder fillfactor() {
        this.appendElement("FILLFACTOR");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder oids() {
        this.appendElement("OIDS");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder binding() {
        this.appendElement("BINDING");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder leftarg() {
        this.appendElement("LEFTARG");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder rightarg() {
        this.appendElement("RIGHTARG");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder commutator() {
        this.appendElement("COMMUTATOR");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder negator() {
        this.appendElement("NEGATOR");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder restrict() {
        this.appendElement("RESTRICT");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder hashes() {
        this.appendElement("HASHES");
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder merges() {
        this.appendElement("MERGES");
        return (PostgresSqlBuilder)this.instance();
    }

    protected PostgresSqlBuilder autoIncrement(AbstractColumn<?> column) {
        return (PostgresSqlBuilder)this.instance();
    }

    public PostgresSqlBuilder clone() {
        return (PostgresSqlBuilder)super.clone();
    }
}

