/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres;

import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.converter.IntervalDayConverter;
import com.sqlapp.data.converter.IntervalDayToHourConverter;
import com.sqlapp.data.converter.IntervalDayToMinuteConverter;
import com.sqlapp.data.converter.IntervalDayToSecondConverter;
import com.sqlapp.data.converter.IntervalHourConverter;
import com.sqlapp.data.converter.IntervalHourToMinuteConverter;
import com.sqlapp.data.converter.IntervalHourToSecondConverter;
import com.sqlapp.data.converter.IntervalMinuteConverter;
import com.sqlapp.data.converter.IntervalMinuteToSecondConverter;
import com.sqlapp.data.converter.IntervalMonthConverter;
import com.sqlapp.data.converter.IntervalSecondConverter;
import com.sqlapp.data.converter.IntervalYearConverter;
import com.sqlapp.data.converter.IntervalYearToMonthConverter;
import com.sqlapp.data.converter.PipeConverter;
import com.sqlapp.data.db.datatype.BigIntType;
import com.sqlapp.data.db.datatype.BinaryType;
import com.sqlapp.data.db.datatype.BlobType;
import com.sqlapp.data.db.datatype.BoxType;
import com.sqlapp.data.db.datatype.CircleType;
import com.sqlapp.data.db.datatype.DateType;
import com.sqlapp.data.db.datatype.DecimalType;
import com.sqlapp.data.db.datatype.DefaultJdbcTypeHandler;
import com.sqlapp.data.db.datatype.DoubleType;
import com.sqlapp.data.db.datatype.InetType;
import com.sqlapp.data.db.datatype.IntType;
import com.sqlapp.data.db.datatype.IntervalDayToHourType;
import com.sqlapp.data.db.datatype.IntervalDayToMinuteType;
import com.sqlapp.data.db.datatype.IntervalDayToSecondType;
import com.sqlapp.data.db.datatype.IntervalDayType;
import com.sqlapp.data.db.datatype.IntervalHourToMinuteType;
import com.sqlapp.data.db.datatype.IntervalHourToSecondType;
import com.sqlapp.data.db.datatype.IntervalHourType;
import com.sqlapp.data.db.datatype.IntervalMinuteToSecondType;
import com.sqlapp.data.db.datatype.IntervalMinuteType;
import com.sqlapp.data.db.datatype.IntervalMonthType;
import com.sqlapp.data.db.datatype.IntervalSecondType;
import com.sqlapp.data.db.datatype.IntervalYearToMonthType;
import com.sqlapp.data.db.datatype.IntervalYearType;
import com.sqlapp.data.db.datatype.JdbcTypeHandler;
import com.sqlapp.data.db.datatype.LineType;
import com.sqlapp.data.db.datatype.LsegType;
import com.sqlapp.data.db.datatype.MoneyType;
import com.sqlapp.data.db.datatype.NumericType;
import com.sqlapp.data.db.datatype.PathType;
import com.sqlapp.data.db.datatype.PointType;
import com.sqlapp.data.db.datatype.PolygonType;
import com.sqlapp.data.db.datatype.SmallDateTimeType;
import com.sqlapp.data.db.datatype.SmallIntType;
import com.sqlapp.data.db.datatype.TimeType;
import com.sqlapp.data.db.datatype.TimestampType;
import com.sqlapp.data.db.datatype.UUIDType;
import com.sqlapp.data.db.datatype.VarBinaryType;
import com.sqlapp.data.db.datatype.VarcharType;
import com.sqlapp.data.db.dialect.DefaultCase;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGBoxConverter;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGCircleConverter;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGIntervalConverter;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGLineConverter;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGLsegConverter;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGPathConverter;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGPointConverter;
import com.sqlapp.data.db.dialect.postgres.converter.FromPGPolygonConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGBoxConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGCircleConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGIntervalConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGLineConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGLsegConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGPathConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGPointConverter;
import com.sqlapp.data.db.dialect.postgres.converter.ToPGPolygonConverter;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresCatalogReader;
import com.sqlapp.data.db.dialect.postgres.sql.PostgresSqlFactoryRegistry;
import com.sqlapp.data.db.dialect.postgres.util.PostgresJdbcHandler;
import com.sqlapp.data.db.dialect.postgres.util.PostgresSqlBuilder;
import com.sqlapp.data.db.dialect.postgres.util.PostgresSqlSplitter;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.schemas.CascadeRule;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.JDBCType;
import java.util.function.Supplier;

public class Postgres
extends Dialect {
    private static final long serialVersionUID = -7843214207236066501L;

    protected Postgres(Supplier<Dialect> nextVersionDialectSupplier) {
        super(nextVersionDialectSupplier);
    }

    protected void registerDataType() {
        this.getDbDataTypes().addChar(32672L).setSupportsArray(true);
        this.getDbDataTypes().addVarchar(32672L);
        ((VarcharType)((VarcharType)((VarcharType)this.getDbDataTypes().addVarchar("TEXT", (long)CommonUtils.LEN_1GB).setFormats(new String[]{"TEXT\\s*"})).setCreateFormat("TEXT")).setFixedLength(true)).setDefaultLength((Number)CommonUtils.LEN_1GB);
        ((BlobType)this.getDbDataTypes().addBlob("BYTEA", (long)CommonUtils.LEN_1GB).setCreateFormat("BYTEA")).setLiteral("decode('", "', 'hex')");
        this.getDbDataTypes().addBoolean("BOOL").setSupportsArray(true);
        ((BinaryType)this.getDbDataTypes().addBinary("BIT", (long)CommonUtils.LEN_1GB).setLiteral("decode('", "', 'hex')")).setSupportsArray(true);
        ((VarBinaryType)this.getDbDataTypes().addVarBinary("VARBIT", (long)CommonUtils.LEN_1GB).setLiteral("decode('", "', 'hex')")).setSupportsArray(true);
        ((SmallIntType)this.getDbDataTypes().addSmallInt().addFormats(new String[]{"INT2"})).setSupportsArray(true);
        ((IntType)((IntType)this.getDbDataTypes().addInt().addFormats(new String[]{"INT4"})).addFormats(new String[]{"INTEGER"})).setSupportsArray(true);
        ((BigIntType)this.getDbDataTypes().addBigInt().addFormats(new String[]{"INT8"})).setSupportsArray(true);
        this.getDbDataTypes().addSerial("SERIAL");
        this.getDbDataTypes().addBigSerial("BIGSERIAL");
        ((DecimalType)this.getDbDataTypes().addNumeric().setMaxPrecision(Integer.valueOf(1000)).setMaxScale(Integer.valueOf(1000))).setSupportsArray(true);
        ((UUIDType)this.getDbDataTypes().addUUID("UUID").setLiteral("{", "}")).setSupportsArray(true);
        this.getDbDataTypes().addReal("FLOAT4").setSupportsArray(true);
        ((DoubleType)((DoubleType)this.getDbDataTypes().addDouble().addFormats(new String[]{"DOUBLE PRECISION"})).addFormats(new String[]{"FLOAT8"})).setSupportsArray(true);
        ((MoneyType)((MoneyType)((MoneyType)((MoneyType)this.getDbDataTypes().addMoney("MONEY").setLiteral("", "::text::money")).setSurrogateType(new NumericType().setMaxPrecision(Integer.valueOf(17)).setScale(2))).setFixedPrecision(false)).setFixedScale(false)).setSupportsArray(true);
        this.getDbDataTypes().addSqlXml("XML").setLiteral("XML '", "'");
        ((SmallDateTimeType)this.getDbDataTypes().addSmallDateTime("abstime").setDefaultValueLiteral(this.getCurrentDateFunction())).setSupportsArray(true);
        ((DateType)this.getDbDataTypes().addDate().setDefaultValueLiteral(this.getCurrentDateFunction())).setSupportsArray(true);
        ((TimeType)((TimeType)this.getDbDataTypes().addTime().setDefaultValueLiteral(this.getCurrentTimeFunction())).setSupportsArray(true)).setLiteral("TIME '", "'");
        ((TimeType)((TimeType)((TimeType)this.getDbDataTypes().addTimeWithTimeZone("TIMETZ").setDefaultPrecision(Integer.valueOf(6))).setDefaultValueLiteral(this.getCurrentTimeFunction())).setSupportsArray(true)).setLiteral("TIME WITH TIME ZONE '", "'");
        ((TimestampType)((TimestampType)this.getDbDataTypes().addTimestamp().setDefaultValueLiteral(this.getCurrentTimestampFunction())).setSupportsArray(true)).setLiteral("TIMESTAMP '", "'");
        ((TimestampType)((TimestampType)((TimestampType)this.getDbDataTypes().addTimestampWithTimeZoneType("TIMESTAMPTZ").setLiteral("TIMESTAMP WITH TIME ZONE '", "'")).setDefaultPrecision(Integer.valueOf(6))).setDefaultValueLiteral(this.getCurrentTimestampFunction())).setSupportsArray(true);
        this.getDbDataTypes().addInterval().setSupportsArray(true);
        ((IntervalYearType)((IntervalYearType)this.getDbDataTypes().addIntervalYear().setCreateFormat("INTERVAL YAER")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalYearConverter()))).setSupportsArray(true);
        ((IntervalMonthType)((IntervalMonthType)this.getDbDataTypes().addIntervalMonth().setCreateFormat("INTERVAL MONTH")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalMonthConverter()))).setSupportsArray(true);
        ((IntervalDayType)((IntervalDayType)this.getDbDataTypes().addIntervalDay().setCreateFormat("INTERVAL DAY")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalDayConverter()))).setSupportsArray(true);
        ((IntervalHourType)((IntervalHourType)this.getDbDataTypes().addIntervalHour().setCreateFormat("INTERVAL HOUR")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalHourConverter()))).setSupportsArray(true);
        ((IntervalMinuteType)((IntervalMinuteType)this.getDbDataTypes().addIntervalMinute().setCreateFormat("INTERVAL MINUTE")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalMinuteConverter()))).setSupportsArray(true);
        ((IntervalSecondType)((IntervalSecondType)this.getDbDataTypes().addIntervalSecond().setCreateFormat("INTERVAL SECOND")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalSecondConverter()))).setSupportsArray(true);
        ((IntervalYearToMonthType)((IntervalYearToMonthType)this.getDbDataTypes().addIntervalYearToMonth().setCreateFormat("INTERVAL YAER TO MONTH")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalYearToMonthConverter()))).setSupportsArray(true);
        ((IntervalDayToHourType)((IntervalDayToHourType)this.getDbDataTypes().addIntervalDayToHour().setCreateFormat("INTERVAL DAY TO HOUR")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalDayToHourConverter()))).setSupportsArray(true);
        ((IntervalDayToMinuteType)((IntervalDayToMinuteType)this.getDbDataTypes().addIntervalDayToMinute().setCreateFormat("INTERVAL DAY TO MINUTE")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalDayToMinuteConverter()))).setSupportsArray(true);
        ((IntervalDayToSecondType)((IntervalDayToSecondType)this.getDbDataTypes().addIntervalDayToSecond().setCreateFormat("INTERVAL DAY TO SECOND")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalDayToSecondConverter()))).setSupportsArray(true);
        ((IntervalHourToMinuteType)((IntervalHourToMinuteType)this.getDbDataTypes().addIntervalHourToMinute().setCreateFormat("INTERVAL HOUR TO MINUTE")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalHourToMinuteConverter()))).setSupportsArray(true);
        ((IntervalHourToSecondType)((IntervalHourToSecondType)this.getDbDataTypes().addIntervalHourToSecond().setCreateFormat("INTERVAL HOUR TO SECOND")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalHourToSecondConverter()))).setSupportsArray(true);
        ((IntervalMinuteToSecondType)((IntervalMinuteToSecondType)this.getDbDataTypes().addIntervalMinuteToSecond().setCreateFormat("INTERVAL MINUTE TO SECOND")).setJdbcTypeHandler(this.getIntervalConverter((Converter<?>)new IntervalMinuteToSecondConverter()))).setSupportsArray(true);
        ((InetType)((InetType)this.getDbDataTypes().addInetType().setLiteralPrefix("inet '")).setLiteralSuffix("'")).setSupportsArray(true);
        this.getDbDataTypes().addCidrType().setSupportsArray(true);
        this.getDbDataTypes().addMacAddrType().setSupportsArray(true);
        this.getDbDataTypes().addRowId("OID").setSupportsArray(true);
        ((PointType)this.getDbDataTypes().addPointType().setJdbcTypeHandler(this.getPointConverter())).setSupportsArray(true);
        ((CircleType)this.getDbDataTypes().addCircleType().setJdbcTypeHandler(this.getCircleConverter())).setSupportsArray(true);
        ((BoxType)this.getDbDataTypes().addBoxType().setJdbcTypeHandler(this.getBoxConverter())).setSupportsArray(true);
        ((LineType)this.getDbDataTypes().addLineType().setJdbcTypeHandler(this.getLineConverter())).setSupportsArray(true);
        ((LsegType)this.getDbDataTypes().addLsegType().setJdbcTypeHandler(this.getLsegConverter())).setSupportsArray(true);
        ((PathType)this.getDbDataTypes().addPathType().setJdbcTypeHandler(this.getPathConverter())).setSupportsArray(true);
        ((PolygonType)this.getDbDataTypes().addPolygonType().setJdbcTypeHandler(this.getPolygonConverter())).setSupportsArray(true);
    }

    private JdbcTypeHandler getIntervalConverter(Converter<?> resultSetConveter) {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new PipeConverter(new Converter[]{new FromPGIntervalConverter(), resultSetConveter}));
        converter.setStatementConverter((Converter)new ToPGIntervalConverter());
        return converter;
    }

    private JdbcTypeHandler getPointConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGPointConverter());
        converter.setStatementConverter((Converter)new ToPGPointConverter());
        return converter;
    }

    private JdbcTypeHandler getCircleConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGCircleConverter());
        converter.setStatementConverter((Converter)new ToPGCircleConverter());
        return converter;
    }

    private JdbcTypeHandler getBoxConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGBoxConverter());
        converter.setStatementConverter((Converter)new ToPGBoxConverter());
        return converter;
    }

    private JdbcTypeHandler getLsegConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGLsegConverter());
        converter.setStatementConverter((Converter)new ToPGLsegConverter());
        return converter;
    }

    private JdbcTypeHandler getLineConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGLineConverter());
        converter.setStatementConverter((Converter)new ToPGLineConverter());
        return converter;
    }

    private JdbcTypeHandler getPathConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGPathConverter());
        converter.setStatementConverter((Converter)new ToPGPathConverter());
        return converter;
    }

    private JdbcTypeHandler getPolygonConverter() {
        DefaultJdbcTypeHandler converter = new DefaultJdbcTypeHandler(JDBCType.OTHER);
        converter.setResultSetconverter((Converter)new FromPGPolygonConverter());
        converter.setStatementConverter((Converter)new ToPGPolygonConverter());
        return converter;
    }

    public String getProductName() {
        return "PostgreSQL";
    }

    public String getSimpleName() {
        return "postgres";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select nextval ('" + sequenceName + "')";
    }

    public String getIdentitySelectString() {
        return "select lastval()";
    }

    public boolean supportsIdentity() {
        return true;
    }

    public boolean supportsSequence() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public boolean supportsDropCascade() {
        return true;
    }

    public boolean supportsColumnSequence() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public boolean supportsRuleOnDelete(CascadeRule rule) {
        return true;
    }

    public boolean supportsCascadeUpdate() {
        return true;
    }

    public boolean supportsRuleOnUpdate(CascadeRule rule) {
        return true;
    }

    public boolean supportsCascadeRistrict() {
        return true;
    }

    public boolean supportsDefaultValueFunction() {
        return true;
    }

    public boolean supportsFunctionOverload() {
        return true;
    }

    public boolean supportsProcedureOverload() {
        return true;
    }

    public int hashCode() {
        return this.getProductName().hashCode();
    }

    public DefaultCase getDefaultCase() {
        return DefaultCase.LowerCase;
    }

    public String nativeCaseString(String value) {
        if (CommonUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (this.isQuoted(value)) {
            return value;
        }
        return value.toLowerCase();
    }

    public String selectRecursiveSql(Table table, boolean backTrace) {
        return null;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public CatalogReader getCatalogReader() {
        return new PostgresCatalogReader(this);
    }

    public SqlFactoryRegistry createSqlFactoryRegistry() {
        return new PostgresSqlFactoryRegistry(this);
    }

    public boolean supportsCatalog() {
        return true;
    }

    public PostgresSqlBuilder createSqlBuilder() {
        return new PostgresSqlBuilder(this);
    }

    public PostgresSqlSplitter createSqlSplitter() {
        return new PostgresSqlSplitter(this);
    }

    protected String doQuote(String target) {
        StringBuilder builder = new StringBuilder(target.length() + 2);
        builder.append(this.getOpenQuote()).append(target.replace("\"", "\"\"")).append(this.getCloseQuote());
        return builder.toString();
    }

    public PostgresJdbcHandler createJdbcHandler(SqlNode sqlNode) {
        PostgresJdbcHandler jdbcHandler = new PostgresJdbcHandler(sqlNode);
        return jdbcHandler;
    }

    public boolean isDdlRollbackable() {
        return true;
    }
}

