/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.converter;

import com.sqlapp.data.db.dialect.postgres.converter.AbstractFromObjectConverter;
import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.CommonUtils;
import java.sql.SQLException;
import org.postgresql.util.PGInterval;

public class FromPGIntervalConverter
extends AbstractFromObjectConverter<Interval, PGInterval> {
    private static final long serialVersionUID = 6488632910509733050L;

    @Override
    public Interval copy(Object obj) {
        if (obj == null) {
            return null;
        }
        return ((Interval)this.convertObject(obj)).clone();
    }

    @Override
    protected boolean isTargetInstanceof(Object value) {
        return value instanceof Interval;
    }

    @Override
    protected boolean isInstanceof(Object value) {
        return value instanceof PGInterval;
    }

    @Override
    protected Interval toObjectFromString(String value) {
        String val = value;
        if (Interval.isParsable((String)val)) {
            return Interval.parse((String)val);
        }
        try {
            PGInterval pgObject = new PGInterval(val);
            return this.toObject(pgObject);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Interval toObject(PGInterval value) {
        int years = value.getYears();
        int months = value.getMonths();
        int days = value.getDays();
        int hours = value.getHours();
        int minutes = value.getMinutes();
        double seconds = value.getSeconds();
        Interval interval = new Interval(CommonUtils.abs((int)years), CommonUtils.abs((int)months), CommonUtils.abs((int)days), CommonUtils.abs((int)hours), CommonUtils.abs((int)minutes), CommonUtils.abs((double)seconds));
        int notZeroInt = CommonUtils.notZero((Integer[])new Integer[]{years, months, days, hours, minutes});
        if (notZeroInt < 0) {
            interval.scale(-1);
        } else if (seconds < 0.0) {
            interval.scale(-1);
        }
        return interval;
    }

    @Override
    protected Interval clone(Interval value) {
        return value.clone();
    }

    @Override
    protected Class<PGInterval> getObjectClass() {
        return PGInterval.class;
    }
}

