/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.resolver;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectUtils;
import com.sqlapp.data.db.dialect.postgres.Postgres;
import com.sqlapp.data.db.dialect.postgres.Postgres100;
import com.sqlapp.data.db.dialect.postgres.Postgres110;
import com.sqlapp.data.db.dialect.postgres.Postgres120;
import com.sqlapp.data.db.dialect.postgres.Postgres130;
import com.sqlapp.data.db.dialect.postgres.Postgres140;
import com.sqlapp.data.db.dialect.postgres.Postgres83;
import com.sqlapp.data.db.dialect.postgres.Postgres84;
import com.sqlapp.data.db.dialect.postgres.Postgres90;
import com.sqlapp.data.db.dialect.postgres.Postgres91;
import com.sqlapp.data.db.dialect.postgres.Postgres92;
import com.sqlapp.data.db.dialect.postgres.Postgres93;
import com.sqlapp.data.db.dialect.postgres.Postgres94;
import com.sqlapp.data.db.dialect.postgres.Postgres95;
import com.sqlapp.data.db.dialect.postgres.Postgres96;
import com.sqlapp.data.db.dialect.resolver.ProductNameDialectResolver;
import com.sqlapp.data.db.dialect.resolver.VersionResolver;

public class PostgresDialectResolver
extends ProductNameDialectResolver {
    private static final long serialVersionUID = 1L;
    public static final PostgresDialectResolver instance = new PostgresDialectResolver();

    public PostgresDialectResolver() {
        super("Postgres.*", (VersionResolver)new PostgresVersionResolver());
    }

    public static PostgresDialectResolver getInstance() {
        return instance;
    }

    public static class PostgresVersionResolver
    implements VersionResolver {
        private static final long serialVersionUID = 1L;

        public Dialect getDialect(int majorVersion, int minorVersion, Integer revision) {
            if (majorVersion >= 14) {
                return DialectHolder.postgreSQL140;
            }
            if (majorVersion >= 13) {
                return DialectHolder.postgreSQL130;
            }
            if (majorVersion >= 12) {
                return DialectHolder.postgreSQL120;
            }
            if (majorVersion >= 11) {
                return DialectHolder.postgreSQL110;
            }
            if (majorVersion >= 10) {
                return DialectHolder.postgreSQL100;
            }
            if (majorVersion >= 9) {
                switch (minorVersion) {
                    case 0: {
                        return DialectHolder.postgreSQL90;
                    }
                    case 1: {
                        return DialectHolder.postgreSQL91;
                    }
                    case 2: {
                        return DialectHolder.postgreSQL92;
                    }
                    case 3: {
                        return DialectHolder.postgreSQL93;
                    }
                    case 4: {
                        return DialectHolder.postgreSQL94;
                    }
                    case 5: {
                        return DialectHolder.postgreSQL95;
                    }
                    case 6: {
                        return DialectHolder.postgreSQL96;
                    }
                }
                return DialectHolder.postgreSQL90;
            }
            if (majorVersion >= 8) {
                switch (minorVersion) {
                    case 0: {
                        return DialectHolder.defaultDialect;
                    }
                    case 1: {
                        return DialectHolder.defaultDialect;
                    }
                    case 2: {
                        return DialectHolder.postgreSQL82;
                    }
                    case 3: {
                        return DialectHolder.postgreSQL83;
                    }
                    case 4: {
                        return DialectHolder.postgreSQL84;
                    }
                }
                return DialectHolder.defaultDialect;
            }
            return DialectHolder.defaultDialect;
        }

        public static class DialectHolder {
            static final Dialect postgreSQL140 = DialectUtils.getInstance(Postgres140.class);
            static final Dialect postgreSQL130 = DialectUtils.getInstance(Postgres130.class, () -> postgreSQL140);
            static final Dialect postgreSQL120 = DialectUtils.getInstance(Postgres120.class, () -> postgreSQL130);
            static final Dialect postgreSQL110 = DialectUtils.getInstance(Postgres110.class, () -> postgreSQL120);
            static final Dialect postgreSQL100 = DialectUtils.getInstance(Postgres100.class, () -> postgreSQL110);
            static final Dialect postgreSQL96 = DialectUtils.getInstance(Postgres96.class, () -> postgreSQL100);
            static final Dialect postgreSQL95 = DialectUtils.getInstance(Postgres95.class, () -> postgreSQL96);
            static final Dialect postgreSQL94 = DialectUtils.getInstance(Postgres94.class, () -> postgreSQL95);
            static final Dialect postgreSQL93 = DialectUtils.getInstance(Postgres93.class, () -> postgreSQL94);
            static final Dialect postgreSQL92 = DialectUtils.getInstance(Postgres92.class, () -> postgreSQL93);
            static final Dialect postgreSQL91 = DialectUtils.getInstance(Postgres91.class, () -> postgreSQL92);
            static final Dialect postgreSQL90 = DialectUtils.getInstance(Postgres90.class, () -> postgreSQL91);
            static final Dialect postgreSQL84 = DialectUtils.getInstance(Postgres84.class, () -> postgreSQL90);
            static final Dialect postgreSQL83 = DialectUtils.getInstance(Postgres83.class, () -> postgreSQL84);
            static final Dialect postgreSQL82 = DialectUtils.getInstance(Postgres83.class, () -> postgreSQL83);
            static final Dialect defaultDialect = DialectUtils.getInstance(Postgres.class, () -> postgreSQL82);
        }
    }
}

