/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.util;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.Postgres;
import com.sqlapp.data.db.dialect.postgres.resolver.PostgresDialectResolver;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EnumUtils;
import com.sqlapp.util.OnOffAutoType;
import com.sqlapp.util.OnOffType;
import java.sql.SQLException;
import java.util.function.Consumer;
import java.util.function.Supplier;

public enum PostgresIndexOptions {
    FILLFACTOR{

        @Override
        public void setIndex(Index index, Object value) {
            Integer val = (Integer)Converters.getDefault().convertObject(value, Integer.class);
            if (val == null) {
                index.getSpecifics().remove((Object)this.getColumnKey());
                index.getSpecifics().remove((Object)this.toString());
            } else if (val >= 0 && val <= 100) {
                index.getSpecifics().remove((Object)this.getColumnKey());
                index.getSpecifics().remove((Object)this.toString());
                if (val != 0) {
                    index.getSpecifics().put(this.toString(), (Object)val);
                }
            }
        }

        @Override
        public String getColumnKey() {
            return "FILLFACTOR";
        }
    }
    ,
    BUFFERING{

        public OnOffAutoType getDefaultValue() {
            return OnOffAutoType.AUTO;
        }

        @Override
        public Class<?> getValueClass() {
            return OnOffAutoType.class;
        }

        @Override
        public void setIndex(Index index, Object value) {
            this.setIndexOnOffAutoParams(index, value);
        }

        @Override
        public void setIndex(ExResultSet rs, Index index) throws SQLException {
            this.setOnOffAutoParams(rs, (SpecificsProperty<?>)index);
        }
    }
    ,
    FASTUPDATE{

        public OnOffType getDefaultValue() {
            return OnOffType.ON;
        }

        @Override
        public Class<?> getValueClass() {
            return OnOffType.class;
        }

        @Override
        public void setIndex(Index index, Object value) {
            this.setIndexOnOffParams(index, value);
        }

        @Override
        public void setIndex(ExResultSet rs, Index index) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)index);
        }

        @Override
        public void setUniqueConstraint(ExResultSet rs, UniqueConstraint uc) throws SQLException {
            this.setOnOffParams(rs, (SpecificsProperty<?>)uc);
        }
    }
    ,
    GIN_PENDING_LIST_LIMIT{}
    ,
    PAGE_PER_RANGE{}
    ,
    AUTOSUMMARISE{};


    public Class<?> getValueClass() {
        return null;
    }

    public Object getDefaultValue() {
        return null;
    }

    public void setIndex(Index index, Object value) {
    }

    public void setTable(Table table, String value) {
    }

    public void setTable(ExResultSet rs, Table table) throws SQLException {
        this.setParams(rs, val -> {
            if (val != null) {
                this.setTable(table, val.toString());
            } else {
                this.setTable(table, null);
            }
        });
    }

    public void setIndex(ExResultSet rs, Index index) throws SQLException {
        this.setParams(rs, val -> {
            if (val != null) {
                this.setIndex(index, val);
            } else {
                this.setIndex(index, null);
            }
        });
    }

    public static void setAllIndex(ExResultSet rs, Index index) throws SQLException {
        for (PostgresIndexOptions enm : PostgresIndexOptions.values()) {
            enm.setIndex(rs, index);
        }
    }

    public String getColumnKey() {
        return this.toString();
    }

    public void setUniqueConstraint(ExResultSet rs, UniqueConstraint uk) throws SQLException {
    }

    public static void setAllUniqueConstraint(ExResultSet rs, UniqueConstraint uk) throws SQLException {
        for (PostgresIndexOptions enm : PostgresIndexOptions.values()) {
            enm.setUniqueConstraint(rs, uk);
        }
    }

    protected void setIndexOnOffParams(Index index, Object value) {
        OnOffType enm = OnOffType.parse((Object)value);
        index.getSpecifics().put(this.toString(), (Object)enm);
    }

    protected void setIndexOnOffAutoParams(Index index, Object value) {
        OnOffAutoType enm = OnOffAutoType.parse((Object)value);
        index.getSpecifics().put(this.toString(), (Object)enm);
    }

    protected void setParams(ExResultSet rs, Consumer<Object> cons) throws SQLException {
        if (!rs.contains(this.getColumnKey())) {
            return;
        }
        Object val = rs.getObject(this.getColumnKey());
        cons.accept(val);
    }

    public boolean supports(Postgres dialect) {
        Dialect target = this.getSupportVersion().get();
        return dialect.compareTo(target) >= 0;
    }

    public Supplier<Dialect> getSupportVersion() {
        return () -> PostgresDialectResolver.getInstance().getDialect(10, 0);
    }

    protected void setOnOffParams(ExResultSet rs, SpecificsProperty<?> obj) throws SQLException {
        if (!rs.contains(this.toString())) {
            return;
        }
        boolean bool = rs.getBoolean(this.getColumnKey());
        OnOffType enm = OnOffType.parse((Object)bool);
        obj.getSpecifics().put(this.toString(), (Object)enm);
    }

    protected void setOnOffAutoParams(ExResultSet rs, SpecificsProperty<?> obj) throws SQLException {
        if (!rs.contains(this.toString())) {
            return;
        }
        boolean bool = rs.getBoolean(this.getColumnKey());
        OnOffAutoType enm = OnOffAutoType.parse((Object)bool);
        obj.getSpecifics().put(this.toString(), (Object)enm);
    }

    public static PostgresIndexOptions parse(Object obj) {
        PostgresIndexOptions enm = (PostgresIndexOptions)EnumUtils.parse(PostgresIndexOptions.class, (Object)obj);
        if (enm != null) {
            return enm;
        }
        if (obj instanceof String) {
            String val = ((String)String.class.cast(obj)).toUpperCase().replace("_", "");
            for (PostgresIndexOptions e : PostgresIndexOptions.values()) {
                if (!CommonUtils.eq((Object)val, (Object)e.toString().replace("_", ""))) continue;
                return e;
            }
        }
        return null;
    }

    public boolean isOnOff() {
        return this.getValueClass() == OnOffType.class;
    }
}

