/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.util;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.util.SqlSplitter;
import com.sqlapp.data.db.dialect.util.SqlTokenizer;
import com.sqlapp.data.db.dialect.util.StringHolder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostgresSqlSplitter
extends SqlSplitter {
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("\\s*CREATE\\s+(OR\\s+REPLACE\\s+)?FUNCTION.*?\\s+AS\\s+(.*)", 42);

    public PostgresSqlSplitter(Dialect dialect) {
        super(dialect);
    }

    protected SqlTokenizer createSqlTokenizer(String input) {
        return new SqlTokenizer(input){

            protected boolean isStartStatement(String text, StringHolder stringHolder) {
                Matcher matcher = stringHolder.substringMatcher(FUNCTION_PATTERN);
                if (matcher.matches()) {
                    int index = stringHolder.indexOf("FUNCTION");
                    int asPos = stringHolder.searchWord("AS", index + 8);
                    if (asPos >= 0) {
                        int i = asPos + 2;
                        char c = ' ';
                        while (i < stringHolder.getContextLength() && stringHolder.isSpace(c = (char)stringHolder.charAt(i++))) {
                        }
                        if (c == '\'') {
                            SqlTokenizer.TextMarker textMarker = this.getTextMarker(i);
                            int pos = stringHolder.indexOf(this.getCurrentDelimiter(), textMarker.getEnd());
                            if (pos >= 0) {
                                pos = stringHolder.indexOf(this.getCurrentDelimiter(), pos);
                                this.setPosition(pos);
                                return true;
                            }
                            stringHolder.throwInvalidTextException("[Delimiter[" + this.getCurrentDelimiter() + "] of Function not found.[" + stringHolder.substringAt() + "]");
                            return true;
                        }
                        StringBuilder builder = new StringBuilder();
                        builder.append(c);
                        while (i < stringHolder.getContextLength() && !stringHolder.isSpace(c = stringHolder.charAt(i++))) {
                            builder.append(c);
                        }
                        int pos = stringHolder.indexOf(builder.toString(), i);
                        if (pos >= 0) {
                            pos = stringHolder.indexOf(this.getCurrentDelimiter(), pos + builder.length());
                            this.setPosition(pos);
                            return true;
                        }
                        stringHolder.throwInvalidTextException("[Delimiter[" + builder.toString() + "] of Function not found.[" + stringHolder.substringAt() + "]");
                    } else {
                        stringHolder.throwInvalidTextException("[AS] of Function not found.[" + stringHolder.substringAt() + "]");
                    }
                }
                return false;
            }
        };
    }
}

