/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.RoleMemberReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.RoleMember;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class PostgresRoleMemberReader
extends RoleMemberReader {
    protected PostgresRoleMemberReader(Dialect dialect) {
        super(dialect);
    }

    protected List<RoleMember> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                RoleMember obj = PostgresRoleMemberReader.this.createRoleMember(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("roleMember.sql");
    }

    protected RoleMember createRoleMember(ExResultSet rs) throws SQLException {
        RoleMember obj = new RoleMember();
        obj.setMemberRoleName(this.getString((ResultSet)rs, "role_name"));
        obj.setGranteeName(this.getString((ResultSet)rs, "grantee"));
        this.setSpecifics(rs, "grantor", (SpecificsProperty)obj);
        return obj;
    }
}

