/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.sql;

import com.sqlapp.data.db.dialect.postgres.util.PostgresSqlBuilder;
import com.sqlapp.data.db.sql.AbstractMergeByPkTableFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.data.schemas.properties.FormulaProperty;
import com.sqlapp.util.CommonUtils;
import java.util.List;

public class Postgres150MergeByPkTableFactory
extends AbstractMergeByPkTableFactory<PostgresSqlBuilder> {
    public List<SqlOperation> createSql(Table table) {
        UniqueConstraint constraint = this.getUniqueConstraint(table);
        if (constraint == null) {
            return super.createSql(table);
        }
        List sqlList = CommonUtils.list();
        String targetTable = (String)this.getOptions().getTableOptions().getTemporaryAlias().apply((Object)table);
        PostgresSqlBuilder builder = (PostgresSqlBuilder)this.createSqlBuilder();
        ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.merge()).space()).name((AbstractSchemaObject)table, this.getOptions().isDecorateSchemaName());
        builder.lineBreak();
        boolean[] first = new boolean[]{true};
        builder.using();
        ((PostgresSqlBuilder)builder.lineBreak()).brackets(() -> {
            builder.indent(() -> {
                builder.lineBreak();
                ((PostgresSqlBuilder)builder.select()).space();
                for (Column column : table.getColumns()) {
                    String def;
                    if (this.isFormulaColumn((FormulaProperty)column)) continue;
                    if (this.isAutoIncrementColumn(column)) {
                        def = this.getValueDefinitionSimple(column);
                        builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                            builder.lineBreak();
                            ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.comma(!first[0]))._add(def)).as()).name(column);
                            first[0] = false;
                            this.addSelectColumnComment(column, builder);
                        });
                        continue;
                    }
                    def = this.getValueDefinitionForInsert(column);
                    builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                        builder.lineBreak();
                        ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.comma(!first[0]))._add(def)).as()).name(column);
                        first[0] = false;
                        this.addSelectColumnComment(column, builder);
                    });
                }
            });
            builder.lineBreak();
        });
        ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.as()).space())._add(targetTable);
        builder.lineBreak();
        builder.on();
        builder.lineBreak();
        builder.brackets(() -> {
            builder.indent(() -> {
                first[0] = true;
                for (Column column : table.getColumns()) {
                    if (!constraint.getColumns().contains(column.getName())) continue;
                    builder.lineBreak();
                    ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.and(!first[0])).columnName(column, true)).eq()).names(new String[]{targetTable, column.getName()});
                    this.addSelectColumnComment(column, builder);
                    first[0] = false;
                }
            });
            builder.lineBreak();
        });
        builder.lineBreak();
        ((PostgresSqlBuilder)((PostgresSqlBuilder)builder.when()).matched()).then();
        builder.indent(() -> {
            builder.lineBreak();
            ((PostgresSqlBuilder)builder.update()).set();
            first[0] = true;
            builder.indent(() -> {
                for (Column column : table.getColumns()) {
                    if (constraint.getColumns().contains(column.getName()) || !this.isUpdateable(column) || this.isFormulaColumn((FormulaProperty)column)) continue;
                    String def = this.getValueDefinitionForUpdate(column);
                    ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.lineBreak()).comma(!first[0])).name(column)).eq();
                    if (this.isOptimisticLockColumn(column)) {
                        builder._add(def);
                    } else if (this.withCoalesceAtUpdate(column)) {
                        builder.coalesce(() -> {
                            ((PostgresSqlBuilder)builder.names(new String[]{column.getName()})).comma();
                            ((PostgresSqlBuilder)builder.names(new String[]{targetTable, column.getName()})).space();
                        });
                    } else {
                        builder.names(new String[]{targetTable, column.getName()});
                    }
                    this.addUpdateColumnComment(column, builder);
                    first[0] = false;
                }
            });
        });
        builder.lineBreak();
        ((PostgresSqlBuilder)((PostgresSqlBuilder)((PostgresSqlBuilder)builder.when()).not()).matched()).then();
        builder.indent(() -> {
            List insertableColumns = CommonUtils.list();
            builder.lineBreak();
            builder.insert();
            builder.lineBreak();
            builder.brackets(() -> {
                first[0] = true;
                builder.indent(() -> {
                    for (Column column : table.getColumns()) {
                        if (!this.isInsertable(column)) continue;
                        String def = this.getValueDefinitionForInsert(column);
                        builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                            if (!this.isFormulaColumn((FormulaProperty)column)) {
                                builder.lineBreak();
                                ((PostgresSqlBuilder)builder.comma(!first[0])).name(column);
                                insertableColumns.add(column);
                                first[0] = false;
                                this.addInsertColumnComment(column, builder);
                            }
                        });
                    }
                });
                builder.lineBreak();
            });
            ((PostgresSqlBuilder)builder.lineBreak()).values();
            builder.lineBreak();
            builder.brackets(() -> {
                first[0] = true;
                builder.indent(() -> {
                    for (Column column : insertableColumns) {
                        builder.lineBreak();
                        String def = this.getValueDefinitionForInsert(column);
                        builder.$if(!CommonUtils.isEmpty((CharSequence)def), () -> {
                            if (!this.isFormulaColumn((FormulaProperty)column)) {
                                ((PostgresSqlBuilder)builder.comma(!first[0])).names(new String[]{targetTable, column.getName()});
                                first[0] = false;
                            }
                        });
                    }
                });
                builder.lineBreak();
            });
        });
        builder.lineBreak();
        this.addSql(sqlList, builder, SqlType.MERGE_BY_PK, (DbCommonObject)table);
        return sqlList;
    }
}

