/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.postgres.metadata.PostgresUtils;
import com.sqlapp.data.db.metadata.FunctionFamilyReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.FunctionFamily;
import com.sqlapp.data.schemas.NamedArgument;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.QuadKeyMap;
import com.sqlapp.util.SeparatedStringBuilder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class Postgres83FunctionFamilyReader
extends FunctionFamilyReader {
    protected Postgres83FunctionFamilyReader(Dialect dialect) {
        super(dialect);
    }

    protected List<FunctionFamily> doGetAll(final Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        final QuadKeyMap map = CommonUtils.quadKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                FunctionFamily obj = Postgres83FunctionFamilyReader.this.createFunctionFamily(connection, rs);
                FunctionFamily obj1 = (FunctionFamily)map.get((Object)obj.getFunctionName(), (Object)obj.getSchemaName(), (Object)obj.getOperatorClassName(), (Object)obj.getFunctionName());
                if (obj1 == null) {
                    obj = Postgres83FunctionFamilyReader.this.createFunctionFamily(connection, rs);
                    map.put((Object)obj.getFunctionName(), (Object)obj.getSchemaName(), (Object)obj.getOperatorClassName(), (Object)obj.getFunctionName(), (Object)obj);
                    result.add(obj);
                }
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("functionFamilies83.sql");
    }

    protected FunctionFamily createFunctionFamily(Connection connection, ExResultSet rs) throws SQLException {
        String allArgTypes;
        FunctionFamily obj = new FunctionFamily();
        obj.setDialect(this.getDialect());
        obj.setOperatorClassName(this.getString((ResultSet)rs, "operator_class_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setSupportNumber(rs.getInt("amprocnum"));
        Function function = new Function(this.getString((ResultSet)rs, "function_name"));
        function.setSchemaName(this.getString((ResultSet)rs, "function_schema"));
        int argNo = rs.getInt("pronargs");
        if (argNo > 0 && (allArgTypes = CommonUtils.unwrap((String)rs.getString("proargtypes"), (String)"{", (String)"}")) != null) {
            String[] argArray = CommonUtils.split((String)allArgTypes, (String)"[, ]");
            SeparatedStringBuilder builder = new SeparatedStringBuilder(",");
            List<NamedArgument> arguments = PostgresUtils.getTypeInfoById(connection, this.getDialect(), argArray);
            for (NamedArgument argument : arguments) {
                builder.add((Object)argument.getDataTypeName());
            }
            function.setSpecificName(function.getName() + "(" + builder.toString() + ")");
        }
        obj.setFunction(function);
        return obj;
    }
}

