/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.IndexType;
import com.sqlapp.data.schemas.Order;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostgresIndexReader
extends IndexReader {
    private static final Pattern indexPattern = Pattern.compile("create\\s+.*index.*\\s+on\\s+.*\\((.*)\\).*", 10);
    private static final Pattern indexWherePattern = Pattern.compile("create\\s+.*index.*\\s+on\\s+.*\\((.*)\\).*\\s+where\\s+(.*)", 10);

    public PostgresIndexReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Index> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        final TripleKeyMap map = CommonUtils.tripleKeyMap();
        final Map columnsMap = CommonUtils.map();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                int pos;
                String schema_name = this.getString(rs, "schema_name");
                String index_name = this.getString(rs, "index_name");
                String table_name = this.getString(rs, "table_name");
                Index index = (Index)map.get((Object)schema_name, (Object)table_name, (Object)index_name);
                if (index == null) {
                    Matcher matcher;
                    columnsMap.clear();
                    index = new Index(index_name);
                    index.setTableName(table_name);
                    index.setSchemaName(schema_name);
                    boolean isUnique = rs.getBoolean("is_unique");
                    String type = this.getString(rs, "index_type");
                    String remarks = this.getString(rs, "remarks");
                    String indexprs = this.getString(rs, "indexprs");
                    String definition = this.getString(rs, "definition");
                    IndexType indexType = null;
                    indexType = !CommonUtils.isEmpty((CharSequence)indexprs) ? IndexType.Function : IndexType.parse((String)type);
                    if (indexType != null) {
                        index.setIndexType(indexType);
                    }
                    if ((matcher = indexWherePattern.matcher(definition)).matches()) {
                        columnsMap.put(index.getName(), matcher.group(1));
                        String condition = matcher.group(2);
                        index.setWhere(CommonUtils.unwrap((String)condition, (char)'(', (char)')'));
                    } else {
                        matcher = indexPattern.matcher(definition);
                        if (matcher.matches()) {
                            columnsMap.put(index.getName(), matcher.group(1));
                        }
                    }
                    index.setUnique(isUnique);
                    index.setRemarks(remarks);
                    map.put((Object)schema_name, (Object)table_name, (Object)index_name, (Object)index);
                    result.add(index);
                }
                String columnName = this.getString(rs, "column_name");
                String columns = (String)columnsMap.get(index.getName());
                String sub = CommonUtils.trim((String)columns.substring(pos = CommonUtils.min((int)(columnName.length() + columns.indexOf(columnName)), (int)columns.length())).toUpperCase());
                if (sub.startsWith("DESC")) {
                    index.getColumns().add(columnName, Order.Desc);
                } else {
                    index.getColumns().add(columnName, Order.Asc);
                }
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("indexes.sql");
    }
}

