/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.SequenceReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Sequence;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.SqlParser;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class PostgresSequenceReader
extends SequenceReader {
    protected PostgresSequenceReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Sequence> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final Dialect dbDialact = this.getDialect();
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Sequence sequence = new Sequence(this.getString(rs, "sequence_name"));
                sequence.setCatalogName(this.getString(rs, "SEQUENCE_CATALOG"));
                sequence.setSchemaName(this.getString(rs, "SEQUENCE_SCHEMA"));
                sequence.setDialect(dbDialact);
                result.add(sequence);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("sequences.sql");
    }

    protected void setMetadataDetail(Connection connection, final Sequence sequence) throws SQLException {
        StringBuilder tableName = new StringBuilder(64);
        if (!CommonUtils.isEmpty((CharSequence)sequence.getSchemaName())) {
            if (!CommonUtils.isEmpty((CharSequence)sequence.getCatalogName())) {
                tableName.append(sequence.getCatalogName());
                tableName.append(".");
                tableName.append(sequence.getSchemaName());
                tableName.append(".");
            } else if (!"public".equalsIgnoreCase(sequence.getSchemaName())) {
                tableName.append(sequence.getSchemaName());
                tableName.append(".");
            }
        }
        tableName.append(sequence.getName());
        StringBuilder sql = new StringBuilder("SELECT * ");
        sql.append("FROM " + tableName.toString());
        SqlNode node = SqlParser.getInstance().parse(sql.toString());
        ParametersContext context = this.newParametersContext(connection, null, null);
        final Dialect dialact = this.getDialect();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                sequence.setMinValue((Number)rs.getBigDecimal("min_value"));
                sequence.setMaxValue((Number)rs.getBigDecimal("max_value"));
                sequence.setStartValue((Number)rs.getBigDecimal("start_value"));
                sequence.setLastValue((Number)rs.getBigDecimal("last_value"));
                sequence.setIncrementBy((Number)rs.getBigDecimal("increment_by"));
                sequence.setCacheSize((Number)rs.getBigDecimal("cache_value"));
                sequence.setCycle("t".equalsIgnoreCase(this.getString(rs, "is_cycled")));
                sequence.setDialect(dialact);
            }
        });
    }
}

