/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.XmlSchemaReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.XmlSchema;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005XmlSchemaReader
extends XmlSchemaReader {
    protected SqlServer2005XmlSchemaReader(Dialect dialect) {
        super(dialect);
    }

    protected List<XmlSchema> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                XmlSchema obj = SqlServer2005XmlSchemaReader.this.createXmlSchema(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("xmlSchemas2005.sql");
    }

    protected XmlSchema createXmlSchema(ExResultSet rs) throws SQLException {
        XmlSchema obj = new XmlSchema(this.getString((ResultSet)rs, "xml_schema_name"));
        obj.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setDefinition(CommonUtils.splitLine((String)this.getString((ResultSet)rs, "TEXT")));
        obj.setId("" + rs.getInt("xml_collection_id"));
        return obj;
    }
}

