/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.util;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.resolver.SqlServerDialectResolver;
import com.sqlapp.data.schemas.AbstractColumn;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.NamedArgument;
import com.sqlapp.data.schemas.NamedArgumentCollection;
import com.sqlapp.data.schemas.Procedure;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;

public class SqlServerSqlBuilder
extends AbstractSqlBuilder<SqlServerSqlBuilder> {
    private static final long serialVersionUID = -3976029895381266407L;
    private final Dialect sqlserver2016 = SqlServerDialectResolver.getInstance().getDialect(13, 0);

    public SqlServerSqlBuilder(Dialect dialect) {
        super(dialect);
    }

    public SqlServerSqlBuilder identity() {
        this.appendElement("IDENTITY");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder include() {
        this.appendElement("INCLUDE");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder identityInsert() {
        this.appendElement("IDENTITY_INSERT");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder permissionSet() {
        this.appendElement("PERMISSION_SET");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder aggregate() {
        this.appendElement("AGGREGATE");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder readonly() {
        this.appendElement("READONLY");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder scheme() {
        this.appendElement("SCHEME");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder range() {
        this.appendElement("RANGE");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder enable() {
        this.appendElement("ENABLE");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder owner() {
        this.appendElement("OWNER");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder caller() {
        this.appendElement("CALLER");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder page() {
        this.appendElement("PAGE");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder columnstore() {
        this.appendElement("COLUMNSTORE");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder columnstoreArchive() {
        this.appendElement("COLUMNSTORE_ARCHIVE");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder disable() {
        this.appendElement("DISABLE");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder changeTracking() {
        this.appendElement("CHANGE_TRACKING");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder tablock() {
        this.appendElement("TABLOCK");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder holdlock() {
        this.appendElement("HOLDLOCK");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder updlock() {
        this.appendElement("UPDLOCK");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder filetable() {
        this.appendElement("FILETABLE");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder filetableDirectory() {
        this.appendElement("FILETABLE_DIRECTORY");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder filetableCollateFilename() {
        this.appendElement("FILETABLE_COLLATE_FILENAME");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder filetableStreamidUniqueConstraintName() {
        this.appendElement("FILETABLE_STREAMID_UNIQUE_CONSTRAINT_NAME");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder filetableFullpathUniqueConstraintName() {
        this.appendElement("FILETABLE_FULLPATH_UNIQUE_CONSTRAINT_NAME");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder masked() {
        this.appendElement("MASKED");
        return (SqlServerSqlBuilder)this.instance();
    }

    public SqlServerSqlBuilder dataCompression() {
        this.appendElement("DATA_COMPRESSION");
        return (SqlServerSqlBuilder)this.instance();
    }

    protected void argumentBefore(NamedArgument obj) {
    }

    protected void argumentAfter(NamedArgument obj) {
        this.argumentDirection(obj);
        if (!CommonUtils.isEmpty((CharSequence)obj.getDefaultValue())) {
            ((SqlServerSqlBuilder)((SqlServerSqlBuilder)((SqlServerSqlBuilder)this.space()).eq()).space())._add(obj.getDefaultValue());
        }
        if (obj.getReadonly() != null && obj.getReadonly().booleanValue()) {
            ((SqlServerSqlBuilder)this.space()).readonly();
        }
    }

    public SqlServerSqlBuilder arguments(NamedArgumentCollection<?> arguments) {
        if (arguments.getParent() instanceof Procedure) {
            return (SqlServerSqlBuilder)this.arguments("\n\t", arguments, "", "\n\t, ");
        }
        return (SqlServerSqlBuilder)this.arguments("(", arguments, ")", ", ");
    }

    public SqlServerSqlBuilder clone() {
        return (SqlServerSqlBuilder)super.clone();
    }

    public SqlServerSqlBuilder definition(Column column) {
        if (column.getDataType() == DataType.DOMAIN) {
            this._add(column.getDataTypeName());
        } else {
            this.typeDefinition(column);
            this.characterSetDefinition(column);
            this.collateDefinition(column);
        }
        if (!CommonUtils.isEmpty((CharSequence)column.getMaskingFunction()) && this.getDialect().compareTo(this.sqlserver2016) >= 0) {
            ((SqlServerSqlBuilder)((SqlServerSqlBuilder)this.masked().with()).space()).brackets(() -> ((SqlServerSqlBuilder)((SqlServerSqlBuilder)((SqlServerSqlBuilder)((SqlServerSqlBuilder)((SqlServerSqlBuilder)((SqlServerSqlBuilder)this.function()).space()).eq()).space())._add("'"))._add(column.getMaskingFunction()))._add("'"));
        }
        if (!column.isIdentity() && !CommonUtils.isEmpty((CharSequence)column.getDefaultValue())) {
            this.defaultDefinition(column);
        }
        this.notNullDefinition(column);
        if (column.isIdentity()) {
            this.autoIncrement((AbstractColumn)column);
        }
        if (!CommonUtils.isEmpty((CharSequence)column.getOnUpdate())) {
            this.onUpdateDefinition(column);
        }
        if (!CommonUtils.isEmpty((CharSequence)column.getCheck())) {
            this.checkConstraintDefinition(column);
        }
        if (!CommonUtils.isEmpty((CharSequence)column.getRemarks())) {
            this.comment((AbstractColumn)column);
        }
        return (SqlServerSqlBuilder)this.instance();
    }

    protected SqlServerSqlBuilder autoIncrement(AbstractColumn<?> column) {
        this.identity();
        return (SqlServerSqlBuilder)this.instance();
    }
}

