/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * BackgroundCheckResultValue - The result of the test.
 */
@JsonDeserialize(using = BackgroundCheckResultValue._Deserializer.class)
@JsonSerialize(using = BackgroundCheckResultValue._Serializer.class)
public class BackgroundCheckResultValue {

    public static final BackgroundCheckResultValue CANCELLED = new BackgroundCheckResultValue("cancelled");
    public static final BackgroundCheckResultValue COMPLETED = new BackgroundCheckResultValue("completed");
    public static final BackgroundCheckResultValue EXPIRED = new BackgroundCheckResultValue("expired");
    public static final BackgroundCheckResultValue FAILED = new BackgroundCheckResultValue("failed");
    public static final BackgroundCheckResultValue PASSED = new BackgroundCheckResultValue("passed");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, BackgroundCheckResultValue> values = createValuesMap();
    private static final Map<String, BackgroundCheckResultValueEnum> enums = createEnumsMap();

    private final String value;

    private BackgroundCheckResultValue(String value) {
        this.value = value;
    }

    /**
     * Returns a BackgroundCheckResultValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as BackgroundCheckResultValue
     */ 
    public static BackgroundCheckResultValue of(String value) {
        synchronized (BackgroundCheckResultValue.class) {
            return values.computeIfAbsent(value, v -> new BackgroundCheckResultValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<BackgroundCheckResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        BackgroundCheckResultValue other = (BackgroundCheckResultValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "BackgroundCheckResultValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static BackgroundCheckResultValue[] values() {
        synchronized (BackgroundCheckResultValue.class) {
            return values.values().toArray(new BackgroundCheckResultValue[] {});
        }
    }

    private static final Map<String, BackgroundCheckResultValue> createValuesMap() {
        Map<String, BackgroundCheckResultValue> map = new LinkedHashMap<>();
        map.put("cancelled", CANCELLED);
        map.put("completed", COMPLETED);
        map.put("expired", EXPIRED);
        map.put("failed", FAILED);
        map.put("passed", PASSED);
        return map;
    }

    private static final Map<String, BackgroundCheckResultValueEnum> createEnumsMap() {
        Map<String, BackgroundCheckResultValueEnum> map = new HashMap<>();
        map.put("cancelled", BackgroundCheckResultValueEnum.CANCELLED);
        map.put("completed", BackgroundCheckResultValueEnum.COMPLETED);
        map.put("expired", BackgroundCheckResultValueEnum.EXPIRED);
        map.put("failed", BackgroundCheckResultValueEnum.FAILED);
        map.put("passed", BackgroundCheckResultValueEnum.PASSED);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<BackgroundCheckResultValue> {

        protected _Serializer() {
            super(BackgroundCheckResultValue.class);
        }

        @Override
        public void serialize(BackgroundCheckResultValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<BackgroundCheckResultValue> {

        protected _Deserializer() {
            super(BackgroundCheckResultValue.class);
        }

        @Override
        public BackgroundCheckResultValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return BackgroundCheckResultValue.of(v);
        }
    }
    
    public enum BackgroundCheckResultValueEnum {

        CANCELLED("cancelled"),
        COMPLETED("completed"),
        EXPIRED("expired"),
        FAILED("failed"),
        PASSED("passed"),;

        private final String value;

        private BackgroundCheckResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
