/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * MessageValue - The unified message type.
 */
@JsonDeserialize(using = MessageValue._Deserializer.class)
@JsonSerialize(using = MessageValue._Serializer.class)
public class MessageValue {

    public static final MessageValue EMAIL = new MessageValue("email");
    public static final MessageValue SMS = new MessageValue("sms");
    public static final MessageValue PUSH = new MessageValue("push");
    public static final MessageValue WEB_PUSH = new MessageValue("web_push");
    public static final MessageValue IOS_PUSH = new MessageValue("ios_push");
    public static final MessageValue ANDROID_PUSH = new MessageValue("android_push");
    public static final MessageValue APP_PUSH = new MessageValue("app_push");
    public static final MessageValue OMNI_CHANNEL = new MessageValue("omni_channel");
    public static final MessageValue CONTENT_BLOCK = new MessageValue("content_block");
    public static final MessageValue IN_APP = new MessageValue("in_app");
    public static final MessageValue UNKNOWN = new MessageValue("unknown");
    public static final MessageValue UNMAPPED_VALUE = new MessageValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, MessageValue> values = createValuesMap();
    private static final Map<String, MessageValueEnum> enums = createEnumsMap();

    private final String value;

    private MessageValue(String value) {
        this.value = value;
    }

    /**
     * Returns a MessageValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as MessageValue
     */ 
    public static MessageValue of(String value) {
        synchronized (MessageValue.class) {
            return values.computeIfAbsent(value, v -> new MessageValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<MessageValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        MessageValue other = (MessageValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "MessageValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static MessageValue[] values() {
        synchronized (MessageValue.class) {
            return values.values().toArray(new MessageValue[] {});
        }
    }

    private static final Map<String, MessageValue> createValuesMap() {
        Map<String, MessageValue> map = new LinkedHashMap<>();
        map.put("email", EMAIL);
        map.put("sms", SMS);
        map.put("push", PUSH);
        map.put("web_push", WEB_PUSH);
        map.put("ios_push", IOS_PUSH);
        map.put("android_push", ANDROID_PUSH);
        map.put("app_push", APP_PUSH);
        map.put("omni_channel", OMNI_CHANNEL);
        map.put("content_block", CONTENT_BLOCK);
        map.put("in_app", IN_APP);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, MessageValueEnum> createEnumsMap() {
        Map<String, MessageValueEnum> map = new HashMap<>();
        map.put("email", MessageValueEnum.EMAIL);
        map.put("sms", MessageValueEnum.SMS);
        map.put("push", MessageValueEnum.PUSH);
        map.put("web_push", MessageValueEnum.WEB_PUSH);
        map.put("ios_push", MessageValueEnum.IOS_PUSH);
        map.put("android_push", MessageValueEnum.ANDROID_PUSH);
        map.put("app_push", MessageValueEnum.APP_PUSH);
        map.put("omni_channel", MessageValueEnum.OMNI_CHANNEL);
        map.put("content_block", MessageValueEnum.CONTENT_BLOCK);
        map.put("in_app", MessageValueEnum.IN_APP);
        map.put("unknown", MessageValueEnum.UNKNOWN);
        map.put("unmapped_value", MessageValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<MessageValue> {

        protected _Serializer() {
            super(MessageValue.class);
        }

        @Override
        public void serialize(MessageValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<MessageValue> {

        protected _Deserializer() {
            super(MessageValue.class);
        }

        @Override
        public MessageValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return MessageValue.of(v);
        }
    }
    
    public enum MessageValueEnum {

        EMAIL("email"),
        SMS("sms"),
        PUSH("push"),
        WEB_PUSH("web_push"),
        IOS_PUSH("ios_push"),
        ANDROID_PUSH("android_push"),
        APP_PUSH("app_push"),
        OMNI_CHANNEL("omni_channel"),
        CONTENT_BLOCK("content_block"),
        IN_APP("in_app"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private MessageValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
