/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * AccountAddressLocationTypeValue - The type of the location.
 */
@JsonDeserialize(using = AccountAddressLocationTypeValue._Deserializer.class)
@JsonSerialize(using = AccountAddressLocationTypeValue._Serializer.class)
public class AccountAddressLocationTypeValue {

    public static final AccountAddressLocationTypeValue HOME = new AccountAddressLocationTypeValue("home");
    public static final AccountAddressLocationTypeValue WORK = new AccountAddressLocationTypeValue("work");
    public static final AccountAddressLocationTypeValue UNMAPPED_VALUE = new AccountAddressLocationTypeValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AccountAddressLocationTypeValue> values = createValuesMap();
    private static final Map<String, AccountAddressLocationTypeValueEnum> enums = createEnumsMap();

    private final String value;

    private AccountAddressLocationTypeValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AccountAddressLocationTypeValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AccountAddressLocationTypeValue
     */ 
    public static AccountAddressLocationTypeValue of(String value) {
        synchronized (AccountAddressLocationTypeValue.class) {
            return values.computeIfAbsent(value, v -> new AccountAddressLocationTypeValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<AccountAddressLocationTypeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AccountAddressLocationTypeValue other = (AccountAddressLocationTypeValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AccountAddressLocationTypeValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AccountAddressLocationTypeValue[] values() {
        synchronized (AccountAddressLocationTypeValue.class) {
            return values.values().toArray(new AccountAddressLocationTypeValue[] {});
        }
    }

    private static final Map<String, AccountAddressLocationTypeValue> createValuesMap() {
        Map<String, AccountAddressLocationTypeValue> map = new LinkedHashMap<>();
        map.put("home", HOME);
        map.put("work", WORK);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AccountAddressLocationTypeValueEnum> createEnumsMap() {
        Map<String, AccountAddressLocationTypeValueEnum> map = new HashMap<>();
        map.put("home", AccountAddressLocationTypeValueEnum.HOME);
        map.put("work", AccountAddressLocationTypeValueEnum.WORK);
        map.put("unmapped_value", AccountAddressLocationTypeValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<AccountAddressLocationTypeValue> {

        protected _Serializer() {
            super(AccountAddressLocationTypeValue.class);
        }

        @Override
        public void serialize(AccountAddressLocationTypeValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<AccountAddressLocationTypeValue> {

        protected _Deserializer() {
            super(AccountAddressLocationTypeValue.class);
        }

        @Override
        public AccountAddressLocationTypeValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return AccountAddressLocationTypeValue.of(v);
        }
    }
    
    public enum AccountAddressLocationTypeValueEnum {

        HOME("home"),
        WORK("work"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AccountAddressLocationTypeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
