/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * AssessmentResultValue - The result of the test.
 */
@JsonDeserialize(using = AssessmentResultValue._Deserializer.class)
@JsonSerialize(using = AssessmentResultValue._Serializer.class)
public class AssessmentResultValue {

    public static final AssessmentResultValue CANCELLED = new AssessmentResultValue("cancelled");
    public static final AssessmentResultValue COMPLETED = new AssessmentResultValue("completed");
    public static final AssessmentResultValue EXPIRED = new AssessmentResultValue("expired");
    public static final AssessmentResultValue FAILED = new AssessmentResultValue("failed");
    public static final AssessmentResultValue PASSED = new AssessmentResultValue("passed");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AssessmentResultValue> values = createValuesMap();
    private static final Map<String, AssessmentResultValueEnum> enums = createEnumsMap();

    private final String value;

    private AssessmentResultValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AssessmentResultValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AssessmentResultValue
     */ 
    public static AssessmentResultValue of(String value) {
        synchronized (AssessmentResultValue.class) {
            return values.computeIfAbsent(value, v -> new AssessmentResultValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<AssessmentResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AssessmentResultValue other = (AssessmentResultValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AssessmentResultValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AssessmentResultValue[] values() {
        synchronized (AssessmentResultValue.class) {
            return values.values().toArray(new AssessmentResultValue[] {});
        }
    }

    private static final Map<String, AssessmentResultValue> createValuesMap() {
        Map<String, AssessmentResultValue> map = new LinkedHashMap<>();
        map.put("cancelled", CANCELLED);
        map.put("completed", COMPLETED);
        map.put("expired", EXPIRED);
        map.put("failed", FAILED);
        map.put("passed", PASSED);
        return map;
    }

    private static final Map<String, AssessmentResultValueEnum> createEnumsMap() {
        Map<String, AssessmentResultValueEnum> map = new HashMap<>();
        map.put("cancelled", AssessmentResultValueEnum.CANCELLED);
        map.put("completed", AssessmentResultValueEnum.COMPLETED);
        map.put("expired", AssessmentResultValueEnum.EXPIRED);
        map.put("failed", AssessmentResultValueEnum.FAILED);
        map.put("passed", AssessmentResultValueEnum.PASSED);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<AssessmentResultValue> {

        protected _Serializer() {
            super(AssessmentResultValue.class);
        }

        @Override
        public void serialize(AssessmentResultValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<AssessmentResultValue> {

        protected _Deserializer() {
            super(AssessmentResultValue.class);
        }

        @Override
        public AssessmentResultValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return AssessmentResultValue.of(v);
        }
    }
    
    public enum AssessmentResultValueEnum {

        CANCELLED("cancelled"),
        COMPLETED("completed"),
        EXPIRED("expired"),
        FAILED("failed"),
        PASSED("passed"),;

        private final String value;

        private AssessmentResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
