/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class ContentBlockValue {
    public static final ContentBlockValue TEXT = new ContentBlockValue("text");
    public static final ContentBlockValue HTML = new ContentBlockValue("html");
    public static final ContentBlockValue IMAGE = new ContentBlockValue("image");
    public static final ContentBlockValue CODE_SNIPPET = new ContentBlockValue("code-snippet");
    private static final Map<String, ContentBlockValue> values = ContentBlockValue.createValuesMap();
    private static final Map<String, ContentBlockValueEnum> enums = ContentBlockValue.createEnumsMap();
    private final String value;

    private ContentBlockValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentBlockValue of(String value) {
        Class<ContentBlockValue> clazz = ContentBlockValue.class;
        synchronized (ContentBlockValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new ContentBlockValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<ContentBlockValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentBlockValue other = (ContentBlockValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "ContentBlockValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentBlockValue[] values() {
        Class<ContentBlockValue> clazz = ContentBlockValue.class;
        synchronized (ContentBlockValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new ContentBlockValue[0]);
        }
    }

    private static final Map<String, ContentBlockValue> createValuesMap() {
        LinkedHashMap<String, ContentBlockValue> map = new LinkedHashMap<String, ContentBlockValue>();
        map.put("text", TEXT);
        map.put("html", HTML);
        map.put("image", IMAGE);
        map.put("code-snippet", CODE_SNIPPET);
        return map;
    }

    private static final Map<String, ContentBlockValueEnum> createEnumsMap() {
        HashMap<String, ContentBlockValueEnum> map = new HashMap<String, ContentBlockValueEnum>();
        map.put("text", ContentBlockValueEnum.TEXT);
        map.put("html", ContentBlockValueEnum.HTML);
        map.put("image", ContentBlockValueEnum.IMAGE);
        map.put("code-snippet", ContentBlockValueEnum.CODE_SNIPPET);
        return map;
    }

    public static enum ContentBlockValueEnum {
        TEXT("text"),
        HTML("html"),
        IMAGE("image"),
        CODE_SNIPPET("code-snippet");

        private final String value;

        private ContentBlockValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<ContentBlockValue> {
        protected _Deserializer() {
            super(ContentBlockValue.class);
        }

        public ContentBlockValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return ContentBlockValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<ContentBlockValue> {
        protected _Serializer() {
            super(ContentBlockValue.class);
        }

        public void serialize(ContentBlockValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

