/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class SkillsProficiencyValue {
    public static final SkillsProficiencyValue ONE = new SkillsProficiencyValue("1");
    public static final SkillsProficiencyValue TWO = new SkillsProficiencyValue("2");
    public static final SkillsProficiencyValue THREE = new SkillsProficiencyValue("3");
    public static final SkillsProficiencyValue FOUR = new SkillsProficiencyValue("4");
    public static final SkillsProficiencyValue FIVE = new SkillsProficiencyValue("5");
    private static final Map<String, SkillsProficiencyValue> values = SkillsProficiencyValue.createValuesMap();
    private static final Map<String, SkillsProficiencyValueEnum> enums = SkillsProficiencyValue.createEnumsMap();
    private final String value;

    private SkillsProficiencyValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SkillsProficiencyValue of(String value) {
        Class<SkillsProficiencyValue> clazz = SkillsProficiencyValue.class;
        synchronized (SkillsProficiencyValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new SkillsProficiencyValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<SkillsProficiencyValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SkillsProficiencyValue other = (SkillsProficiencyValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "SkillsProficiencyValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SkillsProficiencyValue[] values() {
        Class<SkillsProficiencyValue> clazz = SkillsProficiencyValue.class;
        synchronized (SkillsProficiencyValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new SkillsProficiencyValue[0]);
        }
    }

    private static final Map<String, SkillsProficiencyValue> createValuesMap() {
        LinkedHashMap<String, SkillsProficiencyValue> map = new LinkedHashMap<String, SkillsProficiencyValue>();
        map.put("1", ONE);
        map.put("2", TWO);
        map.put("3", THREE);
        map.put("4", FOUR);
        map.put("5", FIVE);
        return map;
    }

    private static final Map<String, SkillsProficiencyValueEnum> createEnumsMap() {
        HashMap<String, SkillsProficiencyValueEnum> map = new HashMap<String, SkillsProficiencyValueEnum>();
        map.put("1", SkillsProficiencyValueEnum.ONE);
        map.put("2", SkillsProficiencyValueEnum.TWO);
        map.put("3", SkillsProficiencyValueEnum.THREE);
        map.put("4", SkillsProficiencyValueEnum.FOUR);
        map.put("5", SkillsProficiencyValueEnum.FIVE);
        return map;
    }

    public static enum SkillsProficiencyValueEnum {
        ONE("1"),
        TWO("2"),
        THREE("3"),
        FOUR("4"),
        FIVE("5");

        private final String value;

        private SkillsProficiencyValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<SkillsProficiencyValue> {
        protected _Deserializer() {
            super(SkillsProficiencyValue.class);
        }

        public SkillsProficiencyValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return SkillsProficiencyValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<SkillsProficiencyValue> {
        protected _Serializer() {
            super(SkillsProficiencyValue.class);
        }

        public void serialize(SkillsProficiencyValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

