/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.BackgroundCheckOrderResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AtsGetBackgroundCheckRequestResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends BackgroundCheckOrderResult> backgroundCheckOrderResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetBackgroundCheckRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends BackgroundCheckOrderResult> backgroundCheckOrderResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(backgroundCheckOrderResult, "backgroundCheckOrderResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.backgroundCheckOrderResult = backgroundCheckOrderResult;
        this.headers = headers;
    }

    public AtsGetBackgroundCheckRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<BackgroundCheckOrderResult> backgroundCheckOrderResult() {
        return this.backgroundCheckOrderResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsGetBackgroundCheckRequestResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsGetBackgroundCheckRequestResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsGetBackgroundCheckRequestResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsGetBackgroundCheckRequestResponse withBackgroundCheckOrderResult(BackgroundCheckOrderResult backgroundCheckOrderResult) {
        Utils.checkNotNull(backgroundCheckOrderResult, "backgroundCheckOrderResult");
        this.backgroundCheckOrderResult = Optional.ofNullable(backgroundCheckOrderResult);
        return this;
    }

    public AtsGetBackgroundCheckRequestResponse withBackgroundCheckOrderResult(Optional<? extends BackgroundCheckOrderResult> backgroundCheckOrderResult) {
        Utils.checkNotNull(backgroundCheckOrderResult, "backgroundCheckOrderResult");
        this.backgroundCheckOrderResult = backgroundCheckOrderResult;
        return this;
    }

    public AtsGetBackgroundCheckRequestResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsGetBackgroundCheckRequestResponse other = (AtsGetBackgroundCheckRequestResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.backgroundCheckOrderResult, other.backgroundCheckOrderResult) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.backgroundCheckOrderResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsGetBackgroundCheckRequestResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "backgroundCheckOrderResult", this.backgroundCheckOrderResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends BackgroundCheckOrderResult> backgroundCheckOrderResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder backgroundCheckOrderResult(BackgroundCheckOrderResult backgroundCheckOrderResult) {
            Utils.checkNotNull(backgroundCheckOrderResult, "backgroundCheckOrderResult");
            this.backgroundCheckOrderResult = Optional.ofNullable(backgroundCheckOrderResult);
            return this;
        }

        public Builder backgroundCheckOrderResult(Optional<? extends BackgroundCheckOrderResult> backgroundCheckOrderResult) {
            Utils.checkNotNull(backgroundCheckOrderResult, "backgroundCheckOrderResult");
            this.backgroundCheckOrderResult = backgroundCheckOrderResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsGetBackgroundCheckRequestResponse build() {
            return new AtsGetBackgroundCheckRequestResponse(this.contentType, this.statusCode, this.rawResponse, this.backgroundCheckOrderResult, this.headers);
        }
    }
}

