/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.models.operations.StackoneGetConnectorMetaRequest;
import com.stackone.stackone_client_java.models.operations.StackoneGetConnectorMetaRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneGetConnectorMetaResponse;
import com.stackone.stackone_client_java.models.operations.StackoneListConnectorsMetaRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListConnectorsMetaRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneListConnectorsMetaResponse;
import com.stackone.stackone_client_java.operations.StackoneGetConnectorMeta;
import com.stackone.stackone_client_java.operations.StackoneListConnectorsMeta;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.Exception;
import java.lang.String;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * Retrieve metadata for connectors.
 */
public class Connectors {
    private final SDKConfiguration sdkConfiguration;

    Connectors(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * List Connector Meta Information
     * 
     * @return The call builder
     */
    public StackoneListConnectorsMetaRequestBuilder listConnectorsMeta() {
        return new StackoneListConnectorsMetaRequestBuilder(sdkConfiguration);
    }

    /**
     * List Connector Meta Information
     * 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneListConnectorsMetaResponse listConnectorsMetaDirect() throws Exception {
        return listConnectorsMeta(JsonNullable.undefined(), Optional.empty());
    }

    /**
     * List Connector Meta Information
     * 
     * @param include The comma separated list of data that will be included in the response
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneListConnectorsMetaResponse listConnectorsMeta(JsonNullable<String> include, Optional<Options> options) throws Exception {
        StackoneListConnectorsMetaRequest request =
            StackoneListConnectorsMetaRequest
                .builder()
                .include(include)
                .build();
        RequestOperation<StackoneListConnectorsMetaRequest, StackoneListConnectorsMetaResponse> operation
              = new StackoneListConnectorsMeta.Sync(sdkConfiguration, options);
        return operation.handleResponse(operation.doRequest(request));
    }

    /**
     * Get Connector Meta Information
     * 
     * @return The call builder
     */
    public StackoneGetConnectorMetaRequestBuilder getConnectorMeta() {
        return new StackoneGetConnectorMetaRequestBuilder(sdkConfiguration);
    }

    /**
     * Get Connector Meta Information
     * 
     * @param provider 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneGetConnectorMetaResponse getConnectorMeta(String provider) throws Exception {
        return getConnectorMeta(provider, JsonNullable.undefined(), Optional.empty());
    }

    /**
     * Get Connector Meta Information
     * 
     * @param provider 
     * @param include The comma separated list of data that will be included in the response
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneGetConnectorMetaResponse getConnectorMeta(
            String provider, JsonNullable<String> include,
            Optional<Options> options) throws Exception {
        StackoneGetConnectorMetaRequest request =
            StackoneGetConnectorMetaRequest
                .builder()
                .provider(provider)
                .include(include)
                .build();
        RequestOperation<StackoneGetConnectorMetaRequest, StackoneGetConnectorMetaResponse> operation
              = new StackoneGetConnectorMeta.Sync(sdkConfiguration, options);
        return operation.handleResponse(operation.doRequest(request));
    }

}
