/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;


public class MessageContent {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("subject")
    private JsonNullable<String> subject;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("body")
    private JsonNullable<String> body;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("from")
    private JsonNullable<String> from;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("reply-to")
    private JsonNullable<String> replyTo;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("preheader")
    private JsonNullable<String> preheader;

    @JsonCreator
    public MessageContent(
            @JsonProperty("subject") JsonNullable<String> subject,
            @JsonProperty("body") JsonNullable<String> body,
            @JsonProperty("from") JsonNullable<String> from,
            @JsonProperty("reply-to") JsonNullable<String> replyTo,
            @JsonProperty("preheader") JsonNullable<String> preheader) {
        Utils.checkNotNull(subject, "subject");
        Utils.checkNotNull(body, "body");
        Utils.checkNotNull(from, "from");
        Utils.checkNotNull(replyTo, "replyTo");
        Utils.checkNotNull(preheader, "preheader");
        this.subject = subject;
        this.body = body;
        this.from = from;
        this.replyTo = replyTo;
        this.preheader = preheader;
    }
    
    public MessageContent() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> subject() {
        return subject;
    }

    @JsonIgnore
    public JsonNullable<String> body() {
        return body;
    }

    @JsonIgnore
    public JsonNullable<String> from() {
        return from;
    }

    @JsonIgnore
    public JsonNullable<String> replyTo() {
        return replyTo;
    }

    @JsonIgnore
    public JsonNullable<String> preheader() {
        return preheader;
    }

    public static Builder builder() {
        return new Builder();
    }


    public MessageContent withSubject(String subject) {
        Utils.checkNotNull(subject, "subject");
        this.subject = JsonNullable.of(subject);
        return this;
    }

    public MessageContent withSubject(JsonNullable<String> subject) {
        Utils.checkNotNull(subject, "subject");
        this.subject = subject;
        return this;
    }

    public MessageContent withBody(String body) {
        Utils.checkNotNull(body, "body");
        this.body = JsonNullable.of(body);
        return this;
    }

    public MessageContent withBody(JsonNullable<String> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    public MessageContent withFrom(String from) {
        Utils.checkNotNull(from, "from");
        this.from = JsonNullable.of(from);
        return this;
    }

    public MessageContent withFrom(JsonNullable<String> from) {
        Utils.checkNotNull(from, "from");
        this.from = from;
        return this;
    }

    public MessageContent withReplyTo(String replyTo) {
        Utils.checkNotNull(replyTo, "replyTo");
        this.replyTo = JsonNullable.of(replyTo);
        return this;
    }

    public MessageContent withReplyTo(JsonNullable<String> replyTo) {
        Utils.checkNotNull(replyTo, "replyTo");
        this.replyTo = replyTo;
        return this;
    }

    public MessageContent withPreheader(String preheader) {
        Utils.checkNotNull(preheader, "preheader");
        this.preheader = JsonNullable.of(preheader);
        return this;
    }

    public MessageContent withPreheader(JsonNullable<String> preheader) {
        Utils.checkNotNull(preheader, "preheader");
        this.preheader = preheader;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessageContent other = (MessageContent) o;
        return 
            Utils.enhancedDeepEquals(this.subject, other.subject) &&
            Utils.enhancedDeepEquals(this.body, other.body) &&
            Utils.enhancedDeepEquals(this.from, other.from) &&
            Utils.enhancedDeepEquals(this.replyTo, other.replyTo) &&
            Utils.enhancedDeepEquals(this.preheader, other.preheader);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            subject, body, from,
            replyTo, preheader);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MessageContent.class,
                "subject", subject,
                "body", body,
                "from", from,
                "replyTo", replyTo,
                "preheader", preheader);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> subject = JsonNullable.undefined();

        private JsonNullable<String> body = JsonNullable.undefined();

        private JsonNullable<String> from = JsonNullable.undefined();

        private JsonNullable<String> replyTo = JsonNullable.undefined();

        private JsonNullable<String> preheader = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        public Builder subject(String subject) {
            Utils.checkNotNull(subject, "subject");
            this.subject = JsonNullable.of(subject);
            return this;
        }

        public Builder subject(JsonNullable<String> subject) {
            Utils.checkNotNull(subject, "subject");
            this.subject = subject;
            return this;
        }


        public Builder body(String body) {
            Utils.checkNotNull(body, "body");
            this.body = JsonNullable.of(body);
            return this;
        }

        public Builder body(JsonNullable<String> body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }


        public Builder from(String from) {
            Utils.checkNotNull(from, "from");
            this.from = JsonNullable.of(from);
            return this;
        }

        public Builder from(JsonNullable<String> from) {
            Utils.checkNotNull(from, "from");
            this.from = from;
            return this;
        }


        public Builder replyTo(String replyTo) {
            Utils.checkNotNull(replyTo, "replyTo");
            this.replyTo = JsonNullable.of(replyTo);
            return this;
        }

        public Builder replyTo(JsonNullable<String> replyTo) {
            Utils.checkNotNull(replyTo, "replyTo");
            this.replyTo = replyTo;
            return this;
        }


        public Builder preheader(String preheader) {
            Utils.checkNotNull(preheader, "preheader");
            this.preheader = JsonNullable.of(preheader);
            return this;
        }

        public Builder preheader(JsonNullable<String> preheader) {
            Utils.checkNotNull(preheader, "preheader");
            this.preheader = preheader;
            return this;
        }

        public MessageContent build() {

            return new MessageContent(
                subject, body, from,
                replyTo, preheader);
        }

    }
}
