/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * TicketingReadTicketType
 * 
 * <p>The type of the ticket
 */
public class TicketingReadTicketType {
    /**
     * The id of the ticket type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * The name of the ticket type.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The project the ticket type belongs to.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("project_id")
    private JsonNullable<String> projectId;

    @JsonCreator
    public TicketingReadTicketType(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("project_id") JsonNullable<String> projectId) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(projectId, "projectId");
        this.id = id;
        this.name = name;
        this.projectId = projectId;
    }
    
    public TicketingReadTicketType() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The id of the ticket type.
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * The name of the ticket type.
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The project the ticket type belongs to.
     */
    @JsonIgnore
    public JsonNullable<String> projectId() {
        return projectId;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The id of the ticket type.
     */
    public TicketingReadTicketType withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * The id of the ticket type.
     */
    public TicketingReadTicketType withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * The name of the ticket type.
     */
    public TicketingReadTicketType withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The name of the ticket type.
     */
    public TicketingReadTicketType withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The project the ticket type belongs to.
     */
    public TicketingReadTicketType withProjectId(String projectId) {
        Utils.checkNotNull(projectId, "projectId");
        this.projectId = JsonNullable.of(projectId);
        return this;
    }

    /**
     * The project the ticket type belongs to.
     */
    public TicketingReadTicketType withProjectId(JsonNullable<String> projectId) {
        Utils.checkNotNull(projectId, "projectId");
        this.projectId = projectId;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TicketingReadTicketType other = (TicketingReadTicketType) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.projectId, other.projectId);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, name, projectId);
    }
    
    @Override
    public String toString() {
        return Utils.toString(TicketingReadTicketType.class,
                "id", id,
                "name", name,
                "projectId", projectId);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<String> projectId = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The id of the ticket type.
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * The id of the ticket type.
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * The name of the ticket type.
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The name of the ticket type.
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * The project the ticket type belongs to.
         */
        public Builder projectId(String projectId) {
            Utils.checkNotNull(projectId, "projectId");
            this.projectId = JsonNullable.of(projectId);
            return this;
        }

        /**
         * The project the ticket type belongs to.
         */
        public Builder projectId(JsonNullable<String> projectId) {
            Utils.checkNotNull(projectId, "projectId");
            this.projectId = projectId;
            return this;
        }

        public TicketingReadTicketType build() {

            return new TicketingReadTicketType(
                id, name, projectId);
        }

    }
}
