/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Boolean;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * Filter
 * 
 * <p>Filter parameters that allow greater customisation of the list response
 */
public class Filter {
    /**
     * A comma-separated list of account IDs to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=account_ids")
    private JsonNullable<String> accountIds;

    /**
     * A ISO8601 date string to filter the results by start_date.
     */
    @SpeakeasyMetadata("queryParam:name=start_date")
    private JsonNullable<OffsetDateTime> startDate;

    /**
     * A ISO8601 date string to filter the results by end_date.
     */
    @SpeakeasyMetadata("queryParam:name=end_date")
    private JsonNullable<OffsetDateTime> endDate;

    /**
     * A comma-separated list of request IDs to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=request_ids")
    private JsonNullable<String> requestIds;

    /**
     * A comma-separated list of HTTP methods to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=http_methods")
    private JsonNullable<String> httpMethods;

    /**
     * A comma-separated list of provider keys to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=providers")
    private JsonNullable<String> providers;

    /**
     * A comma-separated list of services to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=services")
    private JsonNullable<String> services;

    /**
     * A comma-separated list of resources to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=resources")
    private JsonNullable<String> resources;

    /**
     * A comma-separated list of child resources to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=child_resources")
    private JsonNullable<String> childResources;

    /**
     * A comma-separated list of sub resources to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=sub_resources")
    private JsonNullable<String> subResources;

    /**
     * A comma-separated list of actions to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=actions")
    private JsonNullable<String> actions;

    /**
     * A comma-separated list of status codes to filter the results by.
     */
    @SpeakeasyMetadata("queryParam:name=status_codes")
    private JsonNullable<String> statusCodes;

    /**
     * A boolean value to filter the results by success or failure.
     */
    @SpeakeasyMetadata("queryParam:name=success")
    private JsonNullable<Boolean> success;

    @JsonCreator
    public Filter(
            JsonNullable<String> accountIds,
            JsonNullable<OffsetDateTime> startDate,
            JsonNullable<OffsetDateTime> endDate,
            JsonNullable<String> requestIds,
            JsonNullable<String> httpMethods,
            JsonNullable<String> providers,
            JsonNullable<String> services,
            JsonNullable<String> resources,
            JsonNullable<String> childResources,
            JsonNullable<String> subResources,
            JsonNullable<String> actions,
            JsonNullable<String> statusCodes,
            JsonNullable<Boolean> success) {
        Utils.checkNotNull(accountIds, "accountIds");
        Utils.checkNotNull(startDate, "startDate");
        Utils.checkNotNull(endDate, "endDate");
        Utils.checkNotNull(requestIds, "requestIds");
        Utils.checkNotNull(httpMethods, "httpMethods");
        Utils.checkNotNull(providers, "providers");
        Utils.checkNotNull(services, "services");
        Utils.checkNotNull(resources, "resources");
        Utils.checkNotNull(childResources, "childResources");
        Utils.checkNotNull(subResources, "subResources");
        Utils.checkNotNull(actions, "actions");
        Utils.checkNotNull(statusCodes, "statusCodes");
        Utils.checkNotNull(success, "success");
        this.accountIds = accountIds;
        this.startDate = startDate;
        this.endDate = endDate;
        this.requestIds = requestIds;
        this.httpMethods = httpMethods;
        this.providers = providers;
        this.services = services;
        this.resources = resources;
        this.childResources = childResources;
        this.subResources = subResources;
        this.actions = actions;
        this.statusCodes = statusCodes;
        this.success = success;
    }
    
    public Filter() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * A comma-separated list of account IDs to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> accountIds() {
        return accountIds;
    }

    /**
     * A ISO8601 date string to filter the results by start_date.
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> startDate() {
        return startDate;
    }

    /**
     * A ISO8601 date string to filter the results by end_date.
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> endDate() {
        return endDate;
    }

    /**
     * A comma-separated list of request IDs to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> requestIds() {
        return requestIds;
    }

    /**
     * A comma-separated list of HTTP methods to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> httpMethods() {
        return httpMethods;
    }

    /**
     * A comma-separated list of provider keys to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> providers() {
        return providers;
    }

    /**
     * A comma-separated list of services to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> services() {
        return services;
    }

    /**
     * A comma-separated list of resources to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> resources() {
        return resources;
    }

    /**
     * A comma-separated list of child resources to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> childResources() {
        return childResources;
    }

    /**
     * A comma-separated list of sub resources to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> subResources() {
        return subResources;
    }

    /**
     * A comma-separated list of actions to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> actions() {
        return actions;
    }

    /**
     * A comma-separated list of status codes to filter the results by.
     */
    @JsonIgnore
    public JsonNullable<String> statusCodes() {
        return statusCodes;
    }

    /**
     * A boolean value to filter the results by success or failure.
     */
    @JsonIgnore
    public JsonNullable<Boolean> success() {
        return success;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * A comma-separated list of account IDs to filter the results by.
     */
    public Filter withAccountIds(String accountIds) {
        Utils.checkNotNull(accountIds, "accountIds");
        this.accountIds = JsonNullable.of(accountIds);
        return this;
    }

    /**
     * A comma-separated list of account IDs to filter the results by.
     */
    public Filter withAccountIds(JsonNullable<String> accountIds) {
        Utils.checkNotNull(accountIds, "accountIds");
        this.accountIds = accountIds;
        return this;
    }

    /**
     * A ISO8601 date string to filter the results by start_date.
     */
    public Filter withStartDate(OffsetDateTime startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = JsonNullable.of(startDate);
        return this;
    }

    /**
     * A ISO8601 date string to filter the results by start_date.
     */
    public Filter withStartDate(JsonNullable<OffsetDateTime> startDate) {
        Utils.checkNotNull(startDate, "startDate");
        this.startDate = startDate;
        return this;
    }

    /**
     * A ISO8601 date string to filter the results by end_date.
     */
    public Filter withEndDate(OffsetDateTime endDate) {
        Utils.checkNotNull(endDate, "endDate");
        this.endDate = JsonNullable.of(endDate);
        return this;
    }

    /**
     * A ISO8601 date string to filter the results by end_date.
     */
    public Filter withEndDate(JsonNullable<OffsetDateTime> endDate) {
        Utils.checkNotNull(endDate, "endDate");
        this.endDate = endDate;
        return this;
    }

    /**
     * A comma-separated list of request IDs to filter the results by.
     */
    public Filter withRequestIds(String requestIds) {
        Utils.checkNotNull(requestIds, "requestIds");
        this.requestIds = JsonNullable.of(requestIds);
        return this;
    }

    /**
     * A comma-separated list of request IDs to filter the results by.
     */
    public Filter withRequestIds(JsonNullable<String> requestIds) {
        Utils.checkNotNull(requestIds, "requestIds");
        this.requestIds = requestIds;
        return this;
    }

    /**
     * A comma-separated list of HTTP methods to filter the results by.
     */
    public Filter withHttpMethods(String httpMethods) {
        Utils.checkNotNull(httpMethods, "httpMethods");
        this.httpMethods = JsonNullable.of(httpMethods);
        return this;
    }

    /**
     * A comma-separated list of HTTP methods to filter the results by.
     */
    public Filter withHttpMethods(JsonNullable<String> httpMethods) {
        Utils.checkNotNull(httpMethods, "httpMethods");
        this.httpMethods = httpMethods;
        return this;
    }

    /**
     * A comma-separated list of provider keys to filter the results by.
     */
    public Filter withProviders(String providers) {
        Utils.checkNotNull(providers, "providers");
        this.providers = JsonNullable.of(providers);
        return this;
    }

    /**
     * A comma-separated list of provider keys to filter the results by.
     */
    public Filter withProviders(JsonNullable<String> providers) {
        Utils.checkNotNull(providers, "providers");
        this.providers = providers;
        return this;
    }

    /**
     * A comma-separated list of services to filter the results by.
     */
    public Filter withServices(String services) {
        Utils.checkNotNull(services, "services");
        this.services = JsonNullable.of(services);
        return this;
    }

    /**
     * A comma-separated list of services to filter the results by.
     */
    public Filter withServices(JsonNullable<String> services) {
        Utils.checkNotNull(services, "services");
        this.services = services;
        return this;
    }

    /**
     * A comma-separated list of resources to filter the results by.
     */
    public Filter withResources(String resources) {
        Utils.checkNotNull(resources, "resources");
        this.resources = JsonNullable.of(resources);
        return this;
    }

    /**
     * A comma-separated list of resources to filter the results by.
     */
    public Filter withResources(JsonNullable<String> resources) {
        Utils.checkNotNull(resources, "resources");
        this.resources = resources;
        return this;
    }

    /**
     * A comma-separated list of child resources to filter the results by.
     */
    public Filter withChildResources(String childResources) {
        Utils.checkNotNull(childResources, "childResources");
        this.childResources = JsonNullable.of(childResources);
        return this;
    }

    /**
     * A comma-separated list of child resources to filter the results by.
     */
    public Filter withChildResources(JsonNullable<String> childResources) {
        Utils.checkNotNull(childResources, "childResources");
        this.childResources = childResources;
        return this;
    }

    /**
     * A comma-separated list of sub resources to filter the results by.
     */
    public Filter withSubResources(String subResources) {
        Utils.checkNotNull(subResources, "subResources");
        this.subResources = JsonNullable.of(subResources);
        return this;
    }

    /**
     * A comma-separated list of sub resources to filter the results by.
     */
    public Filter withSubResources(JsonNullable<String> subResources) {
        Utils.checkNotNull(subResources, "subResources");
        this.subResources = subResources;
        return this;
    }

    /**
     * A comma-separated list of actions to filter the results by.
     */
    public Filter withActions(String actions) {
        Utils.checkNotNull(actions, "actions");
        this.actions = JsonNullable.of(actions);
        return this;
    }

    /**
     * A comma-separated list of actions to filter the results by.
     */
    public Filter withActions(JsonNullable<String> actions) {
        Utils.checkNotNull(actions, "actions");
        this.actions = actions;
        return this;
    }

    /**
     * A comma-separated list of status codes to filter the results by.
     */
    public Filter withStatusCodes(String statusCodes) {
        Utils.checkNotNull(statusCodes, "statusCodes");
        this.statusCodes = JsonNullable.of(statusCodes);
        return this;
    }

    /**
     * A comma-separated list of status codes to filter the results by.
     */
    public Filter withStatusCodes(JsonNullable<String> statusCodes) {
        Utils.checkNotNull(statusCodes, "statusCodes");
        this.statusCodes = statusCodes;
        return this;
    }

    /**
     * A boolean value to filter the results by success or failure.
     */
    public Filter withSuccess(boolean success) {
        Utils.checkNotNull(success, "success");
        this.success = JsonNullable.of(success);
        return this;
    }

    /**
     * A boolean value to filter the results by success or failure.
     */
    public Filter withSuccess(JsonNullable<Boolean> success) {
        Utils.checkNotNull(success, "success");
        this.success = success;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Filter other = (Filter) o;
        return 
            Utils.enhancedDeepEquals(this.accountIds, other.accountIds) &&
            Utils.enhancedDeepEquals(this.startDate, other.startDate) &&
            Utils.enhancedDeepEquals(this.endDate, other.endDate) &&
            Utils.enhancedDeepEquals(this.requestIds, other.requestIds) &&
            Utils.enhancedDeepEquals(this.httpMethods, other.httpMethods) &&
            Utils.enhancedDeepEquals(this.providers, other.providers) &&
            Utils.enhancedDeepEquals(this.services, other.services) &&
            Utils.enhancedDeepEquals(this.resources, other.resources) &&
            Utils.enhancedDeepEquals(this.childResources, other.childResources) &&
            Utils.enhancedDeepEquals(this.subResources, other.subResources) &&
            Utils.enhancedDeepEquals(this.actions, other.actions) &&
            Utils.enhancedDeepEquals(this.statusCodes, other.statusCodes) &&
            Utils.enhancedDeepEquals(this.success, other.success);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            accountIds, startDate, endDate,
            requestIds, httpMethods, providers,
            services, resources, childResources,
            subResources, actions, statusCodes,
            success);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Filter.class,
                "accountIds", accountIds,
                "startDate", startDate,
                "endDate", endDate,
                "requestIds", requestIds,
                "httpMethods", httpMethods,
                "providers", providers,
                "services", services,
                "resources", resources,
                "childResources", childResources,
                "subResources", subResources,
                "actions", actions,
                "statusCodes", statusCodes,
                "success", success);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> accountIds = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> startDate = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> endDate = JsonNullable.undefined();

        private JsonNullable<String> requestIds = JsonNullable.undefined();

        private JsonNullable<String> httpMethods = JsonNullable.undefined();

        private JsonNullable<String> providers = JsonNullable.undefined();

        private JsonNullable<String> services = JsonNullable.undefined();

        private JsonNullable<String> resources = JsonNullable.undefined();

        private JsonNullable<String> childResources = JsonNullable.undefined();

        private JsonNullable<String> subResources = JsonNullable.undefined();

        private JsonNullable<String> actions = JsonNullable.undefined();

        private JsonNullable<String> statusCodes = JsonNullable.undefined();

        private JsonNullable<Boolean> success = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * A comma-separated list of account IDs to filter the results by.
         */
        public Builder accountIds(String accountIds) {
            Utils.checkNotNull(accountIds, "accountIds");
            this.accountIds = JsonNullable.of(accountIds);
            return this;
        }

        /**
         * A comma-separated list of account IDs to filter the results by.
         */
        public Builder accountIds(JsonNullable<String> accountIds) {
            Utils.checkNotNull(accountIds, "accountIds");
            this.accountIds = accountIds;
            return this;
        }


        /**
         * A ISO8601 date string to filter the results by start_date.
         */
        public Builder startDate(OffsetDateTime startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = JsonNullable.of(startDate);
            return this;
        }

        /**
         * A ISO8601 date string to filter the results by start_date.
         */
        public Builder startDate(JsonNullable<OffsetDateTime> startDate) {
            Utils.checkNotNull(startDate, "startDate");
            this.startDate = startDate;
            return this;
        }


        /**
         * A ISO8601 date string to filter the results by end_date.
         */
        public Builder endDate(OffsetDateTime endDate) {
            Utils.checkNotNull(endDate, "endDate");
            this.endDate = JsonNullable.of(endDate);
            return this;
        }

        /**
         * A ISO8601 date string to filter the results by end_date.
         */
        public Builder endDate(JsonNullable<OffsetDateTime> endDate) {
            Utils.checkNotNull(endDate, "endDate");
            this.endDate = endDate;
            return this;
        }


        /**
         * A comma-separated list of request IDs to filter the results by.
         */
        public Builder requestIds(String requestIds) {
            Utils.checkNotNull(requestIds, "requestIds");
            this.requestIds = JsonNullable.of(requestIds);
            return this;
        }

        /**
         * A comma-separated list of request IDs to filter the results by.
         */
        public Builder requestIds(JsonNullable<String> requestIds) {
            Utils.checkNotNull(requestIds, "requestIds");
            this.requestIds = requestIds;
            return this;
        }


        /**
         * A comma-separated list of HTTP methods to filter the results by.
         */
        public Builder httpMethods(String httpMethods) {
            Utils.checkNotNull(httpMethods, "httpMethods");
            this.httpMethods = JsonNullable.of(httpMethods);
            return this;
        }

        /**
         * A comma-separated list of HTTP methods to filter the results by.
         */
        public Builder httpMethods(JsonNullable<String> httpMethods) {
            Utils.checkNotNull(httpMethods, "httpMethods");
            this.httpMethods = httpMethods;
            return this;
        }


        /**
         * A comma-separated list of provider keys to filter the results by.
         */
        public Builder providers(String providers) {
            Utils.checkNotNull(providers, "providers");
            this.providers = JsonNullable.of(providers);
            return this;
        }

        /**
         * A comma-separated list of provider keys to filter the results by.
         */
        public Builder providers(JsonNullable<String> providers) {
            Utils.checkNotNull(providers, "providers");
            this.providers = providers;
            return this;
        }


        /**
         * A comma-separated list of services to filter the results by.
         */
        public Builder services(String services) {
            Utils.checkNotNull(services, "services");
            this.services = JsonNullable.of(services);
            return this;
        }

        /**
         * A comma-separated list of services to filter the results by.
         */
        public Builder services(JsonNullable<String> services) {
            Utils.checkNotNull(services, "services");
            this.services = services;
            return this;
        }


        /**
         * A comma-separated list of resources to filter the results by.
         */
        public Builder resources(String resources) {
            Utils.checkNotNull(resources, "resources");
            this.resources = JsonNullable.of(resources);
            return this;
        }

        /**
         * A comma-separated list of resources to filter the results by.
         */
        public Builder resources(JsonNullable<String> resources) {
            Utils.checkNotNull(resources, "resources");
            this.resources = resources;
            return this;
        }


        /**
         * A comma-separated list of child resources to filter the results by.
         */
        public Builder childResources(String childResources) {
            Utils.checkNotNull(childResources, "childResources");
            this.childResources = JsonNullable.of(childResources);
            return this;
        }

        /**
         * A comma-separated list of child resources to filter the results by.
         */
        public Builder childResources(JsonNullable<String> childResources) {
            Utils.checkNotNull(childResources, "childResources");
            this.childResources = childResources;
            return this;
        }


        /**
         * A comma-separated list of sub resources to filter the results by.
         */
        public Builder subResources(String subResources) {
            Utils.checkNotNull(subResources, "subResources");
            this.subResources = JsonNullable.of(subResources);
            return this;
        }

        /**
         * A comma-separated list of sub resources to filter the results by.
         */
        public Builder subResources(JsonNullable<String> subResources) {
            Utils.checkNotNull(subResources, "subResources");
            this.subResources = subResources;
            return this;
        }


        /**
         * A comma-separated list of actions to filter the results by.
         */
        public Builder actions(String actions) {
            Utils.checkNotNull(actions, "actions");
            this.actions = JsonNullable.of(actions);
            return this;
        }

        /**
         * A comma-separated list of actions to filter the results by.
         */
        public Builder actions(JsonNullable<String> actions) {
            Utils.checkNotNull(actions, "actions");
            this.actions = actions;
            return this;
        }


        /**
         * A comma-separated list of status codes to filter the results by.
         */
        public Builder statusCodes(String statusCodes) {
            Utils.checkNotNull(statusCodes, "statusCodes");
            this.statusCodes = JsonNullable.of(statusCodes);
            return this;
        }

        /**
         * A comma-separated list of status codes to filter the results by.
         */
        public Builder statusCodes(JsonNullable<String> statusCodes) {
            Utils.checkNotNull(statusCodes, "statusCodes");
            this.statusCodes = statusCodes;
            return this;
        }


        /**
         * A boolean value to filter the results by success or failure.
         */
        public Builder success(boolean success) {
            Utils.checkNotNull(success, "success");
            this.success = JsonNullable.of(success);
            return this;
        }

        /**
         * A boolean value to filter the results by success or failure.
         */
        public Builder success(JsonNullable<Boolean> success) {
            Utils.checkNotNull(success, "success");
            this.success = success;
            return this;
        }

        public Filter build() {

            return new Filter(
                accountIds, startDate, endDate,
                requestIds, httpMethods, providers,
                services, resources, childResources,
                subResources, actions, statusCodes,
                success);
        }

    }
}
