/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


public class Files {
    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * The name associated with this file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The description of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    /**
     * The size of this file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("size")
    private JsonNullable<Double> size;

    /**
     * The url of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("url")
    private JsonNullable<String> url;

    /**
     * The file format of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_format")
    private JsonNullable<? extends FilesFileFormat> fileFormat;

    /**
     * The path where the file is stored
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("path")
    private JsonNullable<String> path;

    /**
     * The user ID of owner of this file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("owner_id")
    private JsonNullable<String> ownerId;

    /**
     * List of supported export formats
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("export_formats")
    private JsonNullable<? extends List<String>> exportFormats;

    /**
     * Default download format
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("default_download_format")
    private JsonNullable<String> defaultDownloadFormat;

    /**
     * Provider's unique identifier of the owner of this file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_owner_id")
    private JsonNullable<String> remoteOwnerId;

    /**
     * The parent folder ID associated with this file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("folder_id")
    private JsonNullable<String> folderId;

    /**
     * Provider's unique identifier of the parent folder associated with this file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_folder_id")
    private JsonNullable<String> remoteFolderId;

    /**
     * The parent drive ID associated with this file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("drive_id")
    private JsonNullable<String> driveId;

    /**
     * Provider's unique identifier of the parent drive associated with this file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_drive_id")
    private JsonNullable<String> remoteDriveId;

    /**
     * The created date of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The last updated date of the file
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    /**
     * Whether the file has content
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("has_content")
    private JsonNullable<? extends HasContent> hasContent;

    /**
     * Whether the file has children
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("has_children")
    private JsonNullable<? extends HasChildren> hasChildren;

    /**
     * List of containing parent Folder IDs in descending order
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("all_parent_folder_ids")
    private JsonNullable<? extends List<String>> allParentFolderIds;

    @JsonCreator
    public Files(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("size") JsonNullable<Double> size,
            @JsonProperty("url") JsonNullable<String> url,
            @JsonProperty("file_format") JsonNullable<? extends FilesFileFormat> fileFormat,
            @JsonProperty("path") JsonNullable<String> path,
            @JsonProperty("owner_id") JsonNullable<String> ownerId,
            @JsonProperty("export_formats") JsonNullable<? extends List<String>> exportFormats,
            @JsonProperty("default_download_format") JsonNullable<String> defaultDownloadFormat,
            @JsonProperty("remote_owner_id") JsonNullable<String> remoteOwnerId,
            @JsonProperty("folder_id") JsonNullable<String> folderId,
            @JsonProperty("remote_folder_id") JsonNullable<String> remoteFolderId,
            @JsonProperty("drive_id") JsonNullable<String> driveId,
            @JsonProperty("remote_drive_id") JsonNullable<String> remoteDriveId,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt,
            @JsonProperty("has_content") JsonNullable<? extends HasContent> hasContent,
            @JsonProperty("has_children") JsonNullable<? extends HasChildren> hasChildren,
            @JsonProperty("all_parent_folder_ids") JsonNullable<? extends List<String>> allParentFolderIds) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(size, "size");
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(fileFormat, "fileFormat");
        Utils.checkNotNull(path, "path");
        Utils.checkNotNull(ownerId, "ownerId");
        Utils.checkNotNull(exportFormats, "exportFormats");
        Utils.checkNotNull(defaultDownloadFormat, "defaultDownloadFormat");
        Utils.checkNotNull(remoteOwnerId, "remoteOwnerId");
        Utils.checkNotNull(folderId, "folderId");
        Utils.checkNotNull(remoteFolderId, "remoteFolderId");
        Utils.checkNotNull(driveId, "driveId");
        Utils.checkNotNull(remoteDriveId, "remoteDriveId");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(hasContent, "hasContent");
        Utils.checkNotNull(hasChildren, "hasChildren");
        Utils.checkNotNull(allParentFolderIds, "allParentFolderIds");
        this.id = id;
        this.remoteId = remoteId;
        this.name = name;
        this.description = description;
        this.size = size;
        this.url = url;
        this.fileFormat = fileFormat;
        this.path = path;
        this.ownerId = ownerId;
        this.exportFormats = exportFormats;
        this.defaultDownloadFormat = defaultDownloadFormat;
        this.remoteOwnerId = remoteOwnerId;
        this.folderId = folderId;
        this.remoteFolderId = remoteFolderId;
        this.driveId = driveId;
        this.remoteDriveId = remoteDriveId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.hasContent = hasContent;
        this.hasChildren = hasChildren;
        this.allParentFolderIds = allParentFolderIds;
    }
    
    public Files() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * The name associated with this file
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The description of the file
     */
    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    /**
     * The size of this file
     */
    @JsonIgnore
    public JsonNullable<Double> size() {
        return size;
    }

    /**
     * The url of the file
     */
    @JsonIgnore
    public JsonNullable<String> url() {
        return url;
    }

    /**
     * The file format of the file
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<FilesFileFormat> fileFormat() {
        return (JsonNullable<FilesFileFormat>) fileFormat;
    }

    /**
     * The path where the file is stored
     */
    @JsonIgnore
    public JsonNullable<String> path() {
        return path;
    }

    /**
     * The user ID of owner of this file
     */
    @JsonIgnore
    public JsonNullable<String> ownerId() {
        return ownerId;
    }

    /**
     * List of supported export formats
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> exportFormats() {
        return (JsonNullable<List<String>>) exportFormats;
    }

    /**
     * Default download format
     */
    @JsonIgnore
    public JsonNullable<String> defaultDownloadFormat() {
        return defaultDownloadFormat;
    }

    /**
     * Provider's unique identifier of the owner of this file
     */
    @JsonIgnore
    public JsonNullable<String> remoteOwnerId() {
        return remoteOwnerId;
    }

    /**
     * The parent folder ID associated with this file
     */
    @JsonIgnore
    public JsonNullable<String> folderId() {
        return folderId;
    }

    /**
     * Provider's unique identifier of the parent folder associated with this file
     */
    @JsonIgnore
    public JsonNullable<String> remoteFolderId() {
        return remoteFolderId;
    }

    /**
     * The parent drive ID associated with this file
     */
    @JsonIgnore
    public JsonNullable<String> driveId() {
        return driveId;
    }

    /**
     * Provider's unique identifier of the parent drive associated with this file
     */
    @JsonIgnore
    public JsonNullable<String> remoteDriveId() {
        return remoteDriveId;
    }

    /**
     * The created date of the file
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The last updated date of the file
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    /**
     * Whether the file has content
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HasContent> hasContent() {
        return (JsonNullable<HasContent>) hasContent;
    }

    /**
     * Whether the file has children
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HasChildren> hasChildren() {
        return (JsonNullable<HasChildren>) hasChildren;
    }

    /**
     * List of containing parent Folder IDs in descending order
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> allParentFolderIds() {
        return (JsonNullable<List<String>>) allParentFolderIds;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier
     */
    public Files withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public Files withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Files withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public Files withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * The name associated with this file
     */
    public Files withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The name associated with this file
     */
    public Files withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The description of the file
     */
    public Files withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    /**
     * The description of the file
     */
    public Files withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * The size of this file
     */
    public Files withSize(double size) {
        Utils.checkNotNull(size, "size");
        this.size = JsonNullable.of(size);
        return this;
    }

    /**
     * The size of this file
     */
    public Files withSize(JsonNullable<Double> size) {
        Utils.checkNotNull(size, "size");
        this.size = size;
        return this;
    }

    /**
     * The url of the file
     */
    public Files withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of(url);
        return this;
    }

    /**
     * The url of the file
     */
    public Files withUrl(JsonNullable<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    /**
     * The file format of the file
     */
    public Files withFileFormat(FilesFileFormat fileFormat) {
        Utils.checkNotNull(fileFormat, "fileFormat");
        this.fileFormat = JsonNullable.of(fileFormat);
        return this;
    }

    /**
     * The file format of the file
     */
    public Files withFileFormat(JsonNullable<? extends FilesFileFormat> fileFormat) {
        Utils.checkNotNull(fileFormat, "fileFormat");
        this.fileFormat = fileFormat;
        return this;
    }

    /**
     * The path where the file is stored
     */
    public Files withPath(String path) {
        Utils.checkNotNull(path, "path");
        this.path = JsonNullable.of(path);
        return this;
    }

    /**
     * The path where the file is stored
     */
    public Files withPath(JsonNullable<String> path) {
        Utils.checkNotNull(path, "path");
        this.path = path;
        return this;
    }

    /**
     * The user ID of owner of this file
     */
    public Files withOwnerId(String ownerId) {
        Utils.checkNotNull(ownerId, "ownerId");
        this.ownerId = JsonNullable.of(ownerId);
        return this;
    }

    /**
     * The user ID of owner of this file
     */
    public Files withOwnerId(JsonNullable<String> ownerId) {
        Utils.checkNotNull(ownerId, "ownerId");
        this.ownerId = ownerId;
        return this;
    }

    /**
     * List of supported export formats
     */
    public Files withExportFormats(List<String> exportFormats) {
        Utils.checkNotNull(exportFormats, "exportFormats");
        this.exportFormats = JsonNullable.of(exportFormats);
        return this;
    }

    /**
     * List of supported export formats
     */
    public Files withExportFormats(JsonNullable<? extends List<String>> exportFormats) {
        Utils.checkNotNull(exportFormats, "exportFormats");
        this.exportFormats = exportFormats;
        return this;
    }

    /**
     * Default download format
     */
    public Files withDefaultDownloadFormat(String defaultDownloadFormat) {
        Utils.checkNotNull(defaultDownloadFormat, "defaultDownloadFormat");
        this.defaultDownloadFormat = JsonNullable.of(defaultDownloadFormat);
        return this;
    }

    /**
     * Default download format
     */
    public Files withDefaultDownloadFormat(JsonNullable<String> defaultDownloadFormat) {
        Utils.checkNotNull(defaultDownloadFormat, "defaultDownloadFormat");
        this.defaultDownloadFormat = defaultDownloadFormat;
        return this;
    }

    /**
     * Provider's unique identifier of the owner of this file
     */
    public Files withRemoteOwnerId(String remoteOwnerId) {
        Utils.checkNotNull(remoteOwnerId, "remoteOwnerId");
        this.remoteOwnerId = JsonNullable.of(remoteOwnerId);
        return this;
    }

    /**
     * Provider's unique identifier of the owner of this file
     */
    public Files withRemoteOwnerId(JsonNullable<String> remoteOwnerId) {
        Utils.checkNotNull(remoteOwnerId, "remoteOwnerId");
        this.remoteOwnerId = remoteOwnerId;
        return this;
    }

    /**
     * The parent folder ID associated with this file
     */
    public Files withFolderId(String folderId) {
        Utils.checkNotNull(folderId, "folderId");
        this.folderId = JsonNullable.of(folderId);
        return this;
    }

    /**
     * The parent folder ID associated with this file
     */
    public Files withFolderId(JsonNullable<String> folderId) {
        Utils.checkNotNull(folderId, "folderId");
        this.folderId = folderId;
        return this;
    }

    /**
     * Provider's unique identifier of the parent folder associated with this file
     */
    public Files withRemoteFolderId(String remoteFolderId) {
        Utils.checkNotNull(remoteFolderId, "remoteFolderId");
        this.remoteFolderId = JsonNullable.of(remoteFolderId);
        return this;
    }

    /**
     * Provider's unique identifier of the parent folder associated with this file
     */
    public Files withRemoteFolderId(JsonNullable<String> remoteFolderId) {
        Utils.checkNotNull(remoteFolderId, "remoteFolderId");
        this.remoteFolderId = remoteFolderId;
        return this;
    }

    /**
     * The parent drive ID associated with this file
     */
    public Files withDriveId(String driveId) {
        Utils.checkNotNull(driveId, "driveId");
        this.driveId = JsonNullable.of(driveId);
        return this;
    }

    /**
     * The parent drive ID associated with this file
     */
    public Files withDriveId(JsonNullable<String> driveId) {
        Utils.checkNotNull(driveId, "driveId");
        this.driveId = driveId;
        return this;
    }

    /**
     * Provider's unique identifier of the parent drive associated with this file
     */
    public Files withRemoteDriveId(String remoteDriveId) {
        Utils.checkNotNull(remoteDriveId, "remoteDriveId");
        this.remoteDriveId = JsonNullable.of(remoteDriveId);
        return this;
    }

    /**
     * Provider's unique identifier of the parent drive associated with this file
     */
    public Files withRemoteDriveId(JsonNullable<String> remoteDriveId) {
        Utils.checkNotNull(remoteDriveId, "remoteDriveId");
        this.remoteDriveId = remoteDriveId;
        return this;
    }

    /**
     * The created date of the file
     */
    public Files withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The created date of the file
     */
    public Files withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The last updated date of the file
     */
    public Files withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The last updated date of the file
     */
    public Files withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    /**
     * Whether the file has content
     */
    public Files withHasContent(HasContent hasContent) {
        Utils.checkNotNull(hasContent, "hasContent");
        this.hasContent = JsonNullable.of(hasContent);
        return this;
    }

    /**
     * Whether the file has content
     */
    public Files withHasContent(JsonNullable<? extends HasContent> hasContent) {
        Utils.checkNotNull(hasContent, "hasContent");
        this.hasContent = hasContent;
        return this;
    }

    /**
     * Whether the file has children
     */
    public Files withHasChildren(HasChildren hasChildren) {
        Utils.checkNotNull(hasChildren, "hasChildren");
        this.hasChildren = JsonNullable.of(hasChildren);
        return this;
    }

    /**
     * Whether the file has children
     */
    public Files withHasChildren(JsonNullable<? extends HasChildren> hasChildren) {
        Utils.checkNotNull(hasChildren, "hasChildren");
        this.hasChildren = hasChildren;
        return this;
    }

    /**
     * List of containing parent Folder IDs in descending order
     */
    public Files withAllParentFolderIds(List<String> allParentFolderIds) {
        Utils.checkNotNull(allParentFolderIds, "allParentFolderIds");
        this.allParentFolderIds = JsonNullable.of(allParentFolderIds);
        return this;
    }

    /**
     * List of containing parent Folder IDs in descending order
     */
    public Files withAllParentFolderIds(JsonNullable<? extends List<String>> allParentFolderIds) {
        Utils.checkNotNull(allParentFolderIds, "allParentFolderIds");
        this.allParentFolderIds = allParentFolderIds;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Files other = (Files) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.remoteId, other.remoteId) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.size, other.size) &&
            Utils.enhancedDeepEquals(this.url, other.url) &&
            Utils.enhancedDeepEquals(this.fileFormat, other.fileFormat) &&
            Utils.enhancedDeepEquals(this.path, other.path) &&
            Utils.enhancedDeepEquals(this.ownerId, other.ownerId) &&
            Utils.enhancedDeepEquals(this.exportFormats, other.exportFormats) &&
            Utils.enhancedDeepEquals(this.defaultDownloadFormat, other.defaultDownloadFormat) &&
            Utils.enhancedDeepEquals(this.remoteOwnerId, other.remoteOwnerId) &&
            Utils.enhancedDeepEquals(this.folderId, other.folderId) &&
            Utils.enhancedDeepEquals(this.remoteFolderId, other.remoteFolderId) &&
            Utils.enhancedDeepEquals(this.driveId, other.driveId) &&
            Utils.enhancedDeepEquals(this.remoteDriveId, other.remoteDriveId) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt) &&
            Utils.enhancedDeepEquals(this.hasContent, other.hasContent) &&
            Utils.enhancedDeepEquals(this.hasChildren, other.hasChildren) &&
            Utils.enhancedDeepEquals(this.allParentFolderIds, other.allParentFolderIds);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, remoteId, name,
            description, size, url,
            fileFormat, path, ownerId,
            exportFormats, defaultDownloadFormat, remoteOwnerId,
            folderId, remoteFolderId, driveId,
            remoteDriveId, createdAt, updatedAt,
            hasContent, hasChildren, allParentFolderIds);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Files.class,
                "id", id,
                "remoteId", remoteId,
                "name", name,
                "description", description,
                "size", size,
                "url", url,
                "fileFormat", fileFormat,
                "path", path,
                "ownerId", ownerId,
                "exportFormats", exportFormats,
                "defaultDownloadFormat", defaultDownloadFormat,
                "remoteOwnerId", remoteOwnerId,
                "folderId", folderId,
                "remoteFolderId", remoteFolderId,
                "driveId", driveId,
                "remoteDriveId", remoteDriveId,
                "createdAt", createdAt,
                "updatedAt", updatedAt,
                "hasContent", hasContent,
                "hasChildren", hasChildren,
                "allParentFolderIds", allParentFolderIds);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> remoteId = JsonNullable.undefined();

        private JsonNullable<String> name = JsonNullable.undefined();

        private JsonNullable<String> description = JsonNullable.undefined();

        private JsonNullable<Double> size = JsonNullable.undefined();

        private JsonNullable<String> url = JsonNullable.undefined();

        private JsonNullable<? extends FilesFileFormat> fileFormat = JsonNullable.undefined();

        private JsonNullable<String> path = JsonNullable.undefined();

        private JsonNullable<String> ownerId = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> exportFormats = JsonNullable.undefined();

        private JsonNullable<String> defaultDownloadFormat = JsonNullable.undefined();

        private JsonNullable<String> remoteOwnerId = JsonNullable.undefined();

        private JsonNullable<String> folderId = JsonNullable.undefined();

        private JsonNullable<String> remoteFolderId = JsonNullable.undefined();

        private JsonNullable<String> driveId = JsonNullable.undefined();

        private JsonNullable<String> remoteDriveId = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private JsonNullable<? extends HasContent> hasContent = JsonNullable.undefined();

        private JsonNullable<? extends HasChildren> hasChildren = JsonNullable.undefined();

        private JsonNullable<? extends List<String>> allParentFolderIds = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }


        /**
         * The name associated with this file
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The name associated with this file
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }


        /**
         * The description of the file
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        /**
         * The description of the file
         */
        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        /**
         * The size of this file
         */
        public Builder size(double size) {
            Utils.checkNotNull(size, "size");
            this.size = JsonNullable.of(size);
            return this;
        }

        /**
         * The size of this file
         */
        public Builder size(JsonNullable<Double> size) {
            Utils.checkNotNull(size, "size");
            this.size = size;
            return this;
        }


        /**
         * The url of the file
         */
        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of(url);
            return this;
        }

        /**
         * The url of the file
         */
        public Builder url(JsonNullable<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }


        /**
         * The file format of the file
         */
        public Builder fileFormat(FilesFileFormat fileFormat) {
            Utils.checkNotNull(fileFormat, "fileFormat");
            this.fileFormat = JsonNullable.of(fileFormat);
            return this;
        }

        /**
         * The file format of the file
         */
        public Builder fileFormat(JsonNullable<? extends FilesFileFormat> fileFormat) {
            Utils.checkNotNull(fileFormat, "fileFormat");
            this.fileFormat = fileFormat;
            return this;
        }


        /**
         * The path where the file is stored
         */
        public Builder path(String path) {
            Utils.checkNotNull(path, "path");
            this.path = JsonNullable.of(path);
            return this;
        }

        /**
         * The path where the file is stored
         */
        public Builder path(JsonNullable<String> path) {
            Utils.checkNotNull(path, "path");
            this.path = path;
            return this;
        }


        /**
         * The user ID of owner of this file
         */
        public Builder ownerId(String ownerId) {
            Utils.checkNotNull(ownerId, "ownerId");
            this.ownerId = JsonNullable.of(ownerId);
            return this;
        }

        /**
         * The user ID of owner of this file
         */
        public Builder ownerId(JsonNullable<String> ownerId) {
            Utils.checkNotNull(ownerId, "ownerId");
            this.ownerId = ownerId;
            return this;
        }


        /**
         * List of supported export formats
         */
        public Builder exportFormats(List<String> exportFormats) {
            Utils.checkNotNull(exportFormats, "exportFormats");
            this.exportFormats = JsonNullable.of(exportFormats);
            return this;
        }

        /**
         * List of supported export formats
         */
        public Builder exportFormats(JsonNullable<? extends List<String>> exportFormats) {
            Utils.checkNotNull(exportFormats, "exportFormats");
            this.exportFormats = exportFormats;
            return this;
        }


        /**
         * Default download format
         */
        public Builder defaultDownloadFormat(String defaultDownloadFormat) {
            Utils.checkNotNull(defaultDownloadFormat, "defaultDownloadFormat");
            this.defaultDownloadFormat = JsonNullable.of(defaultDownloadFormat);
            return this;
        }

        /**
         * Default download format
         */
        public Builder defaultDownloadFormat(JsonNullable<String> defaultDownloadFormat) {
            Utils.checkNotNull(defaultDownloadFormat, "defaultDownloadFormat");
            this.defaultDownloadFormat = defaultDownloadFormat;
            return this;
        }


        /**
         * Provider's unique identifier of the owner of this file
         */
        public Builder remoteOwnerId(String remoteOwnerId) {
            Utils.checkNotNull(remoteOwnerId, "remoteOwnerId");
            this.remoteOwnerId = JsonNullable.of(remoteOwnerId);
            return this;
        }

        /**
         * Provider's unique identifier of the owner of this file
         */
        public Builder remoteOwnerId(JsonNullable<String> remoteOwnerId) {
            Utils.checkNotNull(remoteOwnerId, "remoteOwnerId");
            this.remoteOwnerId = remoteOwnerId;
            return this;
        }


        /**
         * The parent folder ID associated with this file
         */
        public Builder folderId(String folderId) {
            Utils.checkNotNull(folderId, "folderId");
            this.folderId = JsonNullable.of(folderId);
            return this;
        }

        /**
         * The parent folder ID associated with this file
         */
        public Builder folderId(JsonNullable<String> folderId) {
            Utils.checkNotNull(folderId, "folderId");
            this.folderId = folderId;
            return this;
        }


        /**
         * Provider's unique identifier of the parent folder associated with this file
         */
        public Builder remoteFolderId(String remoteFolderId) {
            Utils.checkNotNull(remoteFolderId, "remoteFolderId");
            this.remoteFolderId = JsonNullable.of(remoteFolderId);
            return this;
        }

        /**
         * Provider's unique identifier of the parent folder associated with this file
         */
        public Builder remoteFolderId(JsonNullable<String> remoteFolderId) {
            Utils.checkNotNull(remoteFolderId, "remoteFolderId");
            this.remoteFolderId = remoteFolderId;
            return this;
        }


        /**
         * The parent drive ID associated with this file
         */
        public Builder driveId(String driveId) {
            Utils.checkNotNull(driveId, "driveId");
            this.driveId = JsonNullable.of(driveId);
            return this;
        }

        /**
         * The parent drive ID associated with this file
         */
        public Builder driveId(JsonNullable<String> driveId) {
            Utils.checkNotNull(driveId, "driveId");
            this.driveId = driveId;
            return this;
        }


        /**
         * Provider's unique identifier of the parent drive associated with this file
         */
        public Builder remoteDriveId(String remoteDriveId) {
            Utils.checkNotNull(remoteDriveId, "remoteDriveId");
            this.remoteDriveId = JsonNullable.of(remoteDriveId);
            return this;
        }

        /**
         * Provider's unique identifier of the parent drive associated with this file
         */
        public Builder remoteDriveId(JsonNullable<String> remoteDriveId) {
            Utils.checkNotNull(remoteDriveId, "remoteDriveId");
            this.remoteDriveId = remoteDriveId;
            return this;
        }


        /**
         * The created date of the file
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The created date of the file
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * The last updated date of the file
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The last updated date of the file
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }


        /**
         * Whether the file has content
         */
        public Builder hasContent(HasContent hasContent) {
            Utils.checkNotNull(hasContent, "hasContent");
            this.hasContent = JsonNullable.of(hasContent);
            return this;
        }

        /**
         * Whether the file has content
         */
        public Builder hasContent(JsonNullable<? extends HasContent> hasContent) {
            Utils.checkNotNull(hasContent, "hasContent");
            this.hasContent = hasContent;
            return this;
        }


        /**
         * Whether the file has children
         */
        public Builder hasChildren(HasChildren hasChildren) {
            Utils.checkNotNull(hasChildren, "hasChildren");
            this.hasChildren = JsonNullable.of(hasChildren);
            return this;
        }

        /**
         * Whether the file has children
         */
        public Builder hasChildren(JsonNullable<? extends HasChildren> hasChildren) {
            Utils.checkNotNull(hasChildren, "hasChildren");
            this.hasChildren = hasChildren;
            return this;
        }


        /**
         * List of containing parent Folder IDs in descending order
         */
        public Builder allParentFolderIds(List<String> allParentFolderIds) {
            Utils.checkNotNull(allParentFolderIds, "allParentFolderIds");
            this.allParentFolderIds = JsonNullable.of(allParentFolderIds);
            return this;
        }

        /**
         * List of containing parent Folder IDs in descending order
         */
        public Builder allParentFolderIds(JsonNullable<? extends List<String>> allParentFolderIds) {
            Utils.checkNotNull(allParentFolderIds, "allParentFolderIds");
            this.allParentFolderIds = allParentFolderIds;
            return this;
        }

        public Files build() {

            return new Files(
                id, remoteId, name,
                description, size, url,
                fileFormat, path, ownerId,
                exportFormats, defaultDownloadFormat, remoteOwnerId,
                folderId, remoteFolderId, driveId,
                remoteDriveId, createdAt, updatedAt,
                hasContent, hasChildren, allParentFolderIds);
        }

    }
}
